<%@ Page Title="Open with Web Application" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ApplicationMgr.aspx.cs" Inherits="GladinetPayFlow.ApplicationMgr" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">
        function OpenApplication(appid) {

            var ng = document.getElementById("ctl00_MainContent_ApplicationId");
            var btn = document.getElementById("ctl00_MainContent_OpenNow");
            ng.value = appid;
            btn.click();

        }

        var activewin;
        function ConfigApplication(appid) {

            activewin = new Ext.Window({
                id: 'quota_win',
                title: "<asp:Localize meta:resourcekey="str_cfgApl" runat="server">Configure Application</asp:Localize>",
                width: 580,
                height: 360,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='"+appid+"' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/ApplicationMgr.aspx";
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="box-shadow:0px 0px 0px white;">
        <div class="container-fluid">
        <div class="navbar-left">
            <asp:Label ID="Label1" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>  
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;          
                <%
                    EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                %>
            </div>
            </div>
            </nav>
    <table width="100%" align="center" border="0" cellspacing="0" cellpadding="0" id="main_content" 
         style="margin-top:10px; margin-bottom: 100px;">
        <tr>
                        <td style="height: 20px; color: #008000; border-bottom: 0px solid #e0e0e0" colspan="3">
                            <h2>
                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" Visible="False" runat="server">Available Applications:</asp:Localize></h2>
                            <div id="errmsgdiv">
                                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;"  
                                    meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                            </div>
                        </td>
                    </tr>
        <tr>
            <td >
                <table align="center" width="95%"  style="background-color: white; border: 1px solid #cccccc;">
                    
                    
                    <tr style="padding-top: 45px;">
                                <td width="140px" rowspan="2" style="padding-left: 10px;padding-top: 10px; padding-bottom: 10px; border-bottom: 1px solid #e0e0e0">
                                    <img src='/portal/images/Office-wordmark-color.png' style="width:120px;" />
                                </td>
                                <td style="font-size: 14px; padding-top: 10px;">
                                    <asp:CheckBox ID="OfficeWeb" runat="server" 
                                        />
                                    <a href="javascript:;" style="font-size: 14px; color: #008000" onclick="return false;"><b><asp:Localize meta:resourcekey="str_mctOfcWebApp" runat="server">Microsoft Office Web App</asp:Localize></b> </a>
                                </td>
                                <td align="right" style="padding-right: 10px;display:none;">
                               <asp:CheckBox ID="OfficeDef" runat="server" Text="Default viewer for supported file types"
                                       meta:resourcekey="str_dftVwrSpdFilTyp" />
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" ><asp:Localize meta:resourcekey="str_mctOfcWebAppSvrNed" runat="server">Microsoft Office Web App (Office Online Server is needed to edit word files)</asp:Localize>
                                </td>
                            </tr>
                            <tr style="padding-bottom: 30px; border-bottom: 1px solid #e0e0e0;">
                                <td colspan="3" style="padding: 2px;">
                                    <table width="100%" class="table-striped">
                                        <tr>
                                            <td width="400px" style="padding: 10px;">
                                                <asp:Localize meta:resourcekey="str_ofcSvrAcsPnt" runat="server">Office Online Server Access Point (https://myoffice.com)</asp:Localize>
                                                
                                            <p class="text-muted" style="font-size: smaller">
                                                <asp:Localize meta:resourcekey="str_levBlkToUseOfc" runat="server">(Leave it blank to use Office365 online viewer)</asp:Localize> 
                                            </p>
                                            </td>
                                            <td  style="padding: 10px;">
                                                <asp:TextBox ID="OfficeWebSvr" runat="server" CssClass="form-control"></asp:TextBox>
                                                <asp:Label ID="LOfficeWebSvr" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" width="400px" style="padding: 10px;">
                                            <asp:CheckBox ID="OfficeWebViewOnly" runat="server" Text="" />
                                            <label for="<%=OfficeWebViewOnly.ClientID %>"><asp:Localize meta:resourcekey="str_viwOnl" runat="server">View only</asp:Localize></label>                                            
                                            <span class="text-muted" style="font-size: smaller;padding-left:5px;">
                                                <asp:Localize meta:resourcekey="str_chkAppSvrDntAlwEdt" runat="server">(check if your Web App Server doesn't allow editing)</asp:Localize> 
                                            </span>
                                                <br />
                                                
                                    <asp:CheckBox ID="chkDftMsfOfcWebApp" runat="server" 
                                       Text="Use as default viewer" meta:resourcekey="str_useAsDftVwr" />
                                            </td>
                                        </tr>
                                        
                                    </table>
                                </td>
                            </tr>
                      </table>
                <% if(1 == 2){ 
                   //pixlr is no longer working and is disabled until further notice     
                   %>
                    <div style="height:30px;"></div>
                    <table align="center" width="95%"  style="background-color: white; border: 1px solid #cccccc;">
                    <tr style="padding-top: 45px;">
                                <td width="140px" rowspan="2" style="padding-top: 10px; padding-left: 10px;padding-bottom: 10px; border-bottom: 1px solid #e0e0e0">
                                    <img src='/portal/images/Pixlr_web_apps.jpg' style="width:120px;" />
                                </td>
                                <td style="font-size: 14px; padding-top: 10px;">
                                    <asp:CheckBox ID="PixlrWeb" runat="server" 
                                        />
                                    <a href="javascript:;" style="font-size: 14px; color: #008000" onclick="return false;"><b>
                                        <asp:Localize meta:resourcekey="str_pxrApp" runat="server">Pixlr Web App</asp:Localize></b> </a>
                                </td>
                            </tr>
                            <tr style="padding-bottom: 30px;">
                                <td colspan="2" >
                                    <asp:CheckBox ID="chkDftPixWebApp" runat="server" 
                                       Text="Use as default viewer" meta:resourcekey="str_useAsDftVwr" />
                                </td>
                            </tr>
                            
                            
                </table>
                <% } %>
                <asp:Panel ID="pnlOnlyOffice" runat="server" Visible="false">
                <div style="height:30px;"></div>
                    <table align="center" width="95%"  style="background-color: white; border: 1px solid #cccccc;display:none;display:none;">
                    <tr style="padding-top: 45px; ">
                                <td width="140px" rowspan="2" style="padding-top: 10px; padding-left: 10px;padding-bottom: 10px; border-bottom: 1px solid #e0e0e0">
                                    <img src='/portal/images/onlyoffice.png' style="width:120px;" />
                                </td>
                                <td style="font-size: 14px; padding-top: 10px;">
                                    <asp:CheckBox ID="OnlyOffice" runat="server" 
                                        />
                                    <a href="javascript:;" style="font-size: 14px; color: #008000" onclick="return false;"><b><asp:Localize meta:resourcekey="str_ofcWebApp" runat="server">OnlyOffice Web Application</asp:Localize></b> </a>
                                </td>
                                <td>
                               
                                </td>
                            </tr>
                            <tr style="padding-bottom: 30px;">
                                <td colspan="2" >
                                    <asp:CheckBox ID="chkDftOlyOfcWebApp" runat="server" 
                                       Text="Use as default viewer" meta:resourcekey="str_useAsDftVwr" />
                                </td>
                            </tr>
                            
                </table>
                </asp:Panel>

                 <div style="height:30px;"></div>
                    <table align="center" width="95%"  style="background-color: white; border: 1px solid #cccccc;">
                    <tr style="padding-top: 45px;">
                                <td width="140px" rowspan="2" style="padding-top: 10px; padding-left: 10px;padding-bottom: 10px; border-bottom: 1px solid #e0e0e0">
                                    <img src='/portal/images/zoho.png' style="width:120px;" />
                                </td>
                                <td style="font-size: 14px; padding-top: 10px;">
                                    <asp:CheckBox ID="ZohoApp" runat="server" 
                                        />
                                    <a href="javascript:;" style="font-size: 14px; color: #008000" onclick="return false;"><b><asp:Localize meta:resourcekey="str_zhoWebApp" runat="server">Zoho Web App</asp:Localize></b></a>
                                </td>
                                <td>
                               
                                </td>
                            </tr>
                            <tr style="padding-bottom: 30px;">
                                <td colspan="2" >
                                    <asp:CheckBox ID="chkDftZhoWebApp" runat="server" 
                                       Text="Use as default viewer" meta:resourcekey="str_useAsDftVwr" />
                                </td>
                            </tr>
                            <tr style="padding-bottom: 30px; border-bottom: 1px solid #e0e0e0">
                                <td colspan="2">
                                    <table width="100%">
                                        <tr>
                                            <td width="400px" style="padding: 10px;"><asp:Localize meta:resourcekey="str_zhoApiKey" runat="server">Zoho API Key</asp:Localize></td>
                                            <td  style="padding: 10px;">
                                                <asp:TextBox ID="ZohoApiKey" runat="server" CssClass="form-control"></asp:TextBox>
                                                <asp:Label ID="LZohoApiKey" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                             <tr>
                        <td colspan="2">
                            &nbsp;
                        </td>
                    </tr>
                            
                </table>
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="FileLoc" runat="server" />
    <div style="display: none;">
        <asp:HiddenField ID="ApplicationId" runat="server" />
        <asp:Localize meta:resourcekey="str_notconfigured" ID="NotConfig" runat="server">Not Configured</asp:Localize>
    </div>    
    <script type="text/javascript">
        var oold = window.onload;
        var idList = "#<%=chkDftMsfOfcWebApp.ClientID %>,#<%=chkDftOlyOfcWebApp.ClientID %>,#<%=chkDftZhoWebApp.ClientID %>";
        window.onload = function(){
            try{
                if(oold) oold();
                $(idList).each(function(){
                    $(this).click(function(event){
                        toggleChecks($(this));
                    });
                });
            }catch(ex){
                console.log(ex);
            }
        }
        function toggleChecks(obj){
            setTimeout(function(){
                if(obj.prop("checked")){
                    //this checkbox became checked. Uncheck the others
                    $(idList).not("#"+obj.prop("id")).prop("checked",false);
                }
            },100);
        }
    </script>
</asp:Content>
