﻿<%@ Page Title="Add Offline Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="AddWorkSpaceFolder.aspx.cs" Inherits="GladinetPayFlow.AddWorkSpaceFolder"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td
        {
            font-size: 12px;
            font-family: sans-serif,Verdana;
            font-weight: 100;
        }
        
        b
        {
            font-weight: 300;
        }
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">

        function Toggle(name) {
            var d = document.getElementById(name);
            if (d.style.display == 'none')
                d.style.display = 'block';
            else
                d.style.display = 'none';
        }

        function TogglePubUser() {
            var d = document.getElementById("pubusers");
            var t = document.getElementById("pubusersc");
            if (d.style.display == 'none') {
                d.style.display = 'block';
                t.style.height = "300px";
            } else {
                t.style.height = "10px";
                d.style.display = 'none';
            }
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        var SelItem = null;
        var cursel = "";

        function gEncodeUri(str) {

            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function onfolderselect(obj, key) {
            obj.style.backgroundColor = "#CBE1FC";
            if (SelItem) {
                SelItem.select = 0;
                SelItem.style.backgroundColor = "WHITE";
            }
            obj.select = 1;
            SelItem = obj;
            cursel = key;

            var o = document.getElementById("MainContent_CurSel");
            o.value = "/" + key;

        }

        function onparent(obj, key) {
            var uri = "AddWorkSpaceFolder.aspx?path=";

            uri += key;
            uri = gEncodeUri(uri);
            uri += "&tid=<%=HiddenInstanceId.Value %>&vdid=<%=SessionDomainId%>";
            Wait("<asp:Localize meta:resourcekey="js_string1" runat="server">Please wait...</asp:Localize>");
            window.location = uri;
        }

        function onfolderdblclick(obj, key) {
            key = decodeURIComponent(key)
            var uri = "AddWorkSpaceFolder.aspx?path=" + XSSDecode("<%=XSSUrlEncode(CurParent) %>");

            uri += key;
            uri = gEncodeUri(uri);
            uri += "&tid=<%=HiddenInstanceId.Value %>&vdid=<%=SessionDomainId%>";
            Wait("<asp:Localize meta:resourcekey="js_string1" runat="server">Please wait...</asp:Localize>");
            window.location = uri;
        }
        
        function onfolderout(obj) {

            if (obj.select == 1)
                obj.style.backgroundColor = "#CBE1FC";
            else
                obj.style.backgroundColor = "WHITE";
        }

        function OnNewFolder(parent) {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'block';
            d.style.left = (document.body.offsetWidth - 450) / 2 + "px";

            d = document.getElementById("MainContent_CurrentParentFolder");

            d.value = parent;

        }

        function OnCancelNewFolder() {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'none';
            d.style.left = (document.body.offsetWidth - 600) / 2 + "px";
        }

        function onOk() {
            var o = document.getElementById("MainContent_CurSel");
            cursel = o.value.substring(1);
            if (parent.SetSelectedFolder)
                parent.SetSelectedFolder(cursel);
            else
                parent.parent.SetSelectedFolder(cursel);
        }

        function onRoot() {
            if (parent.SetSelectedFolder)
                parent.SetSelectedFolder("");
            else
                parent.parent.SetSelectedFolder("");
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocBadFol" meta:resourcekey="str_badFol" Visible="false">Bad folder</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaFolCon" meta:resourcekey="str_faiToLoaFolCon" Visible="false">Failed to load folder content:</asp:Localize>
<asp:Localize runat="server" ID="LocMisTeaFolId" meta:resourcekey="str_misTeaFolId" Visible="false">Missing team folder id</asp:Localize>
 
    <table width="100%" height="100%" align="center" cellpadding="0" cellspacing="0"  
        style="background-color: WHITE;">
        <tr>
            <td colspan="2" style="padding: 5px; border-bottom:0px solid #f0f0f0; height:30px; ">
                <table width="100%">
                    <tr>
                        <td width="150px">
                             <% if (!string.IsNullOrEmpty(CurParent) && CurParent.Length > 1)
               {%>
            
                <table>
                    <tr>
                        <td width="18px">
                            	
                                <span class="fa fa-menu-left" style="font-size: 24px; color:#808080;"></span> 
                            
                        </td>
                        <td>
                            <a href="javascript:;" style="font-size: 16px;color:#565656; font-weight: 100;" onclick="onparent(this, Ext.util.Format.htmlDecode('<%:PrevParent%>'));return false;">
                                <asp:Localize ID="Localize4" meta:resourcekey="asp_string3" runat="server">Parent Folder</asp:Localize></a>
                        </td>
                    </tr>
                </table>
            
            <%} %>
                        </td>
                       
                        <td style="padding-right: 10px" align="left">
                            <button type="button" class="btn btn-default " data-toggle="modal" data-target="#NewFolderCtrl" style="display: none;"> <span class="fa fa-plus" aria-hidden="true"></span>&nbsp;&nbsp;<asp:Localize ID="Localize3" meta:resourcekey="asp_string4" runat="server">New Folder</asp:Localize></button>
                            <div class='idea_flex' style="display: none">
                                <asp:Localize  meta:resourcekey="asp_string7" runat="server">Double click to browse into</asp:Localize><br />
                                <asp:Localize  meta:resourcekey="asp_string8" runat="server">Click to select</asp:Localize></div>
                                  <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                              { %>
                            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                            <%} %>
                        </td>
                         
                        
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tree_container">
            <td colspan="2"  valign="top" style="border-bottom: 0px solid #d0d0d0;overflow: auto;padding-top: 5px; background-color:white;"  valign="top">
                <div style="width: 100%;overflow: auto;" id="maintree">
                    
                
                
                    <div class="row " style="width: 100%; align-content: center; margin: 0;" align="center">
                        <%if (!EmptyFolder){ %>
                    <asp:Repeater ID="FolderList" runat="server">
                        <ItemTemplate>
                            <div class="col-xs-4 col-sm-4 col-md-3 col-lg-3 text-center topbuffer">
                            <table width="95%" onmousedown="return false;" onselectstart="return false;" style="cursor: hand; padding:5px;
                                mozuserselect: none;" cellspacing="0" cellpadding="2px" onmouseover="this.style.backgroundColor='#f0f0f0';"
                                onmouseout="onfolderout(this)" ondblclick='onfolderselect(this,Ext.util.Format.htmlDecode("<%# Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Key").ToString()) %>"))'
                                onclick='onfolderdblclick(this, Ext.util.Format.htmlDecode("<%# Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Key").ToString().Replace("'","%27")) %>"))'>
                                <tr style="padding-top: 5px;">
                                    <td width="30px" style="background-color: White; cursor: pointer; padding-left: 5px; height:64px;">
                                        <span class="fa fa-folder" style="color:#a0a0a0; font-size: 48px;"></span>
                                    </td>
                                    </tr><tr>
                                    <td style="font-size: 14px; color: #565656; font-weight: 100; cursor: pointer; padding-bottom: 10px;" align="center">
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Key").ToString())%>
                                    </td>
                                </tr>
                            </table>
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>
                                    <%}else{%>
                                    <br/>
                                    <br/>
                                    <div  style="width: 300px; font-weight:100; font-size:24px; color:#565656;">
  <asp:Localize ID="Localize6" meta:resourcekey="asp_string5" runat="server">No subfolder found.</asp:Localize>
</div>
                <%}%>

                    </div>
                </div>
            </td>
        </tr>
        
        
    </table>
    <div style="position:absolute; bottom:10px; right:10px;">
        <table>
            <tr>
                 <td width="100px" style="font-size: 14px;">
                            <asp:Localize ID="Localize5" meta:resourcekey="asp_string6" runat="server">Folder Name:</asp:Localize>
                        </td>
                        <td>
                            <asp:TextBox ID="CurSel" runat="server" Width="400px" meta:resourcekey="CurSelResource1" CssClass="form-control"></asp:TextBox>
                        </td>
<td align="right" width="250px" nowrap="nowrap">
                                                                          <asp:Button ID="OkBtn"   runat="server" CssClass="btn btn-primary gladbtn gladbtn"
                Text="Add" meta:resourcekey="str_add"   
                CausesValidation=False  onclick="OkBtn_Click" />
                                            &nbsp;&nbsp;&nbsp;&nbsp;

                            <asp:Button ID="CancelBTn" Font-Size="12pt" CssClass="btn btn-default" Width="80px" runat="server" OnClientClick="parent.CloseQuickWindow();return false;"
                                Text="Cancel" Style="padding: 2px;"  CausesValidation="False"
                                meta:resourcekey="CancelBTnResource1" />
                        </td>
            </tr>
        </table>
    </div>
    <div style="height: 1px; display: none;">
        <asp:HiddenField ID="CurrentParentFolder" runat="server" />
    </div>
    
        <div id="NewFolderCtrl" class="modal fade" role="dialog">
            <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title"><asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server">Create New Folder</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <table width="100%" height="100%" align="center" style="background-color: WHITE;
                        padding: 10px;">
                        <tr>
                            <td class="InputLabel">
                                <asp:Localize ID="Localize2" meta:resourcekey="asp_string2" runat="server">New Folder Name</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="NewFolderName" runat="server" Width="95%" class="InputText" meta:resourcekey="NewFolderNameResource1" CssClass="form-control"></asp:TextBox>
                                <div style="color: #D00000">
                                    <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="NewFolderName"
                                        ErrorMessage="Folder name is required!" Display="Dynamic" CssClass="errmsg" meta:resourcekey="reqNameResource1" />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="display: none">
                                <table width="100%" align="center">
                                    <tr>
                                        <td align="left">
                                        </td>
                                        <td align="right" colspan="2" style="border-top: 0px solid #d0d0d0; padding-top: 15px;">
                                            <asp:Button ID="CancelChange" runat="server" Text="Cancel" CssClass="btn btn-default"
                                                OnClientClick="OnCancelNewFolder()" Width="120px" meta:resourcekey="CancelChangeResource1" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
      </div>
      <div class="modal-footer">
          <asp:Button ID="CreateButtonNow" runat="server" Text="Apply Change" 
                                                CssClass="btn btn-primary gladbtn gladbtn" OnClick="CreateButtonNow_Click" Width="140px" meta:resourcekey="CreateButtonNowResource1" />
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
        
        
    </div>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
     <script type="text/javascript">
         function AdjustSize() {
             var e = document.getElementById("maintree");
             e.style.height = (document.documentElement.offsetHeight - 128) + "px";

         }

         AdjustSize();
         document.body.onresize = AdjustSize;
         
    </script>
</asp:Content>
