﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="WizardAppPanel.master"
    AutoEventWireup="true" CodeBehind="SyncPerms.aspx.cs" Inherits="GladinetPayFlow.SyncPerms" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        td {
            font-size: 12px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 100;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .roundbar .x-progress-bar
        {
            border-radius: 8px 8px 8px 8px;
        }
       

        .wrapper
        {
            width:100%;
            padding: 0px;
            background-color: white;
            
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
    <script type="text/javascript">

        function OnSyncSucc(){
            var e = document.getElementById("ctl00_MainContent_OnSyncComplete");
            e.click();
        }


         function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }

        function onRetry()
        {
            window.location = window.location();
        }
        function OnPollRes(m) {
            try {

                
                
                
                if (stringStartsWith(m, "bad^")) {
                    var e = document.getElementById("PollRes");
                    e.innerHTML = m.substring(4);
                    e = document.getElementById("retrybtn");
                    e.style.display = "";
                    return;
                }
                if(m == "succeed"){
                    OnSyncSucc();
                    return;
                }
                if(m != "syncing"){
                    var e = document.getElementById("PollRes");
                    e.innerHTML = m;
                }
                
            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }

          function Poll() {

            try {
                Ext.Ajax.request({
                    url: '/management/AddUserWizard/SyncPerms.aspx?vdid=<%=SessionDomainId%>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {                        
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }
  
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocFaiToCreUse" meta:resourcekey="str_faiToCreUse" Visible="false" runat="server">Failed to create user</asp:Localize>
<asp:Localize ID="LocFaiAddUseToTheTeaFol" meta:resourcekey="str_faiAddUseToTheTeaFol" Visible="false" runat="server">Failed add user to the team folder</asp:Localize>
<asp:Localize ID="LocBadIntStaMisTarSha" meta:resourcekey="str_badIntStaMisTarSha" Visible="false" runat="server">bad internal state: missing target share</asp:Localize>
<asp:Localize ID="LocFaiToAppPer" meta:resourcekey="str_faiToAppPer" Visible="false" runat="server">Failed to apply permission</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToAddUseExcLicQuo" meta:resourcekey="str_faiToAddUseExcLicQuo" Visible="false">Failed to add user, exceed license quota</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToSetPer" meta:resourcekey="str_faiToSetPer" Visible="false">Failed to set permissions</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToRetNewCreUse" meta:resourcekey="str_faiToRetNewCreUse" Visible="false">Failed to retrieve newly created user</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToRetNewCreProGro" meta:resourcekey="str_faiToRetNewCreProGro" Visible="false">Failed to retrieve newly created proxied group</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToRetPerSet" meta:resourcekey="str_faiToRetPerSet" Visible="false">Failed to retrieve permission setting</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToResFolPer" meta:resourcekey="str_faiToResFolPer" Visible="false">Failed to reset folder permissions</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToResTeaFolPer" meta:resourcekey="str_faiToResTeaFolPer" Visible="false">Failed to reset team folder permissions</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToAppPerTeaFolNotFou" meta:resourcekey="str_faiToAppPerTeaFolNotFou" Visible="false">Failed to apply permissions: team folder not found</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToAppPerTeaFolNotFou2" meta:resourcekey="str_faiToAppPerTeaFolNotFou2" Visible="false">Failed to apply permissions: team folder not found -2</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToAppPerTeaFolNotFou1" meta:resourcekey="str_faiToAppPerTeaFolNotFou1" Visible="false">Failed to apply permissions: team folder not found -1</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaSynRes" meta:resourcekey="str_faiToLoaSynRes" Visible="false">Fail to load sync result</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToQueShaInfShaNotFou" meta:resourcekey="str_faiToQueShaInfShaNotFou" Visible="false">Failed to query share info: share not found</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToQueShaInf" meta:resourcekey="str_faiToQueShaInf" Visible="false">Failed to query share info</asp:Localize>
<asp:Localize runat="server" ID="LocSelTeaFolDoeNotHavReqLocInf" meta:resourcekey="str_selTeaFolDoeNotHavReqLocInf" Visible="false">Selected team folder does not have requested location information</asp:Localize>
<asp:Localize runat="server" ID="LocNoSelTeaFolToSyn" meta:resourcekey="str_noSelTeaFolToSyn" Visible="false">No selected team folder to sync</asp:Localize>
<asp:Localize runat="server" ID="LocNoSerAgeToSyn" meta:resourcekey="str_noSerAgeToSyn" Visible="false">No server agent to sync</asp:Localize> 

    <div class="wrapper">
        <table cellspacing="0" width="100%" align="center">
            <tr>
                <td align="center">
                    <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                      { %>
                    <div id="errmsgdiv">
                        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" ></asp:Label>
                    </div>
                    <%} %>
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; height: 400px; vertical-align: top; overflow: hidden;">
                    <asp:Panel ID="SyncPanel" runat="server">
                                    <div style="padding:20px;  ">
                                    <table cellspacing="0" cellpadding="0" width="100%" style="background-color: White; overflow: hidden;">
                                        <tr>
                                            <td style="height:200px" align="center" valign="middle">
                                                <img src="/webui/images/loading-home.gif" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:18px; color:#565656; font-weight:100" align="center" id="PollRes">
                                                <asp:Localize ID="Localize8" meta:resourcekey="Syncing" runat="server"
                                                        Text="Syncing permission from server agent"></asp:Localize>
                                            </td>
                                        </tr>
                                    </table>
                                        </div>
                                </asp:Panel>
                        <asp:Panel ID="SettingPanel" runat="server" Visible="false" meta:resourcekey="SettingPanelResource1">
                            <table cellspacing="0" cellpadding="0"  width="100%" style="background-color: White;
                        height: 440px; overflow: hidden;">
                            <tr>
                                <td  class="x-panel-header-light" style="background-color: #f8f8f8;vertical-align: top; border-right: 1px dashed #c0c0c0; display: none;">
                                    <table width="100%" style="padding:8px;">
                                        <tr style="display: none">
                                            <td>
                                                <h3>
                                                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string4" runat="server">Click 'Finish' to start processing migration tasks</asp:Localize></h3>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox ID="MigrateUser" runat="server" Text="Migrate User/Folder Permission"
                                                    Checked="True" meta:resourcekey="MigrateUserResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-top: 20px; color: #008000;">
                                                <asp:Localize meta:resourcekey="asp_string1" runat="server">The user(s) selected from the list will be migrated to your cloud account, when "Migrate Share and Folder Permissions" is checked.</asp:Localize>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-top: 20px; color: #008000;">
                                                <asp:Localize meta:resourcekey="asp_string2" runat="server">Note: The migrated user(s) will be included in your account user quota.</asp:Localize>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" style="padding-top: 10px; display: <%=(SessionHasStorage )? "" :"none"%>;">
                                                <asp:CheckBox ID="DisablShareHomeDir" runat="server" Text="Disable sharing home directory content with external party"
                                                    meta:resourcekey="DisablShareHomeDirResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" style="padding-top: 10px;">
                                                <asp:CheckBox ID="CreateDefaultDir" Checked="True" runat="server" Text="Create default folder(Documents, Pictures)"
                                                    meta:resourcekey="CreateDefaultDirResource1" />
                                            </td>
                                        </tr>
                                        <tr style="display: none;">
                                            <td colspan="2" style="padding-top: 10px;">
                                                <asp:CheckBox ID="VisibleHomeDir" runat="server" Text="Make user's home directory visible to administrator"
                                                    meta:resourcekey="VisibleHomeDirResource1" />
                                            </td>
                                        </tr>
                                        <tr style="display: none;">
                                            <td colspan="2" style="padding-right: 40px;">
                                                <asp:Label ID="Pricing" runat="server" Font-Italic="True" Font-Size="14px" Font-Underline="True"
                                                    ForeColor="#009000" meta:resourcekey="PricingResource1"></asp:Label>
                                                <span style="color: #808080;display:none;">
                                                    <asp:Localize meta:resourcekey="asp_string3" runat="server">administrator will see the users' home directory under administrator's "Users" directory.</asp:Localize></span><br />
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td  style="vertical-align: top; background-color:white; padding:5px;" id="grid-example">
                                </td>
                            </tr>
                                </table>
                        </asp:Panel>
                        <asp:Panel ID="SuccPanel" runat="server" Visible="False" meta:resourcekey="SuccPanelResource1">
                            <table cellspacing="0" cellpadding="0"  width="100%" style="background-color: White;
                        height: 440px; overflow: hidden;">
                            <tr>
                                <td style="font-size: 18px; font-weight: 100; color: #565656;" align="center">
                                    
                                        <asp:Localize meta:resourcekey="asp_string5" runat="server">Share and Folder permissions has been synchronized successfully.</asp:Localize>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-top: 20px">
                                    
                                </td>
                            </tr>
                                  </table>
                        </asp:Panel>
                  
                </td>
            </tr>
        </table>
    </div>

     <div  style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle; margin: 0;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
            <tr>
                <td>
                    <%if (SettingPanel.Visible){ %>
                    <asp:CheckBox Checked="True" ID="ShareLevel" runat="server" Text="Share Level" meta:resourcekey="str_shrLvl" />
                    <asp:CheckBox Checked="True" ID="FolderLevel" runat="server" Text="Folder Level" meta:resourcekey="str_fldLvl" />
                    <%} %>
                </td>
                <td align="right" style="padding-right:60px;">
                    <%if (NormalBtn.Visible){ %>
                    <asp:Button ID="LinkButton1" runat="server" Text="Back" OnClientClick="Wait('Back')"
                        CssClass="btn btn-default" OnClick="LinkButton1_Click" meta:resourcekey="LinkButton1Resource1">
                    </asp:Button>
                     <%if (SettingPanel.Visible){ %>
                    <asp:Button ID="ContinueBth" runat="server" Text="Sync" OnClientClick="Wait('Applying Settings')"
                        CssClass="btn btn-primary gladbtn gladbtn" OnClick="ContinueBth_Click" meta:resourcekey="ContinueBthResource1">
                    </asp:Button>
                    <%} %>
                      <%if (SyncPanel.Visible){ %>
                        <button class="btn btn-primary gladbtn" style="display:none;" id="retrybtn" onclick="onRetry();return false;"><asp:Localize runat="server" meta:resourcekey="str_Ret">Retry</asp:Localize></button>
                        <%} %>
                    <asp:Button ID="LinkButtonCancel" runat="server" Text="Cancel" OnClientClick="Wait('Closing...')"
                        CssClass="btn btn-default" OnClick="LinkButtonCancel_Click" meta:resourcekey="LinkButtonCancelResource1">
                    </asp:Button>
                    <%} %>
                    <% if (ClosePanel.Visible)
                       { %>
                    <asp:Button ID="LinkButton2" runat="server" Text="Close" OnClientClick="Wait('Closing...')"
                        CssClass="btn btn-default" OnClick="LinkButtonCancel_Click" meta:resourcekey="LinkButton2Resource1">
                    </asp:Button>
                    <% } %>
                </td>
            </tr>
        </table>
    </div>
    <asp:Panel ID="NormalBtn" runat="server" meta:resourcekey="NormalBtnResource1">
    </asp:Panel>
    <asp:Panel ID="ClosePanel" runat="server" Visible="False" meta:resourcekey="ClosePanelResource1">
    </asp:Panel>
    <div style="display:none">
    <asp:LinkButton ID="OnSyncComplete" runat="server" OnClick="OnSyncSucc_Click">LinkButton</asp:LinkButton>
        </div>
    <script type="text/javascript">

  var myData = [
 <asp:Repeater ID="DeviceRepeater" runat="server" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#DataBinder.Eval(Container.DataItem,"Name") %>',
           '<%#DataBinder.Eval(Container.DataItem,"Value") %>'
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();
             <%if(SyncPanel.Visible){%>
        setTimeout("Poll()", 2000);
        <%}%>
            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'name' },
                    { name: 'sid' }
                ],
                data: myData
            });

            try {

                var grid = Ext.create('Ext.grid.Panel', {
                    store: store,
                    stripeRows: true,
                    columnLines: false,
                    border: false,
                    height: '410px',
                    columns: [

                    {
                        text: "<asp:Localize meta:resourcekey="js_string1" runat="server">User Name</asp:Localize>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'name',
                        renderer: function (value, metaData, record, rowIndex) {
                            var d = record.data;
                            return "<span style='font-weight:100;'>" + unescape(value) + "</span>"+ '<input type="checkbox" style="display:none;" checked name="uu_' + d.sid + '" value="' + d.sid + '" >';
                        }

                    }
        ],
                    renderTo: 'grid-example'
                });

           
                Ext.EventManager.onWindowResize(grid.doLayout, grid);
            } catch (e) {
            }
        });
        function RecvFindRefresh(docObj) {    
            if (docObj) {                    
                var allFrames = docObj.querySelectorAll("iframe");
                for (var i = 0; i < allFrames.length; i++) { 
                    var found = false;
                    try {       
                        var thisFrm = allFrames[i];     
                        var subDoc = thisFrm.contentDocument;    
                        var subWin = thisFrm.contentWindow;
                        if (subWin) {           
                            if (subWin.RefreshFolderPermsAspx) {
                                found = true;        
                                subWin.RefreshFolderPermsAspx();
                            }
                        }
                    } catch (ex) {}
                    if (!found) {   
                        RecvFindRefresh(subDoc);   
                    }
                }
            }
        }
        function TryCloseParentModal() {
            if (parent.CloseQuickWindow) {
                parent.CloseQuickWindow();
                RecvFindRefresh(parent.document);
            } else {
                location.href = "/portal/CloseWin.htm";
            }
        }
        <asp:Literal ID="ltlScripts" runat="server" Text="" />
    </script>
</asp:Content>
