﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="WizardAppPanel.master"
    AutoEventWireup="true" CodeBehind="CreateUserOption.aspx.cs" Inherits="GladinetPayFlow.CreateUserOption" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        *
        {
            margin: 0;
        }
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm
         {
             height: 100%;
         }
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);


        function OnPubClicked() {
            var o = document.getElementById("MainContent_LDAPHomeDrive");
            var o1 = document.getElementById("MainContent_VisibleHomeDir");
            var o2 = document.getElementById("MainContent_CreateDefaultDir");
            var o11 = document.getElementById("o1");
            var o22 = document.getElementById("o2");

            if (o.checked) {
                o1.checked = false;
                o2.checked = false;
                o11.style.display = 'none';
                o22.style.display = 'none';
            } else {
                o11.style.display = '';
                o22.style.display = '';

            }
        }

  
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocHomDri" meta:resourcekey="str_homDri" Visible="false" runat="server">Home Drive</asp:Localize>
    <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
      { %>
    <div id="errmsgdiv">
        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" 
            meta:resourcekey="ErrorMsgResource1"></asp:Label>
    </div>
    <%} %>
    <div class="wrapper">
        <table width="100%">            <tr> <td align="center" style="padding-top:60px;">
        <table cellspacing="0" width="100%" align="center" style="max-width:800px;">
            <tr>
                <td style="height: 68px;color: #808080;border-bottom: 0px solid #f0f0f0;
                    border-top: 0; border-left: 0; border-right: 0; padding-left: 1px; vertical-align: middle;
                    text-align: left; font-size: 16px;">
                    <h2 class="sectextcolor" style="font-weight:200;"><asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server">User Creation Options:</asp:Localize></h2>
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; height: auto; vertical-align: top; overflow: hidden;">
                    <table cellspacing="1" width="100%" style="background-color: White; height: auto; 
                        overflow: hidden;">
                        <tr>
                            <td valign="top">
                                <table width="100%" align="center" style="padding: 10px; font-size: 12px;">
                                    <asp:Panel ID="EnablePwdPanel" runat="server" meta:resourcekey="EnablePwdPanelResource1">
                                        <tr>
                                            <td colspan="2">
                                                <asp:CheckBox ID="SystemPwd" Checked="True" runat="server" AutoPostBack="True" Text="Let system generate password (password will be sent via email)" 
                                                    OnCheckedChanged="SystemPwd_CheckedChanged" meta:resourcekey="SystemPwdResource1" />
                                            </td>
                                        </tr>
                                        <asp:Panel ID="PwdPanel" runat="server" Visible="False" meta:resourcekey="PwdPanelResource2">
                                            <tr>
                                                <td class="InputLabel" width="50%">
                                                    <asp:Localize meta:resourcekey="asp_string2" runat="server">Password</asp:Localize>
                                                </td>
                                                <td class="InputLabel" width="50%">
                                                    <asp:Localize meta:resourcekey="asp_string3" runat="server">Re-Enter Password</asp:Localize>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID="Password" runat="server" Width="95%" TextMode="Password" class="InputText"
                                                        CssClass="form-control" meta:resourcekey="PasswordResource1"></asp:TextBox>
                                                    <div style="color: #D00000">
                                                    </div>
                                                </td>
                                                <td>
                                                    <asp:TextBox ID="Password1" runat="server" Width="95%" TextMode="Password" class="InputText"
                                                        CssClass="form-control" meta:resourcekey="Password1Resource1"></asp:TextBox>
                                                    <div style="color: #D00000">
                                                    </div>
                                                </td>
                                            </tr>
                                        </asp:Panel>
                                        <tr>
                                            <td colspan="2" style="padding-top: 10px;">
                                                <asp:CheckBox ID="MustResetPwd" Checked="True" runat="server" Text="User must change password at next logon"
                                                    meta:resourcekey="MustResetPwdResource1" />
                                            </td>
                                        </tr>
                                    </asp:Panel>
                                    <tr>
                                        <td style="padding-top: 10px; display: <%=(SessionHasStorage )? "" :"none"%>;">
                                            <asp:CheckBox ID="DisablShareHomeDir" runat="server" Text="Disable sharing home directory content with external party" Visible="False"
                                                meta:resourcekey="DisablShareHomeDirResource1" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding-top: 10px;">
                                            <asp:CheckBox ID="SendWelcomeEmailCtrl" Checked="True" runat="server" Text="Send welcome email to user after the user is created"
                                                meta:resourcekey="SendWelcomeEmailCtrlResource1" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td  style="padding-top: 10px;">
                                            <asp:CheckBox ID="CreateDefaultDir"  runat="server" Text="Create default folder(Documents, Pictures)" Visible=false
                                                meta:resourcekey="CreateDefaultDirResource1" />
                                        </td>
                                    </tr>
                                    <asp:Panel ID="PubHomePanel" runat="server" meta:resourcekey="PubHomePanelResource1">
                                        <tr>
                                            <td colspan="2" style="padding-top: 10px;" align="left">
                                                <asp:CheckBox ID="LDAPHomeDrive" runat="server" Text="Publish user's home drive" AutoPostBack="true"
                                                     meta:resourcekey="LDAPHomeDriveResource1" />
                                                <%if (LDAPHomeDrive.Checked){ %>
                                                <br />
                                                <table>
                                                    <tr>
                                                        <td style="padding-left:40px;">
                                                            <asp:CheckBox ID="RootHomeDrive" runat="server" Text="Mount user's home drive as a top level folder." meta:resourcekey="str_rotHmeDrvHlp"
                                                      />
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="RootDriveName" runat="server" CssClass="form-control" Text="Home folder" Width="150px"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                </table>
                                                
                                                <%} %>
                                            </td>
                                        </tr>
                                    </asp:Panel>
                                    <tr style="display: none;">
                                        <td style="padding-top: 10px;">
                                            <asp:CheckBox ID="VisibleHomeDir" runat="server" Text="Make user's home directory visible to administrator"
                                                meta:resourcekey="VisibleHomeDirResource1" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding-top: 10px;">
                                            <asp:CheckBox ID="ForceVersioned" runat="server"  AutoPostBack=true Visible="False"
                                                Text="Force all folder to be versioned" Checked=true
                                                meta:resourcekey="ForceVersioned" 
                                                oncheckedchanged="ForceVersioned_CheckedChanged" />
                                            
                                        </td>
                                    </tr>
                                    <tr style="display: none">
                                        <td style="padding-top: 10px;">
                                            <asp:CheckBox ID="EnableOffline" runat="server" Text="Enable offline access for all folders" 
                                                meta:resourcekey="EnableOffline" />
                                            <div class="alert alert-warning">
                                                <asp:Localize meta:resourcekey="str_offlinewarn" runat="server">This will automatically download ALL folders and files to the user’s device and automatically updated them whenever they are changed anywhere in the network. This will cause a significant increase in network traffic, especially during the initial download of all folders.</asp:Localize>
                                            </div>
                                        </td>
                                    </tr>
                                    <asp:Panel ID="RolePanel" runat="server" Visible="False">
                                                                            
                                    <tr>
                                        <td style="padding-top: 10px; display: none;">
                                            <table>
                                                <tr>
                                                    <td style="color: #565656;padding: 5px;"><h3><asp:Localize meta:resourcekey="str_assignuserrole" runat="server">Assign user to role:</asp:Localize></h3></td>
                                                    <td  style="color: #565656;padding: 5px;">
                                                        <asp:DropDownList ID="RoleList" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                                        </asp:DropDownList> 
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    </asp:Panel>
                                    <asp:Panel ID="OpenStackADAuthPanel" runat="server" Visible="False">                                    
                                    <tr>
                                        <td style="padding-top: 10px;">
                                            <asp:CheckBox ID="OpenStackADAuth" runat="server" Text="This user has OpenStack storage account tied to his Active Directory credential" meta:resourcekey="str_opnStkADAthHlp" 
                                                />
                                        </td>
                                    </tr>
                                    </asp:Panel>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                                
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td align="center">
                </td>
            </tr>
             <tr>
                            
                            <td align="right">
                                
                                    <asp:Button ID="LinkButton1" runat="server" Width="128px"
                                        OnClientClick="Wait('Back')" CssClass="btn btn-default" 
                                        OnClick="LinkButton1_Click" meta:resourcekey="LinkButton1Resource1"></asp:Button>
                                    &nbsp;&nbsp;
                                    <asp:Button ID="ContinueBth" runat="server" Width="128px"
                                        OnClientClick="Wait('Applying Settings')" CssClass="btn btn-primary gladbtn gladbtn" 
                                        OnClick="ContinueBth_Click" meta:resourcekey="ContinueBthResource1"></asp:Button>
                                    <asp:Button ID="CommitBtn" runat="server" Width="128px" Text="Commit"
                                        OnClientClick="Wait('Applying Settings')" CssClass="btn btn-primary gladbtn gladbtn" Visible="False"
                                        OnClick="ContinueBth_Click" meta:resourcekey="CommitBtnResource1"></asp:Button>

                                        &nbsp;&nbsp;
                                    <asp:Button ID="LinkButtonCancel" runat="server" Width="128px"
                                        OnClientClick="Wait('Closing...')" CssClass="btn btn-default" 
                                        OnClick="LinkButtonCancel_Click" meta:resourcekey="LinkButtonCancelResource1"></asp:Button>
                                        &nbsp;&nbsp;&nbsp;&nbsp;
                            </td>
                        </tr>
        </table>
            </td></tr></table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align:right; padding-right:64px;" align="right">
                       
                    </table>
                </div>
</asp:Content>
