﻿<%@ Page Title="Add Share - Protection" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="AddShareProtect.aspx.cs" Inherits="GladinetPayFlow.AddShareProtect" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">
        if (window.top !== window.self) {
            window.history.replaceState({ iframeState: true }, null, window.location.href + "&backhistory=1");
        }
        var _atLeastOneUserWillBeCreated = false;
        function OnClientShellCancel()
        {
            try{
                if(window.ClientShellHandler){
                    window.ClientShellHandler.CancelClose();
                    return false;
                }
            }catch(e){

            }
            Wait('Applying Settings')
            return true;
        }
        //calendar code<<<
        function fmtInpDate(dateObj) {
            //format=yyyy-MM-dd
            return dateObj.getFullYear() + '-' + (dateObj.getMonth() + 1) + '-' + dateObj.getDate();
        }
        function parseDate(str) {
            //format=MM.dd.yyyy
            var mdy = str.split('.');
            return new Date(mdy[0], mdy[1] - 1, mdy[2]);
        }
        function updateDate() {
            //override this
        }
        var gladCal = (function () {
            var wrap, label, calYear, calMonth, calDateFormat, firstDay, isIE11;
            isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
            //check global variables for calendar widget and set default localization values
            if (window.months === undefined) {
                window.months=["<asp:Localize runat="server" meta:resourcekey="str_caljan">January</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calfeb">February</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calmar">March</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calapr">April</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calmay">May</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caljun">June</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caljul">July</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calaug">August</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsep">September</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caloct">October</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calnov">November</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caldec">December</asp:Localize>"];
            }
            if (window.shortDays === undefined) {
                window.shortDays=["<asp:Localize runat="server" meta:resourcekey="str_calmon">MON</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caltue">TUE</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calwed">WED</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calthu">THU</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calfri">FRI</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsat">SAT</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsun">SUN</asp:Localize>"];
            }
            //first day of week combinations array
            var firstDayCombinations=[[0,1,2,3,4,5,6],[1,2,3,4,5,6,0],[2,3,4,5,6,0,1],[3,4,5,6,0,1,2],[4,5,6,0,1,2,3],[5,6,0,1,2,3,4],[6,0,1,2,3,4,5]];
            //DOM strings helper
            var DOMstrings={divCal:"cal",divCalQ:"#cal",monthLabel:"label",btnPrev:"prev",btnNext:"next",sunLabel:"eformSun",monLabel:"eformMon",tueLabel:"eformTue",wedLabel:"eformWed",thuLabel:"eformThu",friLabel:"eformFri",satLabel:"eformSat",tdDay:".eformDay"};
            //open function
            function open(dateFormat, x, y, firstDayOfWeek, minDate, maxDate, element, zindex) {
                //prevent to open more than one calendar
                if (document.getElementById('cal')) {
                    return false;
                }
                //init def props
                eFormMinimalDate = DateParse(minDate);
                eFormMaximalDate = DateParse(maxDate);
				console.log("maxDate:")
				console.log(eFormMaximalDate)
                eFormCalendarElement = element;
                firstDay = firstDayOfWeek;
                //set default first date of week
                if (firstDayOfWeek === undefined) {
                    firstDayOfWeek = 6;
                } else {
                    firstDayOfWeek -= 1;
                }
                //create html and push it into DOM
                var newHtml = '<div id="cal" style="top:' + y + 'px;left:' + x + 'px;z-index:' + zindex + ';"><div class="header topnavcolor"><span class="left button" id="prev">&lt;</span><span class="left hook"></span><span class="month-year" id="label">June 20&0</span><span class="right hook"></span><span class="right button" id="next">&gt;</span></div><table id="days"><tr><td id="eformSun"><asp:Localize runat="server" meta:resourcekey="str_Sun">sun</asp:Localize></td><td id="eformMon"><asp:Localize runat="server" meta:resourcekey="str_Mon">mon</asp:Localize></td><td id="eformTue"><asp:Localize runat="server" meta:resourcekey="str_Tue">tue</asp:Localize></td><td id="eformWed"><asp:Localize runat="server" meta:resourcekey="str_Wed">wed</asp:Localize></td><td id="eformThu"><asp:Localize runat="server" meta:resourcekey="str_Thu">thu</asp:Localize></td><td id="eformFri"><asp:Localize runat="server" meta:resourcekey="str_Fri">fri</asp:Localize></td><td id="eformSat"><asp:Localize runat="server" meta:resourcekey="str_Sat">sat</asp:Localize></td></tr></table><div id="cal-frame"><table class="curr"><tbody></tbody></table></div></div>';
				document.getElementsByTagName('body')[0].insertAdjacentHTML('beforeend', newHtml);
                calDateFormat = dateFormat;
                wrap = document.getElementById(DOMstrings.divCal);
                label = document.getElementById(DOMstrings.monthLabel);
                //register events
                document.getElementById(DOMstrings.btnPrev).addEventListener('click', function () { switchMonth(false); });
                document.getElementById(DOMstrings.btnNext).addEventListener('click', function () { switchMonth(true); });
                label.addEventListener('click', function () { switchMonth(null, new Date().getMonth(), new Date().getFullYear()); });
                //shorter day version labels
                var dayCombination = firstDayCombinations[firstDayOfWeek];
                document.getElementById(DOMstrings.sunLabel).textContent = window.shortDays[dayCombination[0]];
                document.getElementById(DOMstrings.monLabel).textContent = window.shortDays[dayCombination[1]];
                document.getElementById(DOMstrings.tueLabel).textContent = window.shortDays[dayCombination[2]];
                document.getElementById(DOMstrings.wedLabel).textContent = window.shortDays[dayCombination[3]];
                document.getElementById(DOMstrings.thuLabel).textContent = window.shortDays[dayCombination[4]];
                document.getElementById(DOMstrings.friLabel).textContent = window.shortDays[dayCombination[5]];
                document.getElementById(DOMstrings.satLabel).textContent = window.shortDays[dayCombination[6]];
                //fire initialization event trigger
                label.click();
            }
            //switches current month
            function switchMonth(next, month, year) {
                var curr = label.textContent.trim().split(' '), calendar, tempYear = parseInt(curr[1], 10);
                if (month === undefined) {
                    month = ((next) ? ((curr[0] === window.months[11]) ? 0 : months.indexOf(curr[0]) + 1) : ((curr[0] === window.months[0]) ? 11 : months.indexOf(curr[0]) - 1));
                }
                if (!year) {
                    if (next && month === 0) {
                        year = tempYear + 1;
                    } else if (!next && month === 11) {
                        year = tempYear - 1;
                    } else {
                        year = tempYear;
                    }
                }
                //set month and year for widget scope
                calMonth = month + 1;
                calYear = year;
                calendar = createCal(year, month);
                var curr = document.querySelector('.curr');
                curr.innerHTML = '';
                curr.appendChild(calendar.calendar());
                //disable days below minimal date
                if (eFormMinimalDate !== undefined) {
                    if (year < eFormMinimalDate.year || year <= eFormMinimalDate.year && month <= eFormMinimalDate.month - 1) {
                        var emptyCount = document.querySelector('.curr table').rows[0].querySelectorAll('td:empty').length;
                        var tdDisabled = document.querySelectorAll('.eformDay');
                        for (var i = 0; i < tdDisabled.length; ++i) {
                            if (i - emptyCount + 1 < eFormMinimalDate.day || month < eFormMinimalDate.month - 1 || year < eFormMinimalDate.year) {
                                tdDisabled[i].classList.add('eformDayDisabled');
                                tdDisabled[i].onclick = function () {
                                    return false;
                                }
                            }
                        }
                    }
                }
                //disable days above maximum date				
                if (eFormMaximalDate !== undefined) {
                    if (year > eFormMaximalDate.year || year >= eFormMaximalDate.year && month >= eFormMaximalDate.month - 1) {
                        //hide the NEVER button
                        $(".neverBtn").hide();
                        var emptyCount = document.querySelector('.curr table').rows[0].querySelectorAll('td:empty').length;
                        var tdDisabled = document.querySelectorAll('.eformDay');
                        for (var i = 0; i < tdDisabled.length; ++i) {
                            if (i - emptyCount + 1 > eFormMaximalDate.day || month > eFormMaximalDate.month - 1 || year > eFormMaximalDate.year) {
                                tdDisabled[i].classList.add('eformDayDisabled');
                                tdDisabled[i].onclick = function () {
                                    return false;
                                }
                            }
                        }
                    }
                }
                label.textContent = calendar.label;
            }
            //main calendar function. Creates calendar itself and stores into cache
            function createCal(year, month) {
                var day = 1, i, j, haveDays = true,
                    startDay = new Date(year, month, day).getDay(),
                    daysInMonths = [31, (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
                    calendar = [];
                startDay -= firstDay;
                if (startDay < 0) {
                    startDay = 7 + startDay;
                }
                if (createCal.cache[year] && !isIE11) {
                    if (createCal.cache[year][month]) {
                        return createCal.cache[year][month];
                    }
                } else {
                    createCal.cache[year] = {};
                }
                i = 0;
                while (haveDays) {
                    calendar[i] = [];
                    for (j = 0; j < 7; j++) {
                        if (i === 0) {
                            if (j === startDay) {
                                calendar[i][j] = day++;
                                startDay++;
                            }
                        } else if (day <= daysInMonths[month]) {
                            calendar[i][j] = day++;
                        } else {
                            calendar[i][j] = '';
                            haveDays = false;
                        }
                        if (day > daysInMonths[month]) {
                            haveDays = false;
                        }
                    }
                    i++;
                }
                for (i = 0; i < calendar.length; i++) {
                    calendar[i] = '<tr><td class="eformDay" onclick="gladCal.dayClick(this)">' + calendar[i].join('</td><td class="eformDay" onclick="gladCal.dayClick(this)">') + '</td></tr>';
                }
                var timePicker = '<tr><td class="" colspan="7"><div id="timeRow"><div><%=LocHor.Text %></div><div><select id="selHour" style="width:70px;">'; //Hour
                timePicker += '<option value="00"><asp:Localize runat="server" meta:resourcekey="str_hr12am">12 am</asp:Localize></option>';
                timePicker += '<option value="01"><asp:Localize runat="server" meta:resourcekey="str_hr01am">1 am</asp:Localize></option>';
                timePicker += '<option value="02"><asp:Localize runat="server" meta:resourcekey="str_hr02am">2 am</asp:Localize></option>';
                timePicker += '<option value="03"><asp:Localize runat="server" meta:resourcekey="str_hr03am">3 am</asp:Localize></option>';
                timePicker += '<option value="04"><asp:Localize runat="server" meta:resourcekey="str_hr04am">4 am</asp:Localize></option>';
                timePicker += '<option value="05"><asp:Localize runat="server" meta:resourcekey="str_hr05am">5 am</asp:Localize></option>';
                timePicker += '<option value="06"><asp:Localize runat="server" meta:resourcekey="str_hr06am">6 am</asp:Localize></option>';
                timePicker += '<option value="07"><asp:Localize runat="server" meta:resourcekey="str_hr07am">7 am</asp:Localize></option>';
                timePicker += '<option value="08"><asp:Localize runat="server" meta:resourcekey="str_hr08am">8 am</asp:Localize></option>';
                timePicker += '<option value="09"><asp:Localize runat="server" meta:resourcekey="str_hr09am">9 am</asp:Localize></option>';
                timePicker += '<option value="10"><asp:Localize runat="server" meta:resourcekey="str_hr10am">10 am</asp:Localize></option>';
                timePicker += '<option value="11"><asp:Localize runat="server" meta:resourcekey="str_hr11am">11 am</asp:Localize></option>';
                timePicker += '<option value="12"><asp:Localize runat="server" meta:resourcekey="str_hr12pm">12 pm</asp:Localize></option>';
                timePicker += '<option value="13"><asp:Localize runat="server" meta:resourcekey="str_hr01pm">1 pm</asp:Localize></option>';
                timePicker += '<option value="14"><asp:Localize runat="server" meta:resourcekey="str_hr02pm">2 pm</asp:Localize></option>';
                timePicker += '<option value="15"><asp:Localize runat="server" meta:resourcekey="str_hr03pm">3 pm</asp:Localize></option>';
                timePicker += '<option value="16"><asp:Localize runat="server" meta:resourcekey="str_hr04pm">4 pm</asp:Localize></option>';
                timePicker += '<option value="17"><asp:Localize runat="server" meta:resourcekey="str_hr05pm">5 pm</asp:Localize></option>';
                timePicker += '<option value="18"><asp:Localize runat="server" meta:resourcekey="str_hr06pm">6 pm</asp:Localize></option>';
                timePicker += '<option value="19"><asp:Localize runat="server" meta:resourcekey="str_hr07pm">7 pm</asp:Localize></option>';
                timePicker += '<option value="20"><asp:Localize runat="server" meta:resourcekey="str_hr08pm">8 pm</asp:Localize></option>';
                timePicker += '<option value="21"><asp:Localize runat="server" meta:resourcekey="str_hr09pm">9 pm</asp:Localize></option>';
                timePicker += '<option value="22"><asp:Localize runat="server" meta:resourcekey="str_hr10pm">10 pm</asp:Localize></option>';
                timePicker += '<option value="23"><asp:Localize runat="server" meta:resourcekey="str_hr11pm">11 pm</asp:Localize></option>';
                timePicker += '</select></div><div><%=LocMin.Text %></div><div><select id="selMin" style="width:40px;">';//Minutes
                for (i = 0; i <= 5; i++) {
                    var mins = i * 10;        
                    timePicker += '<option value="' + twoDigitStr(mins) + '">' + twoDigitStr(mins) + '</option>';
                } 
                timePicker += '</select></div><div id="selBtn" class="btn btn-primary gladbtn gladbtn" onclick="gladCal.selDateAndTime()"><%=LocSel.Text %></div></div>';//SELECT
                var customFooter = timePicker + '<tr><td class="footer neverBtn" onclick="gladCal.neverClick()" colspan="7"><asp:Localize runat="server" meta:resourcekey="str_Nev">NEVER</asp:Localize></td></tr>';
				var calendarInnerHtml = calendar.join('');
                calendar = document.createElement('table');
                calendar.className = 'curr';
                calendar.innerHTML = calendarInnerHtml + customFooter;
                var tdEmty = calendar.querySelectorAll('td:empty');
                for (var i = 0; i < tdEmty.length; ++i) {
                    tdEmty[i].classList.add('nil');
                }
                if (month === new Date().getMonth()) {
                    var calTd = calendar.querySelectorAll('td');
                    var calTdArray = Array.prototype.slice.call(calTd);
                    calTdArray.forEach(function (current, index, array) {
                        if (current.innerHTML === new Date().getDate().toString()) {
                            current.classList.add('today');
                        }
                    });
                }
                createCal.cache[year][month] = { calendar: function () { return calendar }, label: months[month] + ' ' + year };
                return createCal.cache[year][month];
            }
            createCal.cache = {};
            //day click event function => than close
            var dayClick = function (element) {     
                var dateResult = DateToString(new Date(calYear, calMonth - 1, parseInt(element.innerHTML)), calDateFormat);
                $(".eformDay.topnavcolor").removeClass("topnavcolor");
                $(element).addClass("topnavcolor");    
                document.getElementById(eFormCalendarElement).value = dateResult;
            }
            var selDateAndTime = function () {     
                if ($(".eformDay.topnavcolor").length == 0) {
                    $('#ModalAlertBody').html("<%=LocPleSelDay.Text %>");//Please select a day.
                    $('#ModalAlert').modal({ backdrop: 'static', keyboard: false });
                    return;
                }                         
                var selHour = parseInt(document.getElementById("selHour").value);
                var selMin = parseInt(document.getElementById("selMin").value);
                var totalMinutes = (selHour*60) + selMin;           
                var selDate = new Date();
                var currDate = new Date();
                try {
                    var arr = document.getElementById("tmpCalDate").value.split("."); 
                    selDate = new Date(parseInt(arr[0]), parseInt(arr[1])-1, parseInt(arr[2]), selHour, selMin);
                } catch (ex) {
                    selDate = new Date();
                }
                var diff = selDate - currDate; 
                var totalDays = Math.floor(diff/(24*60*60*1000));   
                var totalHours = Math.floor(diff/(60*60*1000)) - (totalDays * 24);   
                var totalMinutes = Math.floor(diff / (60 * 1000));// - (totalDays * 24 * 60) - (totalHours * 60);  
                    
                console.log("selected date: "+selDate);                                                        
                console.log("total days to expiration: "+totalDays);  
                console.log("total hours to expiration: "+totalHours);  
                console.log("total minutes to expiration: "+totalMinutes);
                
                if (totalMinutes <= 0) {
                    $('#ModalAlertBody').html("<%=LocPleSelTimInFut.Text %>");//Please select a time in the future.
                    $('#ModalAlert').modal({ backdrop: 'static', keyboard: false });
                    return;
                }

                $("#<%=hidCustomTime.ClientID %>").val(totalDays);  
                $("#<%=hidCustomTime2.ClientID %>").val(totalMinutes); 
                close();
            } 
            var neverClick = function () {                  
                $("#<%=hidCustomTime.ClientID %>").val(7650);  
                $("#<%=hidCustomTime2.ClientID %>").val(0); 
                close();
            }
            // join
            function joinObj(obj, seperator) {
                var out = [];
                for (k in obj) {
                    out.push(k);
                }
                return out.join(seperator);
            }
            //returns string in desired format
            function DateToString(inDate, formatString) {
                var dateObject={M:inDate.getMonth()+1,d:inDate.getDate(),D:inDate.getDate(),h:inDate.getHours(),m:inDate.getMinutes(),s:inDate.getSeconds(),y:inDate.getFullYear(),Y:inDate.getFullYear()};
                // Build Regex Dynamically based on the list above.
                // Should end up with something like this "/([Yy]+|M+|[Dd]+|h+|m+|s+)/g"
                var dateMatchRegex = joinObj(dateObject, "+|") + "+";
                var regEx = new RegExp(dateMatchRegex, "g");
                formatString = formatString.replace(regEx, function (formatToken) {
                    var datePartValue = dateObject[formatToken.slice(-1)];
                    var tokenLength = formatToken.length;
                    if (formatToken === 'MMMM') {
                        return window.months[dateObject.M - 1];
                    }
                    // A conflict exists between specifying 'd' for no zero pad -> expand to '10' and specifying yy for just two year digits '01' instead of '2001'.  One expands, the other contracts.
                    // so Constrict Years but Expand All Else
                    if (formatToken.indexOf('y') < 0 && formatToken.indexOf('Y') < 0) {
                        // Expand single digit format token 'd' to multi digit value '10' when needed
                        var tokenLength = Math.max(formatToken.length, datePartValue.toString().length);
                    }
                    var zeroPad;
                    try {
                        zeroPad = (datePartValue.toString().length < formatToken.length ? "0".repeat(tokenLength) : "");
                    } catch (ex) {//IE11 repeat catched
                        zeroPad = (datePartValue.toString().length < formatToken.length ? repeatStringNumTimes("0", tokenLength) : "");
                    }
                    return (zeroPad + datePartValue).slice(-tokenLength);
                });
                return formatString;
            }
            Date.prototype.ToString = function (formatStr) { return DateToString(this.toDateString(), formatStr); }
            //IE11 repeat alternative
            function repeatStringNumTimes(string, times) {
                var repeatedString = "";
                while (times > 0) {
                    repeatedString += string;
                    times--;
                }
                return repeatedString;
            }
            //close event function (fadeout)
            function close() {
                updateDate();
                fadeOutEffect(DOMstrings.divCalQ, remove);
            }
            function closeWithoutUpdating() {
                fadeOutEffect(DOMstrings.divCalQ, remove);
            }
            //remove calendar box
            var remove = function () {
                try {
                    document.getElementById(DOMstrings.divCal).remove();
                } catch (ex) {//ie11 fix
                    var child = document.getElementById(DOMstrings.divCal);
                    child.parentNode.removeChild(child);
                }
            }
            //parse date
            function DateParse(date) {
                var parsedDate, newDate;
                var currentDate = date;
                if (currentDate != null) {
                    splitedDate = currentDate.split('-');
                    newDate = { year: splitedDate[0], month: splitedDate[1], day: splitedDate[2] };
                }
                return newDate;
            }
            //function accesibility
            return{open:open,switchMonth:switchMonth,createCal:createCal,dayClick:dayClick,close:close,closeWithoutUpdating:closeWithoutUpdating,neverClick:neverClick,selDateAndTime:selDateAndTime};
        })();
        //plain javascript fadeout alternative
        function fadeOutEffect(t,e){var a=document.querySelector(t);if(null!=a)var c=setInterval(function(){a.style.opacity||(a.style.opacity=1),0<a.style.opacity?a.style.opacity-=.1:(clearInterval(c),e())},20)}
        /*MIT License. Copyright (c) 2018 Josef Brož. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
        The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
        //>>>calendar code
    </script>
    <style type="text/css">
        #timeRow{display:flex;gap: 10px;align-items: center;margin-left: 10px;}   
        #selHour{padding: 0 5px 0 5px;}   
        #selMin{padding: 0 5px 0 5px;}
        .eformDay.topnavcolor{color:#FFF !important;}
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .x-form-text
        {
        }
        .wrapper
        {
            min-height:80%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto;
        }
        <% if (!IsMobile()) { %>
        /*.wrapper
        {
            margin-bottom:-68px;
        }*/
        <% } %>  
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        .errmsg {font-size:12px !important;}

        .calendarIco{padding:3px 0px 0px 10px;font-size:24px !important;}
        /*Calendar styles<<<*/
        #cal{margin:50px auto;font:14px;display:table;position:absolute}
        /*header bar---------------------*/
        #cal .header{cursor:default;height:34px;position:relative;color:#fff;-webkit-border-top-left-radius:5px;-webkit-border-top-right-radius:5px;-moz-border-radius-topleft:5px;-moz-border-radius-topright:5px;border-top-left-radius:5px;border-top-right-radius:5px;font-weight:200;text-transform:uppercase}
        #cal .header span{display:inline-block;line-height:34px}
        #cal .header .hook{width:9px;height:28px;position:absolute;bottom:60%;border-radius:10px;-moz-border-radius:10px;-webkit-border-radius:10px}
        .right.hook{right:15%}
        .left.hook{left:15%}
        /*month switch buttons*/
        #cal .header .button{width:24px;text-align:center;position:absolute}
        #cal .header .left.button{left:0;-webkit-border-top-left-radius:5px;-moz-border-radius-topleft:5px;border-top-left-radius:5px;}
        #cal .header .right.button{right:0;top:0;-webkit-border-top-right-radius:5px;-moz-border-radius-topright:5px;border-top-right-radius:5px}
        #cal .header .button:hover{cursor:pointer;}
        /*month label*/
        #cal .header .month-year{letter-spacing:1px;width:100%;text-align: center;}
        /*day headers---------------------*/
        .eformDayDisabled{background-color:#d3d3d3}
        #cal table{background:#fff;border-collapse:collapse}
        #cal td{color:#2b2b2b;width:50px;height:50px;line-height:30px;text-align:center;border:1px solid #e6e6e6;cursor:default;font-weight:200;}
        #cal #days td{height:26px;line-height:26px;text-transform:uppercase;font-size:12px;color:#9e9e9e;font-weight:200;}
        #cal td.footer{height:26px;line-height:26px;text-transform:uppercase;font-size:12px;color:#9e9e9e;font-weight:200;}
        #cal #days td:not(:last-child){border-right:1px solid #fff}
        #cal #cal-frame td.today{background:#ededed;color:#8c8c8c;box-shadow:1px 1px 0 #fff inset;-moz-box-shadow:1px 1px 0 #fff inset;-webkit-box-shadow:1px 1px 0 #fff inset}
        #cal #cal-frame td:not(.nil):hover{color:#fff;background:#a6a6a6;}
        #cal #cal-frame td span{font-size:12px;position:relative}
        #cal #cal-frame td span:first-child{bottom:5px}
        #cal #cal-frame td span:last-child{top:5px}
        #cal #cal-frame table.curr{float:left}
        #cal #cal-frame table.temp{position:absolute}
        /*>>>Calendar styles*/
        #footerpanel { border-left: 0; border-right: 0;border-top: none !important; border-bottom: 0; vertical-align: middle; width: 100%; clear:both; }
        #ModalAlert .modal-dialog{width:auto;}   
        <% if (IsMobile()) { %>

        .footer, .push { height: 8px; }    
                           
         #footerpanel{ position:relative; }   
                 
         .checkboxSep{ display:block; clear:both; height:1px; width:100%; }    
         
        #ModalAlert{margin-top:0px;width:100vw;}                
        <% } else { %>     

        .footer, .push { height: 68px; /* .push must be the same height as .footer */ }
                                     
         #footerpanel{ position:static; }   
          
         .checkboxSep{ display:inline; padding-left: 20px; }  
          
        #ModalAlert{margin-top:130px;width:100vw;}
        <% }  %>
        #Form1, .main, #aspnetForm{overflow:hidden;}
        
        #main_body_div{overflow-x:hidden !important;}
        #footerSeparator,#footerGetShareLink,#footerSeparatorHidden,#footerGetShareLinkHidden{display:none;}      
        .forcewrap { white-space: -moz-pre-wrap !important;white-space: -webkit-pre-wrap;white-space: pre-wrap;word-break: break-all;white-space: normal; }                            
	    @media (min-width: 411px) {   
            #expiresDisplay { font-size:14px;}     
            #cal { margin-left:100px;}
	    }         
	    @media (min-width: 361px) and (max-width: 410px) {   
            #expiresDisplay { font-size:12px;}     
            #cal { margin-left:50px;}
	    }         
	    @media (max-width: 360px) {   
            #expiresDisplay { font-size:10px; }   
            #cal { margin-left:0px;}
	    }
        label{white-space:normal;}
        .bulletLineParent{display:flex;align-items:flex-start;margin-right:13px;}
        table{width:100%;}
        .firstRowCol{
            <%if(!IsMobile() && System.Threading.Thread.CurrentThread.CurrentCulture.ToString()=="en-US"){%>
                margin-right:40px;
            <%}%>
        }        
        @media (max-width:849px) {
        #shareViewOptions{flex-direction:column;}
        #pwdOptions{flex-direction:column;}
        #bottomOptionsA{flex-direction:column;}
        #bottomOptionsB{flex-direction:column;}
        } 
        label[for=ctl00_MainContent_PwdProtect]{white-space:nowrap;}
    </style>
    <script type="text/javascript">
        function copyToClipboard(text) {
            try {
                if (window.clipboardData && window.clipboardData.setData) {
                    // IE specific code path to prevent textarea being shown while dialog is visible.
                    clipboardData.setData("Text", text);
                    alert("Link copied to clipboard");

                } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                    var textarea = document.createElement("textarea");
                    textarea.textContent = text;
                    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand("copy"); // Security exception may be thrown by some browsers.
                        alert("Link copied to clipboard");
                    } catch (ex) {
                        console.warn("Copy to clipboard failed.", ex);
                        return false;
                    } finally {
                        document.body.removeChild(textarea);
                    }
                }
            } catch (e) {

            }
        }

        function copyShareLink() {
            var e = document.getElementById("ShareLinkTd");
            copyToClipboard(e.innerHTML.trim());
            
        }

        function mobileActionName() {
            return "Share";
        }

        function mobileActionClicked() {
            var aspBtn = '<%=LinkButton3.ClientID %>';

            var aspBtnDom = document.getElementById(aspBtn);
            if (aspBtnDom) {
                aspBtnDom.click();
            }
        }

        function mobileActionAndroidClicked() {

            var aspBtn = '<%=LinkButton3.ClientID %>';

            var aspBtnDom = document.getElementById(aspBtn);
            if (aspBtnDom) {
                e = document.createEvent('HTMLEvents');
                e.initEvent('click', true, true);
                aspBtnDom.dispatchEvent(e);
            }
        }

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        //setTimeout("ClearErrorMsg()", 8000);

        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "AddPubPage.aspx";
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }


        function ShowExpCal() {
            var d = document.getElementById("ExpTimeDiv");

            var d1 = document.getElementById("toggle");
            d1.src = "images/collapse.gif";
            d.style.display = "block";

        }

        function HideExpCal() {
            var d = document.getElementById("ExpTimeDiv");
            d.style.display = "none";
            var d1 = document.getElementById("toggle");
            d1.src = "images/expand.png";

        }

        function ToggelExpCal() {
            var d = document.getElementById("ExpTimeDiv");
            if (d.style.display == "block")
                HideExpCal();
            else
                ShowExpCal();

        }
        
        function checkPwdProtectRadio(){   
            var pwd = document.getElementById('<%=SharePwd.ClientID%>');
            if(pwd){
                var thereIsACustomPassword = (pwd.value.length > 0);
                if(thereIsACustomPassword) {
                    var rdo = document.getElementById('<%=PwdProtect.ClientID%>');
                    if(rdo) rdo.checked=true;
                    toggleCheckboxAndLabel("<%=AutoGeneratePassword.ClientID%>", false);
                    toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", true);    
                    toggleCheckboxAndLabel("<%=SendSharePassword.ClientID%>", true); 
                    toggleCheckboxAndLabel("<%=IncludePasswordInNotes.ClientID%>", true);
                }else{
                    pwd.focus();          
                    toggleCheckboxAndLabel("<%=SendSharePassword.ClientID%>", false);          
                    toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", true);
                    toggleCheckboxAndLabel("<%=AutoGeneratePassword.ClientID%>", true);
                    toggleCheckboxAndLabel("<%=IncludePasswordInNotes.ClientID%>", true);
                }    
            }
        }
        function getLabelRef(inputClientID){
            var labels = document.getElementsByTagName('LABEL');
            for (var i = 0; i < labels.length; i++) {
                if (labels[i].htmlFor == inputClientID) {
                    return labels[i];         
                }
            }
            return null;
        }
        function toggleLbl(inputClientID,enable){
            var lblObj = getLabelRef(inputClientID);
            if(lblObj) {
                if(enable) lblObj.style.opacity = 1;
                else  lblObj.style.opacity = 0.5;
            }
        }
        function toggleFullControl(enable){
            //option for full control should only work if a password is provided, or a login is enforced
            <% if (FullControl.Visible) { %>
            toggleRadio("<%=FullControl.ClientID%>",enable);
            <% } %>
        }
        function togglePasswordOptions(){
            <% if (m_AlwaysPwdProtect == true) { %>
            toggleCheckboxAndLabel('<%=NoProtect.ClientID%>', false);
            <% if (LoginProtect.Visible) { %>
            toggleCheckboxAndLabel('<%=LoginProtect.ClientID%>', true);
            <% } %>
            <% if (m_DisableOneTimePasswordForShares) { %>      
                <% if (LoginProtect.Visible) { %>
                try{
                    document.getElementById("<%=LoginProtect.ClientID%>").checked = true;
                }catch{}
                <% } %>
            <% } %> 
            <% } %>      
            <% if (m_DisableOneTimePasswordForShares) { %>   
            $("#<%=OneTimePassword.ClientID%>").hide();
            $("#divOneTimePasswordRow").hide();
            <% } %> 
            var mustLogInChecked = false;
            var fullControlChecked = false;
            try{
                mustLogInChecked = (document.getElementById("<%=LoginProtect.ClientID%>").checked);
            }catch{}
            <% if (FullControl.Visible) { %>
            fullControlChecked = (document.getElementById("<%=FullControl.ClientID%>").checked);
            <% } %>
            //enables or disables the entire custom password for access row, including textbox and checkboxes
            //enables or disables the recipient must log in to access row
            var viewOnlyChecked = (document.getElementById("<%=ViewOnly.ClientID%>").checked || document.getElementById("<%=ViewOnlyPerm.ClientID%>").checked);
            if(document.getElementById("<%=DisablePreview.ClientID%>") && document.getElementById("<%=DisablePreview.ClientID%>").checked){
                viewOnlyChecked = true;
            }
            if(fullControlChecked){ 
                toggleCheckboxAndLabel('<%=NoProtect.ClientID%>', false);
                toggleCheckboxAndLabel('<%=PwdProtect.ClientID%>', false);
                toggleCustomPasswordText(false);
                mustLogInChecked = true;  
            }
            if(viewOnlyChecked){ 
                toggleCheckboxAndLabel('<%=PwdProtect.ClientID%>', true);
                var noProtectionIsUnchecked = false;
                try{
                    if(!document.getElementById("<%=NoProtect.ClientID%>").disabled){
                        noProtectionIsUnchecked = (!document.getElementById("<%=NoProtect.ClientID%>").checked);
                    }
                }catch{}
                var passwordForAccessIsUnchecked = false;
                var customPasswordIsChecked = document.getElementById("<%=PwdProtect.ClientID%>").checked;
                if(!document.getElementById("<%=PwdProtect.ClientID%>").disabled){
                    passwordForAccessIsUnchecked = !customPasswordIsChecked;
                }             

                if(noProtectionIsUnchecked && passwordForAccessIsUnchecked){
                    <% if (m_AlwaysPwdProtect) { %>
                    document.getElementById("<%=PwdProtect.ClientID%>").checked = true;
                    <% } %>
                    if(!mustLogInChecked){
                        uncheckPwdProtectRadio();   
                    };
                }

                if (customPasswordIsChecked) {  
                    toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", true);
                    toggleCheckboxAndLabel("<%=SendSharePassword.ClientID%>", true);
                    toggleCheckboxAndLabel("<%=IncludePasswordInNotes.ClientID%>", true);
                    var customPwdIsEmpty = ($("#<%=SharePwd.ClientID%>").val() == "");
                    toggleCheckboxAndLabel("<%=AutoGeneratePassword.ClientID%>", customPwdIsEmpty);  

                }
            }
            if(mustLogInChecked){
                //toggleCheckboxAndLabel('<%=PwdProtect.ClientID%>', false);
                toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", false);
                toggleCheckboxAndLabel("<%=SendSharePassword.ClientID%>", false);
                toggleCheckboxAndLabel("<%=IncludePasswordInNotes.ClientID%>", false);
                toggleCheckboxAndLabel("<%=AutoGeneratePassword.ClientID%>", false);
                <% if (LoginProtect.Visible) { %>
                document.getElementById("<%=LoginProtect.ClientID%>").checked = true;
                <% } %>
                toggleGuestWarning();
                setTimeout(function () {
                    uncheckPwdProtectRadio(); 
                }, 500);
            }else{
                hideGuestWarning();
            }
        }
        function hideGuestWarning(){
            //$("#<%=lblMsgs.ClientID%>").hide();
            $('#ModalAlert').hide();
            //$("#<%=LinkButton3.ClientID%>").css("opacity","1");
            //$("#<%=LinkButton3.ClientID%>").removeAttr("disabled");
        }
        function toggleGuestWarning(){
            var serverMessage = $("#<%=lblMsgs.ClientID%>").text();
            if(serverMessage!=""){
                //$("#<%=lblMsgs.ClientID%>").show();
                
                $('#ModalAlertBody').html(serverMessage);
                $('#ModalAlert').modal({ backdrop: 'static', keyboard: false });

                //$("#<%=LinkButton3.ClientID%>").css("opacity","0.25");
                //$("#<%=LinkButton3.ClientID%>").attr("disabled", true);
            }else{                    
                hideGuestWarning();
            }
            atLeastOneUserWillBeCreated();
        }
        function defaultToAutoGeneratedPwd() {  
           <% if (m_DisableOneTimePasswordForShares) { %>   
            setTimeout(function () {      
           document.getElementById('<%=AutoGeneratePassword.ClientID%>').checked=true;
           document.getElementById('<%=SendSharePassword.ClientID%>').checked=true; 
           document.getElementById('customPasswordCell').style.display="none";
            }, 100);
           <% } %> 
        }
        function toggleSystemPassword(enable){
            toggleRadio("<%=SendSharePassword.ClientID%>",enable);
            toggleRadio("<%=IncludePasswordInNotes.ClientID%>",enable);
            toggleCustomPasswordText(!enable);
            document.getElementById('<%=AutoGeneratePassword.ClientID%>').disabled=!enable;
            toggleLbl('<%=AutoGeneratePassword.ClientID%>',enable); 
        }
        function toggleCustomPasswordText(enable){
            if(enable){                      
                $("#customPasswordCell").show();    
                try {
                    $("#<%=SharePwd.ClientID%>")[0].focus();
                } catch (ex) {}
                toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", true);
            }else{                             
                $("#customPasswordCell").hide();  
                $("#<%=SharePwd.ClientID%>").val("");
                toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", false);
            }
        }
        function toggleCheckboxAndLabel(id, enabled){
            if(!enabled){
                //if disabling, also uncheck it
                togglecheck(id, false);
            }
            try{
                document.getElementById(id).disabled = !enabled;
            }catch(ex){}
            toggleLbl(id, enabled);
        }
        function togglecheck(id, checked){
            try{
                document.getElementById(id).checked = checked;
            }catch(ex){}
        }
        function toggleSystemPasswordMode(ref,isSystemBox){
            if(isSystemBox){
                toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", true);
                toggleCheckboxAndLabel("<%=SendSharePassword.ClientID%>", true);
                if(ref.checked){
                    $("#<%=SharePwd.ClientID%>").val("");
                    $("#customPasswordCell").hide();
                    togglecheck("<%=SendSharePassword.ClientID%>", true);
                }else{
                    $("#customPasswordCell").show();
                    if($("#<%=SharePwd.ClientID%>").val().length<=0){                        
                        toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", false);
                    }
                }
            }else{
                if(!ref.checked){
                    togglecheck("<%=AutoGeneratePassword.ClientID%>", false);
                    $("#customPasswordCell").show();
                }
            }
        }
        function toggleNoProtection(enable){            
            <% if (m_AlwaysPwdProtect == false) { %>
            //option for no protection should only work if the share is not full control
            toggleRadio("<%=NoProtect.ClientID%>",enable);
            toggleCheckboxAndLabel("<%=OneTimePassword.ClientID%>", false);
            toggleCheckboxAndLabel("<%=SendSharePassword.ClientID%>", false);
            toggleCheckboxAndLabel("<%=IncludePasswordInNotes.ClientID%>", false);
            toggleCheckboxAndLabel("<%=AutoGeneratePassword.ClientID%>", false);
            <% } %>
        }
        function toggleRadio(clientID,enable,checked){
            var chk1 = document.getElementById(clientID);
            if(chk1) {
                if(enable){
                    chk1.disabled=false;
                    toggleLbl(clientID,true);
                    if(checked) chk1.checked=true;
                }else{
                    chk1.checked=false;
                    chk1.disabled=true;
                    toggleLbl(clientID,false);
                }
            }
        } 
        function atLeastOneUserWillBeCreated(){
            _atLeastOneUserWillBeCreated = true;
        }    
        function isChecked(id) {
            var obj = $("#" + id);
            if (obj.length == 0) {
                return false;
            }
            try {
                return $("#" + id)[0].checked;
            } catch (ex) {
                return false;
            }
        }
        function toggleGetShareLink() {     
            <% if (!m_ShowGetLinkForNoProtectSharesOnly) { %>
            $("#footerSeparator,#footerGetShareLink,#footerSeparatorHidden,#footerGetShareLinkHidden").show();
            return;
            <% } %>
            var showGetLinkRow = true;

            <% if (PwdProtect.Visible) { %>
            if (isChecked("<%=PwdProtect.ClientID%>")) {
                //if custom password is checked, hide the Get Share Link row
                showGetLinkRow = false;
            }
            <% } %>
            <% if (LoginProtect.Visible) { %>
            try {
                if (isChecked("<%=LoginProtect.ClientID%>")) {
                    //if must log in is checked, hide the Get Share Link row
                    showGetLinkRow = false;
                }
            }
            catch (ex) { }
            <% } %>
     
            if(showGetLinkRow){
                $("#footerSeparator,#footerGetShareLink,#footerSeparatorHidden,#footerGetShareLinkHidden").show();
            }else{ 
                $("#footerSeparator,#footerGetShareLink,#footerSeparatorHidden,#footerGetShareLinkHidden").hide();
            }
        }
        function uncheckPwdProtectRadio(){
            var customPwd = document.getElementById('<%=SharePwd.ClientID%>');
            if(customPwd) customPwd.value = "";
            toggleRadio("<%=SendSharePassword.ClientID%>",false);
            toggleRadio("<%=IncludePasswordInNotes.ClientID%>",false);
            toggleRadio("<%=OneTimePassword.ClientID%>",false);
            toggleRadio("<%=AutoGeneratePassword.ClientID%>",false);
        }  
        function checkRequiredSettings() {
            var pwdProtect = ($("#<%=PwdProtect.ClientID%>").length == 1 && isChecked("<%=PwdProtect.ClientID%>"));
            var autoGenPwdUnchecked = ($("#<%=AutoGeneratePassword.ClientID%>").length == 1 && !isChecked("<%=AutoGeneratePassword.ClientID%>"));
            var sharePwdIsEmpty = ($("#<%=SharePwd.ClientID%>").length == 1 && $("#<%=SharePwd.ClientID%>").val() == "");
            if (pwdProtect && autoGenPwdUnchecked && sharePwdIsEmpty)
            {
                $('#ModalAlertBody').html("<asp:Localize runat="server" meta:resourcekey="str_etrPwd">Please enter a password for access.</asp:Localize><br /><br /><br />");
                $('#ModalAlert').modal({ backdrop: 'static', keyboard: false });
                return;
            }
            try {
                $("#<%=LinkButton3.ClientID%>")[0].click();
            } catch (ex) {
                console.log("Error. Couldn't find <%=LinkButton3.ClientID%>");
            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocExcGueUseQuo" meta:resourcekey="str_excGueUseQuo" Visible="false">Exceed guest user quota</asp:Localize>
<asp:Localize runat="server" ID="LocCreOfGueIsNotAll" meta:resourcekey="str_creOfGueIsNotAll" Visible="false">Creation of guest users is not allowed</asp:Localize>  
<asp:Localize runat="server" ID="LocYouCanShaYou" meta:resourcekey="str_youCanShaYou" Visible="false">Error. You can't share to yourself.</asp:Localize>   
<asp:Localize runat="server" ID="LocPleSelTimInFut" meta:resourcekey="str_pleSelTimInFut" Visible="false">Please select a time in the future.</asp:Localize> 
<asp:Localize runat="server" ID="LocPleSelDay" meta:resourcekey="str_pleSelDay" Visible="false">Please select a day.</asp:Localize>     
<asp:Localize runat="server" ID="LocHor" meta:resourcekey="str_hor" Visible="false">Hour</asp:Localize>   
<asp:Localize runat="server" ID="LocMin" meta:resourcekey="str_min" Visible="false">Minutes</asp:Localize>
<asp:Localize runat="server" ID="LocSel" meta:resourcekey="str_sel" Visible="false">SELECT</asp:Localize>
<asp:Localize runat="server" ID="LocShrPwd" meta:resourcekey="str_shrPwd" Visible="false">Share Password:</asp:Localize>   
<asp:Localize runat="server" ID="LocShrLnk" meta:resourcekey="str_shrLnk" Visible="false">Share Link</asp:Localize>
            <% if (!m_IsMobile){ %>
        <div class="wrapper">
     <% }else{ %>
        <div class="wrapper1">
      <% } %>
        <%if (string.IsNullOrEmpty(m_ShareLink))            { %>
        <table width="100%" align="center" style="height: 100%; padding:0;margin:0;" valign="top" cellpadding="0" cellspacing="0">
            
            <% if (!m_IsMobile)
                { %>
            <tr style="display:none;">
                <td style=" vertical-align:top;font-size: 14px; border-bottom: 1px solid #f0f0f0; padding-left: 6px;">
                    <table width="100%"  style="border-top:0;border-left:0;border-right:0;height:48px">
                        <tr>
                            <td width="32px" style="display: none;">
                                <img src="images/changepassword.png" />
                            </td>
                            <%if (!IsMobile())
                                { %>
                            <td >
                                <h2 style="color:#565656;"><asp:Localize meta:resourcekey="asp_string1" runat="server" 
                                    Text="Protect the Share"></asp:Localize></h2>
                            </td>
                            <%} %>
                            <td style="padding-right: 10px; display:none;" align="right">
                                <asp:Button ID="Button1" runat="server" 
                                        OnClientClick="Wait('Applying Settings')" CssClass="btn" 
                                        OnClick="LinkButtonBack_Click" meta:resourcekey="LinkButtonBackResource1" 
                                        Text="Back"></asp:Button>
                            
                            
                            
                                    <asp:Button ID="Button2" runat="server" 
                                        OnClick="LinkButton1_Click" CausesValidation="False" OnClientClick="Wait('Applying Settings');return true;"
                                        CssClass="btn btn-primary gladbtn gladbtn" meta:resourcekey="LinkButton3Resource1" 
                                        Text="Share"></asp:Button>
                            
                            
                            
                                    <asp:Button ID="Button3" runat="server" 
                                        OnClientClick="return OnClientShellCancel();" CssClass="btn" 
                                        OnClick="LinkButtonCancel_Click" 
                                        meta:resourcekey="LinkButtonCancelResource1" Text="Cancel"></asp:Button>
                            
                            
                            
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <% } %>
                        <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                            { %>
                        <tr>
                <td>
                    <div id="errmsgdiv" style="display:none;">

                        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" 
                            meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                            </div>
                </td>
            </tr>

                        <%} %>
            <tr>
                <td class="InputLabel" style="border: 1px dotted #c0c0c0; padding: 10px; background-color: white; color: #565656; border-top:0;border-left:0;border-right:0; 
                    height: 32px;padding-left:20px;">
                    <h2 style="font-weight:100; display:none;">
                    <asp:Localize meta:resourcekey="asp_string2" runat="server" 
                        Text="Specify share expiration time:"></asp:Localize>
                        </h2>
                    <table width="100%">
                        <tr>
                            <td width="120px" nowrap>
                                <% if (m_ShareExpireDays <= 0) { %>
                                <h2 style="font-weight:100;display:inline;">
                                    <asp:Localize meta:resourcekey="asp_string3" runat="server" Text="Expires in:"></asp:Localize>
                                    <span id="expiresDisplay" class="hand" style="font-weight:100;display:inline;padding-left:5px;white-space:normal;" onclick="toggleCal()">
                                        <asp:Literal ID="ltlExpiresTime" runat="server" />                                                        
                                        <asp:Localize meta:resourcekey="str_days" ID="LocDays" runat="server" Visible="false">Days</asp:Localize>
                                        <asp:Localize meta:resourcekey="str_dayHouMin" ID="LocDayHouMin" runat="server" Visible="false">{$DYS} Day(s), {$HRS} Hour(s), {$MNS} Minute(s)</asp:Localize>
                                    </span>
                                </h2>
                                <span class="gladinet-icons gladbtn calendarIco hand" onclick="toggleCal()">&#x13E;</span>

                                <input type="hidden" id="tmpCalDate" />
                                <input type="hidden" id="hidCustomTime" runat="server" />   
                                <input type="hidden" id="hidCustomTime2" runat="server" />                                
                                <div style="display:none;"><asp:DropDownList ID="ExpirationTime" runat="server" CssClass="browser-default custom-select secsubbordercolor" Width="100%" meta:resourcekey="ExpirationTimeResource1"></asp:DropDownList></div>
                                
                                <script type="text/javascript">
                                    var calBtn = document.querySelector(".calendarIco");
                                    document.getElementById("tmpCalDate").value = "";
                                    var calBtnLeft = calBtn.getBoundingClientRect().left + calBtn.style.width;
                                    if(isMobileBrowser()) calBtnLeft = 0;
                                    var calIsOpen = false;
                                    function toggleCal(){
                                        if(calIsOpen){
                                            calIsOpen = false;
                                            gladCal.closeWithoutUpdating();
                                        }else{
                                            calIsOpen = true;
                                            var topPadding = 10;
                                            var minDate = new Date(Date.now());
                                            //maximum date is one year into the future
                                            var maxDate;
                                            <%if (m_MaxShareDays > 0)
                                         { %>
                                            //maximum from group policy
                                                var maxDate = new Date();
                                                maxDate.setDate(maxDate.getDate() + <%=m_MaxShareDays%>);
                                            <% }
                                         else
                                         { %>
                                                //default to one year into the future
                                                maxDate = new Date(new Date().setFullYear(new Date().getFullYear() + 1));
                                            <% } %>
                                            
                                            gladCal.open('yyyy.MM.dd', calBtnLeft, topPadding, 1, fmtInpDate(minDate), fmtInpDate(maxDate), "tmpCalDate", 1000);
                                        }
                                    }
                                    function getLocalizedText(numDays, numMins) {
                                        if (numDays >= 1825) {
                                            return "<asp:Localize runat="server" meta:resourcekey="str_Nev">NEVER</asp:Localize>";
                                        }
                                        var template = "<%=LocDayHouMin.Text%>";//{$DYS} Day(s), {$HRS} Hour(s), {$MNS} Minute(s)
                                        try { 
                                            numDays = parseInt(numDays);
                                        } catch (ex) {
                                            numDays = 0;
                                        }  
                                        try { 
                                            numMins = parseInt(numMins);
                                        } catch (ex) {
                                            numMins = 0;
                                        }
                                        var hours = parseInt((numMins / 60) - (numDays * 24));
                                        var mins = parseInt(numMins - (hours * 60) - (numDays * 24 * 60));
                                        return template.replace("{$DYS}",numDays).replace("{$HRS}",hours).replace("{$MNS}",mins);
                                    }
                                    function twoDigitStr(num) {
                                        if (num < 10) {
                                            return "0" + num;
                                        }
                                        return num;
                                    }
                                    function updateDate(){
                                        var dspObj = document.getElementById("expiresDisplay");  
                                        var daysOnly = document.getElementById("<%=hidCustomTime.ClientID%>").value; 
                                        var mins = document.getElementById("<%=hidCustomTime2.ClientID%>").value;
                                        dspObj.innerHTML = getLocalizedText(daysOnly, mins);
                                    }
                                </script>                                
                                <% } else {%>
                                <h2 style="font-weight:100;display:inline;">
                                    <asp:Localize meta:resourcekey="asp_string3" runat="server" Text="Expires in:"></asp:Localize>
                                    <span style="font-weight:100;display:inline;padding-left:5px;">
                                        <asp:Literal ID="ltlExpiresTimeDisplayOnly" runat="server" />                                        
                                    </span>
                                </h2>
                                <% } %>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="10">
                </td>
            </tr>
            <tr>
                <td style="border: 1px dotted #c0c0c0;padding:10px 10px 10px 20px; background-color: white; border-top:0;border-left:0;border-right:0;
                    height: 32px;">
                    <div id="shareViewOptions" style="display:flex;margin-left:0px;margin-right:0px;margin-top:10px;margin-bottom:10px;">
                        <%if (ViewOnly.Visible)
                            { %>
                        <div class="bulletLineParent firstRowCol">
                            <asp:RadioButton ID="ViewOnly" runat="server" Checked="True" Text="View / Read-Only Access" GroupName="ViewEditor" meta:resourcekey="ViewOnlyResource1" onclick="toggleNoProtection(true);togglePasswordOptions();" /><!--AutoPostBack="True" OnCheckedChanged="ViewOnly_CheckedChanged"-->
                        </div>
                        <%} %>
                        <%if (ViewOnlyPerm.Visible)
                            { %>
                        <div class="bulletLineParent firstRowCol">
                            <asp:RadioButton ID="ViewOnlyPerm" runat="server" Text="View only (download will be disabled)" GroupName="ViewEditor" meta:resourcekey="ViewOnlyPermResource1" onclick="toggleNoProtection(true);togglePasswordOptions();" /><!-- AutoPostBack="True" OnCheckedChanged="ViewOnly_CheckedChanged"-->
                        </div>
                        <%} %>
                        <%if (DisablePreview.Visible)
                            { %>
                        <div class="bulletLineParent firstRowCol">
                            <asp:RadioButton ID="DisablePreview" runat="server" GroupName="ViewEditor" Text="Download Only" meta:resourcekey="DisablePreviewResource1" onclick="toggleNoProtection(true);togglePasswordOptions();" /><!-- AutoPostBack="True" OnCheckedChanged="ViewOnly_CheckedChanged"-->     
                        </div>
                        <%} %>
                        <%if (FullControl.Visible)
                            { %>
                        <div class="bulletLineParent">
                            <asp:RadioButton ID="FullControl" runat="server" Text="Edit / Full-Control Access" GroupName="ViewEditor" meta:resourcekey="FullControlResource1" onclick="toggleNoProtection(false);togglePasswordOptions();" /><!--AutoPostBack="True" OnCheckedChanged="FullControl_CheckedChanged"-->                           
                        </div>
                        <%} %>
                    </div>
                </td>
            </tr>
            <asp:Panel ID="ProtectPanel" runat="server" 
                meta:resourcekey="ProtectPanelResource1">
            
            <tr>
                <td class="InputLabel" colspan="2" style="padding-top: 5px;padding-left:5px;">
                        <asp:Panel ID="ViewerPanel" runat="server" 
                            meta:resourcekey="ViewerPanelResource1">
                    <div style="border: 1px dotted #c0c0c0; padding: 5px; background-color: white; padding: 15px; border-left:0;border-top:0;border-right:0; ">
                            <table >
                                <tr>

                                    <td style="padding-right: 15px;" nowrap="nowrap"" >
                                                                    <asp:RadioButton ID="NoProtect" runat="server" Checked="True" Text="No Protection"
                                GroupName="ProtectMode" meta:resourcekey="NoProtectResource1" onclick="uncheckPwdProtectRadio();toggleFullControl(false);toggleSystemPassword(false);toggleCustomPasswordText(false);hideGuestWarning();toggleGetShareLink();" />
                                    </td>
                                    </tr><tr>
                                    <td style="padding-right: 15px;" nowrap="nowrap">
                                        <table >
                                            <tr>
                                                                                    

                                                <td >
                            <asp:RadioButton ID="PwdProtect" runat="server" Checked="True" Text="Password is needed to access"
                                GroupName="ProtectMode" meta:resourcekey="PwdProtectResource1" onclick="toggleFullControl(true);toggleSystemPassword(true);toggleCustomPasswordText(true);hideGuestWarning();defaultToAutoGeneratedPwd();toggleGetShareLink();" />                        
                                                </td>
                                                <td id="customPasswordCell" style="width:75%;padding-left:5px;padding-bottom:10px;display:none;">
                                                    <asp:TextBox ID="SharePwd" runat="server"  CssClass="form-control"
                                meta:resourcekey="SharePwdResource1" onkeyup="checkPwdProtectRadio()"></asp:TextBox>
                                                </td>
                                                </tr><tr>
                                                
                                                    <% if (PwdProtect.Visible)
                          { %>
                           <td colspan="2" style="padding-top:10px;padding-left:15px;">
                            <div id="pwdOptions" class="bulletLineParent">
                               <div class="bulletLineParent">
                    <asp:CheckBox ID="SendSharePassword" runat="server" 
                        Text="Send share password in a separate email" meta:resourcekey="SendPwdResource" onclick="toggleSystemPasswordMode(this,false)"
                        /> 
                               </div>
                               <div id="divOneTimePasswordRow" class="bulletLineParent">
                               <asp:CheckBox ID="OneTimePassword" runat="server" 
                            Text="One time password" meta:resourcekey="OneTimePwdResource" 
                            />   
                               </div>   
                               <div class="bulletLineParent">
                               <asp:CheckBox ID="AutoGeneratePassword" runat="server" onclick="toggleSystemPasswordMode(this,true)"
                        Text="System generated password" meta:resourcekey="autoGeneratePasswordResource" 
                        /> 
                               </div>
                               <div class="bulletLineParent">
                               <asp:CheckBox ID="IncludePasswordInNotes" runat="server" 
                        Text="Include password in share notes" meta:resourcekey="iclPwdInNts" /> 
                                   
                               </div>
                            </div>
                                                </td> 
                    <% } %>                         
                               
                                            </tr>
                                        </table>
                                    </td>
                                        </tr><tr>
                                    <td style="padding-top: 10px;padding-right: 5px; width:200px;">
                                        <asp:RadioButton ID="LoginProtect" runat="server" Checked="True" Text="Recipient must log in to access"
                                            GroupName="ProtectMode" meta:resourcekey="LoginProtectResource1" onclick="uncheckPwdProtectRadio();toggleFullControl(true);toggleSystemPassword(false);toggleCustomPasswordText(false);toggleGuestWarning();toggleGetShareLink();" />
                                    
                                    
                                    <div style="padding-top:10px;">
                                    <i><asp:Localize meta:resourcekey="str_notApbRegAct" ID="LocNotApbRegAct" runat="server">* Not applicable to existing accounts</asp:Localize></i>
                                    </div>
                                    </td>
                                </tr>
                            </table>
                       
                            
                            <asp:Localize meta:resourcekey="asp_string4" Visible="False"
                                runat="server" Text="Password"></asp:Localize>
                    </div>
                        </asp:Panel>
                        
                </td>
            </tr>
            </asp:Panel>
            <asp:Panel ID="ShareNamePanel" runat="server" meta:resourcekey="ProtectPanelResource1">
                 <tr>
                <td class="InputLabel" colspan="2" style="">
                    <div style="border: 1px dotted #c0c0c0; background-color: white;  border-left:0;border-top:0;border-right:0; ">
                         <table width="100%">
                             <tr>
                                 <td style="padding-left:10px;width:150px;"><asp:Localize meta:resourcekey="str_sname" runat="server" Text="Share Name:"></asp:Localize></td>
                                 <td style="padding-right:20px;">
                                     <asp:TextBox ID="UserShareName" CssClass="form-control" runat="server" meta:resourcekey="UserShareNameResource1"></asp:TextBox>
                                     </td>
                             </tr>
                         </table>
                    </div>
                </td>
                </tr>
            </asp:Panel>
            <% if (!m_HideHint)
                { %>
            
            <tr>
                <td style="padding:20px; padding-top: 25px;">
                    <div id="bottomOptionsA" style="display:flex;">
                        
                        <div class="bulletLineParent" style="margin-right:70px;">
                    <asp:CheckBox ID="EmailDownloadNotification" runat="server" 
                        Text="Send email notification when file is downloaded" meta:resourcekey="EmailDownloadNotificationResource1"
                         /></div>

                        <div class="bulletLineParent">
                    <asp:CheckBox ID="EmailUploadNotification" runat="server" 
                        Text="Send email notification when file is uploaded" meta:resourcekey="EmailUploadNotificationResource1"
                        />  
                     </div>
                        
                        </div>  
                    <div id="bottomOptionsB" style="display:flex;margin-top:10px;">
                    <div class="bulletLineParent" style="margin-right:30px;">
                    <asp:CheckBox ID="NotifyUpload" runat="server" 
                        Text="Notify user when file/folder is changed" meta:resourcekey="NotifyUploadResource1" 
                        />  
                    </div>
                        <div class="bulletLineParent" style="margin-right:30px;">
                    <asp:CheckBox ID="NoEmail" runat="server" 
                        Text="Do not send email, I will notify user" meta:resourcekey="NoEmailResource" 
                        />      
                    </div>
                        <div class="bulletLineParent">
                    <asp:CheckBox ID="OneLevel" runat="server" 
                        Text="Only share files under the current folder" meta:resourcekey="OneLevelSource" 
                        />      
                    </div>   
                        </div>       
                </td>
            </tr>
            <% } %>
        </table>
            <% } else{ %>
            <div style="padding:20px">
            <table width="100%">
                <tr>
                    <td colspan="2" height="60px">&nbsp;</td>
                </tr>
                <tr>
                    <td height="60px" style="padding-left:20px; font-size:18px; font-weight:100; color:#565656; border-bottom:1px solid #cccccc; " id="ShareLinkTd" class="forcewrap"><%=m_ShareLink %></td>
                    <td width="32"  style="padding-right:20px;">
                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" title="<%=str_copystr.Text %>" onclick='copyShareLink()'>&#0192;</i>
                                                    <asp:Localize meta:resourcekey="str_copystr" ID='str_copystr' runat="server" Visible="False">Copy to clipboard</asp:Localize>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                       <div id="qrcode" class="updatable" style="margin-top:20px;margin-left:calc(50% - 100px);">
                            <img src="addshareprotect.aspx?qr=1&str=<%=m_ShareLink %>" style="width:180px;height:180px;" title="<%=LocShrLnk.Text %> QR Code"  alt="<%=LocShrLnk.Text %> QR Code" />
                        </div> 
                    </td>
                </tr>
            </table>
                </div>
            <%} %>
    </div>
    <asp:Localize meta:resourcekey="str_blkEmlDmn" runat="server" id="LocBlkEmlDmn" Visible="false">The following email domains have been blocked for guest users:</asp:Localize>
    <asp:Localize meta:resourcekey="str_usrDntExt" ID="LocUsrDntExt" runat="server" Visible="False">The following users will have guest accounts created for them:</asp:Localize>

       <div class="footer x-panel-header-light" id="footerpanel">
<div style="display:none;">
    <asp:Label ID="lblMsgs" runat="server" CssClass="errmsg" style="margin-left:10px;margin-top:0px;display:block;max-height:90px;overflow-y:auto;" />
</div>
    <%if (string.IsNullOrEmpty(m_ShareLink))            { %>
        <table style="height: 64px;width:100%;">
    
                        <tr>
                         
                            <td style="text-align:right;padding-right: 10px;">
                            
                                    <asp:Button ID="LinkButtonBack" runat="server" 
                                        OnClientClick="Wait('Applying Settings')" CssClass="btn" 
                                        OnClick="LinkButtonBack_Click" meta:resourcekey="LinkButtonBackResource1" 
                                        Text="Back"></asp:Button>
                            
                            &nbsp;&nbsp;
                             <asp:Localize meta:resourcekey="str_sav" ID='LocSav' runat="server" Visible="False">Save</asp:Localize>
                             <asp:Localize meta:resourcekey="LinkButton3Resource1" ID='LocShar' runat="server" Visible="False">Share</asp:Localize>
                    
                               <input type="button" class="btn btn-primary gladbtn gladbtn" value="<%=LinkButton3.Text %>" onclick="checkRequiredSettings();" />
                                <div style="display:none;">
                                    <asp:Button ID="LinkButton3" runat="server" 
                                        OnClick="LinkButton1_Click" CausesValidation="False" OnClientClick="Wait('Applying Settings');return true;"
                                        CssClass="btn btn-primary gladbtn gladbtn" meta:resourcekey="LinkButton3Resource1" 
                                        Text="Share"></asp:Button></div>
                            &nbsp;&nbsp;
                            
                            <% if (!m_HideHint)
                               { %>
                            
                                    <asp:Button ID="LinkButtonCancel" runat="server" 
                                        OnClientClick="return OnClientShellCancel();" CssClass="btn" 
                                        OnClick="LinkButtonCancel_Click" 
                                        meta:resourcekey="LinkButtonCancelResource1" Text="Cancel"></asp:Button>
                            
                            </td>
                            <% } %>
                        </tr>

                    <% if (GetLinkBtn.Visible) { %>
                    <% if (IsMobile()) { %>
                        <tr id="footerSeparatorHidden">
                            <td style="border-bottom: 1px dotted #c0c0c0;"></td>
                        </t>
                        <tr id="footerGetShareLinkHidden">
                            <td style="text-align:right;padding:10px 20px 10px 10px;">
                    <% } else {  %>
                        <tr id="footerSeparator">
                            <td style="background-color:#888888;height:5px;"></td>
                        </tr>
                        <tr id="footerGetShareLink">
                            <td style="text-align:right;padding:10px;">
                    <%} %>
                                <asp:Button ID="GetLinkBtn" runat="server" 
                                    OnClick="GetLinkBtn_Click" CausesValidation="False" OnClientClick="Wait('Applying Settings');return true;"
                                    CssClass="btn btn-primary gladbtn gladbtn" meta:resourcekey="GetLinkBtnResource1" 
                                    Text="Get Link"></asp:Button>
                            </td>
                        </tr>
                    <%} %>

                    </table>
                    <%} %>
                    </div>

    <div id="ModalAlert" class="modal fade" role="dialog">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-body" style="min-height:180px;padding-top:40px;">
                    <div id="ModalAlertBody" style="color: #404040 !important;font-weight: 200;"></div>
                    <br />
                    <div style="text-align:right;">
                    <button type="button" class="btn gladbtn" data-dismiss="modal"><asp:Localize meta:resourcekey="str_ok" runat="server">OK</asp:Localize></button>
                </div>
                </div>
            </div>
        </div>
    </div>
    <div id="ModalError" class="modal fade" role="dialog" style="margin-top: 130px;">
        <div class="modal-dialog " style="width:500px; max-width:500px;height:120px;">
            <div class="modal-content">
                <div class="modal-body" style="min-height:120px;padding-top:40px;">
                    <div id="ModalErrorBody" style="color: #404040 !important;font-weight: 200;"></div>
                    <br />
                    <div style="text-align:right;">
                    <button type="button" class="btn gladbtn" data-dismiss="modal"><asp:Localize meta:resourcekey="str_ok" runat="server">OK</asp:Localize></button>
                </div>
                </div>
            </div>
        </div>
    </div> 

    <script type="text/javascript">
        var PanelTitleId = document.getElementById("footerpanel");
        /*
        try {
            if (isPhoneBrowser()) {
                // 1. change the text to "Cluster Id"
                <% if (!MobileFileBrowser){ %>
                PanelTitleId.style.display = "none";
                <% } %>
            } else {
                PanelTitleId.style.display = "block";
            }
        } catch (e) {}
        */
        //the above code prevents the entire footer, including the continue and cancel buttons from showing up on iphone
        PanelTitleId.style.display = "block";

        
        var oldOnload = window.onload;
        window.onload = function () {
            try{
                if (oldOnload) oldOnload();
            }catch(ex){}

            try{
                $("#ShortWindowModal .modal-body",parent.document).css("min-height","550px");
            }catch(ex){}
            
            try{
                $("#<%=SharePwd.ClientID%>").val("");
                setTimeout(function () {
                    try{
                        $("#<%=SharePwd.ClientID%>")[0].focus();
                    }catch(ex1){}
                }, 500);
            }catch(ex){}
            try{
                $("#<%=PwdProtect.ClientID%>")[0].click();
            }catch(ex){}
            try{
                $("#<%=SendSharePassword.ClientID%>")[0].click();
            }catch(ex){}
            
            toggleGetShareLink();
            try{
                <% if (m_DisableOneTimePasswordForShares) { %>   
                $("#<%=OneTimePassword.ClientID%>").hide();
                $("#divOneTimePasswordRow").hide();
                <% } %> 
            } catch (ex) { }
            try{
                <% if (m_alwaysPwdProtect) { %>   
                $("#<%=NoProtect.ClientID%>").prop("disabled",true);
                <% } %> 
            } catch (ex) { }


            var errMessage = "<%=ErrorMsg.Text%>";
            if(errMessage!=""){
                $('#ModalErrorBody').html(errMessage);
                $('#ModalError').modal({ backdrop: 'static', keyboard: false });
            }

        }
    </script>
    <%if (m_ShowCal)
      { %>
    <script type="text/javascript">
        ShowExpCal();
    </script>
    <%} %>
</asp:Content>
