﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ActiveUsers.aspx.cs" Inherits="GladinetPayFlow.ActiveUsers"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="js_string1" runat="server">Do you really want to delete (</asp:Localize>" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="js_string2" runat="server">Deleting</asp:Localize>");
                window.location = h;
            }

        }



        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="js_string3" runat="server">Do you really want to detach the folder (</asp:Localize>" + unescape(id) + ")?")) {

                Wait("<asp:Localize meta:resourcekey="js_string4" runat="server">Detaching...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }


        function OnAttachFolder() {
            window.location = "/management/AddAttachedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
        }
   
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div class="meubardrop navbar navbar-default" role="navigation">
        <div class="container-fluid">
            <p class="navbar-text">
                <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1" CssClass="badge"></asp:Label>
                <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota" meta:resourcekey="GuestQuotaResource1"></asp:Label>
            </p>
            <div id="errmsgdiv" class="navbar-text">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
            <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 8px;">
                <asp:Localize id="LocRfs" meta:resourcekey="resLocRfs" runat="server" Visible="false">Refresh</asp:Localize>
                <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" onclick="__doPostBack('LinkButton2', '');" title="<%=LocRfs.Text %>">µ</i>
                <div style="display:table-cell;vertical-align:top;padding-left:5px; display:none;"><asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" OnClick="LinkButton2_Click" meta:resourcekey="LinkButton2Resource1"></asp:LinkButton></div>
            </div>
        </div>
    </div>


    <table id="grid-table" width="100%" style="padding: 0px; background-color: white; margin-top: 20px" cellpadding="0" cellspacing="0">
        <tr>
            <td style="vertical-align: top; padding:0px;border:0px;" id="grid-example">
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
    </div>
    <script type="text/javascript">

  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#DataBinder.Eval(Container.DataItem,"UserGuid") %>',
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString()) %>',
           '<%#HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem,"FirstName")) %>',
           '<%#HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem,"Description")) %>',
           '<%#HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem,"LastName")) %>',
           '<%#HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem,"AssignedServer")) %>',
           '<%#HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem,"LastVisit")) %>'
           
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">
        var grid;
        function AdjustGridTable() {
            isMobileBrowserOrNarrow();
            var h = 400;

            try {

                var myTable = Ext.get('grid-table');
                var tableY = myTable.getY();

                //var mySetting = Ext.get('farm-setting');
                var settingH = 0; // mySetting.getHeight();

                h = document.body.offsetHeight - tableY - 8 - settingH;
                //var ee = document.getElementById('tinfo');
                //ee.style.height = h + "px";
                if (h < 108) {
                    h = 108;
                }
                if (myTable.style.width > document.documentElement.clientWidth) {
                    myTable.style.width = document.documentElement.clientWidth+"px";
                }

                var e = document.getElementById("grid-example");
                e.style.height = h + "px";
                e.style.width = (document.documentElement.clientWidth - 2) + "px";
            } catch (err) {
            }
            //alert(h);
            //alert(tableY);
            //alert(document.body.offsetHeight);
            grid.setWidth(document.documentElement.clientWidth - 16);
            grid.setHeight(h);
            grid.doComponentLayout();

        }

        Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                  { name: 'index' },
                  { name: 'id' },
                  { name: 'email' },
                  { name: 'fullname' },
                  { name: 'lastaccess' },
                  { name: 'createtime' },
                  { name: 'node' },
                  { name: 'la', sortType: 'asDate'}

              ],
                data: myData
            });



            grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                border: true,
                columnLines: false,
                minHeight: 108,
                columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string5" runat="server">Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'fullname',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + unescape(value) + "</b>";
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string6" runat="server">Email</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'email',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string7" runat="server">Last Access</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'la',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(record.data.lastaccess);
                          
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string8" runat="server">Session Create</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'createtime',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string9" runat="server">Worker Node</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'node',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  }, {
                      xtype: 'actioncolumn',
                      width: 80,
                      hideable: false,
                      items:
                [


                 ]
                  }
        ],
                renderTo: 'grid-example'
            });

            //Ext.EventManager.onWindowResize(grid.doLayout, grid);
            Ext.EventManager.onWindowResize(AdjustGridTable);
            AdjustGridTable();
        });
    </script>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
</asp:Content>
