@echo on
REM transform.cmd input.apk input-dir output.apk
REM it takes 3 command line options.
REM %1 - the input apk file, typically it is the apk file shipped by gladinet (apk file is android package)
REM %2 - the input resource directory , contains bitmaps and information for transform
REM %3 - the output.apk file

if "%1"=="" (
  echo transform.cmd input.apk, the first parameter is missing
  echo transform.cmd input.apk input-dir output.apk
  goto DONE
)

if not exist %1 (
  echo %1, the file doesn't exist, this needs to be the android apk package file
  echo transform.cmd input.apk input-dir output.apk
  goto DONE
)


if "%2"=="" (
  echo the second parameter is missing. It is the input directory
  echo transform.cmd input.apk input-dir output.apk
  goto DONE
)

if not exist %2\NUL (
  echo %2, the folder doesn't exist, this is the input directory
  echo transform.cmd input.apk input-dir output.apk
  goto DONE
)

set outputfile=%3
if "%3"=="" (
 set outputfile=output.apk
)



set mypath=%CD%\
set decodedir=apk.decode
cmd /s /c ""%mypath%apktool" d -f -o %decodedir% %1"

echo copy files
copy /y "%2\ic_launcher_hdpi_72.png" "%decodedir%\res\drawable-hdpi-v4\ic_launcher.png"
copy /y "%2\ic_launcher_ldpi_36.png" "%decodedir%\res\drawable-ldpi-v4\ic_launcher.png"
copy /y "%2\ic_launcher_mdpi_48.png" "%decodedir%\res\drawable-mdpi-v4\ic_launcher.png"
copy /y "%2\ic_launcher_xhdpi_96.png" "%decodedir%\res\drawable-xhdpi-v4\ic_launcher.png"

echo update manifest
perl -pi.bak -e "s/package=\"com.gladinet.cloud\"/package=\"com.abc.def\"/g" %decodedir%\AndroidManifest.xml
perl -pi.bak -e "s/\".MainActivity\"/\"com.gladinet.cloud.MainActivity\"/g" %decodedir%\AndroidManifest.xml
perl -pi.bak -e "s/\".DropFolderService\"/\"com.gladinet.cloud.DropFolderService\"/g" %decodedir%\AndroidManifest.xml
perl -pi.bak -e "s/\".BootCompleteReceiver\"/\"com.gladinet.cloud.BootCompleteReceiver\"/g" %decodedir%\AndroidManifest.xml
perl -pi.bak -e "s/\".NetworkStateReceiver\"/\"com.gladinet.cloud.NetworkStateReceiver\"/g" %decodedir%\AndroidManifest.xml
perl -pi.bak -e "s/\".PowerConnectionReceiver\"/\"com.gladinet.cloud.PowerConnectionReceiver\"/g" %decodedir%\AndroidManifest.xml

del /f %decodedir%\AndroidManifest.xml.bak

echo update strings
"%mypath%AdjustStringXml.exe" "%2\common.txt" %decodedir%\res\values\strings.xml %decodedir%\AndroidManifest.xml

echo now build it again
cmd /s /c ""%mypath%apktool" b -o %outputfile%.temp %decodedir%"


"%JAVA_HOME%\bin\jarsigner" -verbose -sigalg SHA1withRSA -digestalg SHA1 -keystore "%2\common.keystore" "%outputfile%.temp" android -storepass android
"%JAVA_HOME%\bin\jarsigner" -verify -verbose "%outputfile%.temp"

"%mypath%zipalign" -fv 4 %outputfile%.temp %outputfile%

echo output file is %outputfile%

:DONE
