/*
 * Decompiled with CFR 0.152.
 */
package com.simplifiedlogic.nitro.loaders;

import com.simplifiedlogic.nitro.loaders.NitroClassLoader;
import com.simplifiedlogic.nitro.loaders.NitroLoaderDelegate;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class NitroEclipseDelegate
implements NitroLoaderDelegate {
    private ClassLoaderDelegate delegate = null;
    private BaseData bundleData = null;
    private static final String classExtension = NitroClassLoader.encryptedName(".class");
    protected static PrintStream pso = null;

    public NitroEclipseDelegate(ClassLoaderDelegate delegate) throws Exception {
        this(delegate, null);
    }

    public NitroEclipseDelegate(ClassLoaderDelegate delegate, BaseData bundleData) throws Exception {
        this.delegate = delegate;
        this.bundleData = bundleData;
    }

    @Override
    public Class findClass(String classname) throws ClassNotFoundException {
        this.logInfo("findClass: " + classname);
        if (this.delegate != null) {
            this.logInfo("   Looking for class in delegate=" + this.delegate.getClass().getName());
            Class cls = this.delegate.findClass(classname);
            this.logInfo("   found class: " + (cls != null ? cls.getName() : "null"));
            return cls;
        }
        return null;
    }

    @Override
    public URL findResource(String resource) {
        this.logInfo("findResource: " + resource);
        if (this.delegate != null) {
            URL url = this.delegate.findResource(resource);
            if (url != null) {
                Bundle bundle;
                this.logInfo("   found: " + url);
                if (resource.endsWith(classExtension) && (bundle = this.getBundle(url)) != null) {
                    try {
                        this.checkActivate(bundle);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.logInfo("Error in delegate: " + e.getMessage());
                        this.logTrace(e);
                    }
                    this.logInfo("bundle.getResource");
                    bundle.getResource(resource);
                }
            }
            return url;
        }
        return null;
    }

    @Override
    public Class findRemoteClass(String name) throws ClassNotFoundException {
        String resource;
        URL url;
        this.logInfo("findRemoteClass: " + name);
        if (this.delegate != null && (url = this.delegate.findResource(resource = NitroClassLoader.encryptedName(NitroClassLoader.classToFileName(name)))) != null) {
            this.logInfo("   found: " + url);
            if (resource.endsWith(classExtension) || resource.endsWith(".class")) {
                Bundle bundle = this.getBundle(url);
                this.logInfo("    remote bundle:" + bundle);
                if (bundle != null && bundle.getBundleId() != this.bundleData.getBundleID()) {
                    Class cls = null;
                    String activator = (String)bundle.getHeaders().get("Bundle-Activator");
                    this.logInfo("    Activator: " + activator);
                    if (activator != null && activator.equals(name)) {
                        cls = bundle.loadClass(name);
                        this.logInfo("    found class before activate: " + (cls != null ? cls.getName() : "null"));
                    }
                    try {
                        this.checkActivate(bundle);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.logTrace(e, "Error in delegate: " + e.getMessage());
                    }
                    if (cls == null) {
                        cls = bundle.loadClass(name);
                        this.logInfo("    found class after activate: " + (cls != null ? cls.getName() : "null"));
                    }
                    return cls;
                }
            }
        }
        return null;
    }

    @Override
    public Enumeration findResources(String resource) throws IOException {
        if (this.delegate != null) {
            return this.delegate.findResources(resource);
        }
        return null;
    }

    @Override
    public String findLibrary(String libraryname) {
        if (this.delegate != null) {
            return this.delegate.findLibrary(libraryname);
        }
        return null;
    }

    private void checkActivate(Bundle bundle) throws Exception {
        this.logInfo("checkActivate");
        this.logInfo("    ACTIVATING BUNDLE: " + bundle.getSymbolicName() + " -- " + bundle.getClass().getName());
        this.logInfo("    bundle state: " + bundle.getState());
        Thread threadChangingState = ((AbstractBundle)bundle).getStateChanging();
        if (bundle.getState() == 8 && threadChangingState == Thread.currentThread()) {
            return;
        }
        this.logInfo("    calling start()");
        bundle.start();
    }

    private Bundle getBundle(URL url) {
        if (this.bundleData != null) {
            this.logInfo("    cur bundle: " + this.bundleData.getBundleID() + " : " + this.bundleData.getBundle().getSymbolicName());
            this.logInfo("    location: " + this.bundleData.getBundle().getLocation());
            String idStr = url.getHost();
            long id = 0L;
            try {
                id = Integer.parseInt(idStr);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (id > 0L) {
                BundleContext context = this.bundleData.getBundle().getBundleContext();
                Bundle bundle = id != this.bundleData.getBundleID() ? context.getBundle(id) : this.bundleData.getBundle();
                return bundle;
            }
        }
        return null;
    }

    private void logInfo(String msg) {
        if (msg != null) {
            this.createOut();
            if (pso != null) {
                pso.println(msg);
                pso.flush();
            } else {
                System.out.println(msg);
            }
        }
    }

    private synchronized void createOut() {
        if (pso == null) {
            try {
                String tmpdir = System.getProperty("java.io.tmpdir");
                tmpdir = tmpdir == null || tmpdir.length() == 0 ? "" : tmpdir + "/";
                String filename = tmpdir + "delegate_out.txt";
                pso = new PrintStream(new File(filename));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void logTrace(Throwable e) {
        this.logTrace(e, null);
    }

    private void logTrace(Throwable e, String msg) {
        this.createOut();
        if (pso != null) {
            if (msg != null) {
                pso.println(msg);
            }
            e.printStackTrace(pso);
            pso.flush();
        } else {
            if (msg != null) {
                System.err.println(msg);
            }
            e.printStackTrace();
        }
    }
}

