/*
 * Decompiled with CFR 0.152.
 */
package com.simplifiedlogic.nitro.loaders;

import com.simplifiedlogic.nitro.loaders.NitroLoaderDelegate;
import com.simplifiedlogic.nitro.loaders.NitroNativeInitializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Stack;

public class NitroClassLoader
extends ClassLoader {
    public static final String LIB_ENC_WIN_NAME = "enc-win";
    public static final String LIB_ENC_WIN_X64_NAME = "enc-win-x64";
    public static final String LIB_ENC_TUX_NAME = "enc-tux";
    public static final String LIB_ENC_TUX_X64_NAME = "enc-tux-x64";
    public static final String LIB_ENC_OSX_NAME = "enc-osx";
    public static final String LIB_ENC_WIN_LOCAL_NAME = "NitroLM.dll";
    public static final String LIB_ENC_WIN_X64_LOCAL_NAME = "NitroLM_x64.dll";
    public static final String LIB_ENC_TUX_LOCAL_NAME = "libNitroLM.so";
    public static final String LIB_ENC_TUX_X64_LOCAL_NAME = "libNitroLM_x64.so";
    public static final String LIB_ENC_OSX_LOCAL_NAME = "libNitroLM.dylib";
    public static final String[] LIBS = new String[]{"enc-win", "enc-win-x64", "enc-tux", "enc-tux-x64", "enc-osx"};
    public static boolean debug = false;
    private static boolean loaded = false;
    private static boolean extracted = false;
    private String libname = null;
    private String tmpdir = null;
    private NitroLoaderDelegate delegate = null;
    protected PrintStream pso = null;

    public NitroClassLoader(ClassLoader parent, NitroLoaderDelegate delegate) throws Exception {
        this(parent, delegate, null);
    }

    public NitroClassLoader(ClassLoader parent, NitroLoaderDelegate delegate, String tmpdir) throws Exception {
        this(parent);
        this.delegate = delegate;
        this.tmpdir = tmpdir;
        this.logInfo("constructor for loader 2, delegate=" + delegate + ", tmpdir=" + tmpdir);
    }

    public NitroClassLoader(ClassLoader parent) throws Exception {
        super(parent);
        Class.forName("com.simplifiedlogic.nitro.loaders.NitroNativeInitializer");
        Class.forName("java.lang.StringBuilder");
        Class.forName("java.lang.System");
        Class.forName("java.io.PrintStream");
        Class.forName("java.io.BufferedInputStream");
        Class.forName("java.io.BufferedOutputStream");
        Class.forName("java.io.File");
        Class.forName("java.io.FileOutputStream");
        Class.forName("java.io.ByteArrayOutputStream");
        Class.forName("java.io.InputStream");
    }

    private String extractLib() {
        File f = null;
        String filename = null;
        try {
            InputStream is = null;
            String libname = NitroClassLoader.getNativeLibraryName();
            if (this.delegate != null) {
                this.logInfo("Checking delegate for DLL: " + libname);
                URL url = this.delegate.findResource(libname);
                if (url != null) {
                    is = url.openStream();
                }
            }
            if (is == null) {
                this.logInfo("Checking classloader for DLL: " + libname);
                ClassLoader cl = NitroClassLoader.class.getClassLoader();
                is = cl.getResourceAsStream(libname);
            }
            if (is == null) {
                this.logInfo("Library " + libname + " not found.");
                return null;
            }
            if (loaded) {
                this.logInfo("Must have already loaded: " + libname + ", busting out");
                return null;
            }
            if (this.tmpdir == null) {
                this.tmpdir = System.getProperty("java.io.tmpdir");
            }
            if (!this.tmpdir.endsWith(File.separator)) {
                this.tmpdir = this.tmpdir + File.separator;
            }
            filename = this.tmpdir + NitroClassLoader.getLocalNativeLibraryName();
            if (!extracted) {
                int len;
                BufferedInputStream bis = new BufferedInputStream(is);
                this.logInfo("Extracting library to " + filename);
                f = new File(filename);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buf = new byte[1024];
                while ((len = bis.read(buf)) >= 0) {
                    bos.write(buf, 0, len);
                }
                bos.close();
                bis.close();
                this.logInfo("lib:" + filename);
                extracted = true;
            }
            return filename;
        }
        catch (IOException e) {
            if (f != null && f.exists() && f.canRead()) {
                this.logInfo("Cannot overwrite dll.  Using existing version");
                return filename;
            }
            this.logTrace(e, "error in extractLib()");
            return null;
        }
        catch (Error e) {
            this.logTrace(e, "FATAL error in extractLib()");
            throw e;
        }
    }

    public String registerNatives(boolean debugMode) {
        if (!debugMode) {
            return this.registerNatives();
        }
        loaded = true;
        return null;
    }

    public String registerNatives() {
        if (!loaded) {
            this.libname = this.extractLib();
            if (this.libname != null && !loaded) {
                this.logInfo("Loading DLL: " + this.libname);
                NitroNativeInitializer.load(this.libname);
                loaded = true;
            } else {
                this.logInfo("COULD NOT FIND DLL, path=" + System.getProperty("java.class.path"));
            }
        }
        return this.libname;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Class findClass(String name) throws ClassNotFoundException {
        block26: {
            block25: {
                block27: {
                    block24: {
                        block23: {
                            this.logInfo("-------------------");
                            this.logInfo("finding class in loader3: " + name);
                            this.registerNatives();
                            c = this.findLoadedClass(name);
                            if (c == null) break block23;
                            this.logInfo("Found loaded class (1): " + c);
                            var3_3 = c;
                            this.logInfo("Exiting findClass() for " + name);
                            this.logInfo("-------------------");
                            return var3_3;
                        }
                        if (this.delegate == null) ** GOTO lbl30
                        this.logInfo("Checking findRemoteClass()");
                        c = this.delegate.findRemoteClass(name);
                        if (c == null) break block24;
                        this.logInfo("Found remote class: " + c);
                        var3_4 = c;
                        this.logInfo("Exiting findClass() for " + name);
                        this.logInfo("-------------------");
                        return var3_4;
                    }
                    break block27;
                    {
                        catch (ClassNotFoundException e) {
                            this.logInfo("Class not found remotely: " + name);
                        }
                    }
                }
                enc = true;
                classdata = this.readBlob(NitroClassLoader.encryptedName(NitroClassLoader.classToFileName(name)));
                if (classdata == null) ** GOTO lbl68
                c = this.findLoadedClass(name);
                if (c == null) break block25;
                this.logInfo("Found loaded class (3): " + c);
                var5_13 = c;
                this.logInfo("Exiting findClass() for " + name);
                this.logInfo("-------------------");
                return var5_13;
            }
            cs = new CodeSource(null, (Certificate[])null);
            domain = new ProtectionDomain(cs, null, this, null);
            source = this.defineClassSourceLocation(domain);
            if (enc) {
                this.logInfo("Defining class natively (0): " + name);
                this.logInfo("Encrypted class size: " + classdata.length);
                this.loadOneClass0(name, classdata, domain, source);
            } else {
                this.logInfo("Defining class natively (1): " + name);
                this.loadOneClass1(name, classdata, domain, source);
            }
            c = this.findLoadedClass(name);
            if (c == null) break block26;
            this.logInfo("Found loaded class (2): " + c);
            var8_17 = c;
            this.logInfo("Exiting findClass() for " + name);
            this.logInfo("-------------------");
            return var8_17;
        }
        try {
            this.logInfo("findLoadedClass() returned NULL after loading from C DLL!!");
            {
                catch (IOException e) {
                    this.logInfo("File " + NitroClassLoader.encryptedName(NitroClassLoader.classToFileName(name)) + " was not found");
                }
            }
lbl68:
            // 3 sources

            if (name.startsWith("com.simplifiedlogic.")) {
                loaderStack = new Stack<NitroClassLoader>();
                for (temp /* !! */  = this; temp /* !! */  != null; temp /* !! */  = temp /* !! */ .getParent()) {
                    loaderStack.push(temp /* !! */ );
                }
                c = null;
                while (c == null && !loaderStack.isEmpty()) {
                    c = ((ClassLoader)loaderStack.pop()).loadClass(name);
                }
                if (c != null) {
                    var5_14 = c;
                    return var5_14;
                }
            }
            if (this.getParent() != null) {
                this.logInfo("Could not find class, going to parent=" + (this.getParent() == null ? "null" : this.getParent().getClass().getName()));
                temp = c = this.getParent().loadClass(name);
                return temp;
            }
            this.logInfo("Could not find class, going to super=" + super.getClass().getName());
            temp = super.findClass(name);
            return temp;
        }
        catch (Throwable var9_18) {
            throw var9_18;
        }
        finally {
            this.logInfo("Exiting findClass() for " + name);
            this.logInfo("-------------------");
        }
    }

    private native void loadOneClass0(String var1, byte[] var2, ProtectionDomain var3, String var4);

    private native void loadOneClass1(String var1, byte[] var2, ProtectionDomain var3, String var4);

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block9: {
            this.logInfo("===================================");
            this.logInfo("loading class in loader3:" + name);
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                    this.logInfo("found class:" + c);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader parent = this.getParent();
                    if (this.delegate != null) {
                        this.logInfo("class not found, looking to delegate=" + this.delegate.getClass().getName());
                        try {
                            c = this.delegate.findClass(name);
                            this.logInfo("found class from delegate:" + c);
                        }
                        catch (ClassNotFoundException e2) {
                            // empty catch block
                        }
                    }
                    if (c == null) {
                        if (parent == null) {
                            this.logInfo("not found from local, delegate, or blob, throwing exception");
                            throw e;
                        }
                        this.logInfo("class not found, looking to parent=" + parent.getClass().getName());
                        c = parent.loadClass(name);
                        this.logInfo("found class from parent:" + c);
                    }
                    break block9;
                }
            }
            this.logInfo("class already loaded");
        }
        if (resolve && c != null) {
            this.resolveClass(c);
        }
        return c;
    }

    private String defineClassSourceLocation(ProtectionDomain protectionDomain) {
        CodeSource cs = protectionDomain.getCodeSource();
        String source = null;
        if (cs != null && cs.getLocation() != null) {
            source = cs.getLocation().toString();
        }
        return source;
    }

    private byte[] readBlob(String name) throws IOException {
        return this.readStaticBlob(this.getClass(), name);
    }

    private byte[] readStaticBlob(Class c, String name) throws IOException {
        InputStream is = null;
        if (this.delegate != null) {
            this.logInfo("loading blob " + name + " using delegate ");
            URL url = this.delegate.findResource(name);
            if (url != null) {
                this.logInfo("url=" + url);
                is = url.openStream();
            }
        } else {
            ClassLoader cl = c.getClassLoader();
            this.logInfo("loading blob " + name + " using loader " + cl.getClass().getName() + " from class " + c.getName());
            is = cl.getResourceAsStream(name);
        }
        if (is == null) {
            this.logInfo("Could not open blob " + name);
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = is.read(b)) != -1) {
            bos.write(b, 0, len);
        }
        is.close();
        bos.close();
        this.logInfo("readBlob found bytes: " + bos.toByteArray().length);
        return bos.toByteArray();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is;
        this.logInfo("getting resource: " + name);
        try {
            byte[] filedata = this.readBlob(NitroClassLoader.encryptedName(name));
            if (filedata != null) {
                this.logInfo("decrypting using getResourceAsStream0");
                InputStream is2 = this.getResourceAsStream0(filedata);
                return is2;
            }
            if (this.delegate != null) {
                InputStream is3;
                this.logInfo("loading blob " + name + " using delegate ");
                URL url = this.delegate.findResource(name);
                if (url != null && (is3 = url.openStream()) != null) {
                    return is3;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.getParent() != null && (is = this.getParent().getResourceAsStream(name)) != null) {
            return is;
        }
        this.logInfo("Could not find " + name + " locally, using superclass");
        return super.getResourceAsStream(name);
    }

    private native InputStream getResourceAsStream0(byte[] var1);

    public static String encryptedName(String filename) {
        if (filename == null) {
            return null;
        }
        int pos = filename.lastIndexOf(46);
        String ename = pos == -1 || pos == filename.length() - 1 ? filename + ".enc" : filename.substring(0, ++pos) + "n" + filename.substring(pos);
        return ename;
    }

    public static String classToFileName(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    public static String fileToClassName(String filename) {
        if (filename.endsWith(".class")) {
            filename = filename.substring(0, filename.length() - 6);
            filename = filename.replace('/', '.');
            filename = filename.replace('\\', '.');
            return filename;
        }
        return filename;
    }

    private void logInfo(String msg) {
        if (debug && msg != null) {
            this.createOut();
            if (this.pso != null) {
                this.pso.println(msg);
                this.pso.flush();
            } else {
                System.out.println(msg);
            }
        }
    }

    private synchronized void createOut() {
        if (this.pso == null) {
            try {
                if (this.tmpdir == null) {
                    this.tmpdir = System.getProperty("java.io.tmpdir");
                }
                if (this.tmpdir == null || this.tmpdir.length() == 0) {
                    this.tmpdir = "";
                } else if (!this.tmpdir.endsWith(File.separator)) {
                    this.tmpdir = this.tmpdir + File.separator;
                }
                String filename = this.tmpdir + "loader_out.txt";
                this.pso = new PrintStream(new File(filename));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void logTrace(Throwable e) {
        this.logTrace(e, null);
    }

    private void logTrace(Throwable e, String msg) {
        if (debug) {
            this.createOut();
            if (this.pso != null) {
                if (msg != null) {
                    this.pso.println(msg);
                }
                e.printStackTrace(this.pso);
                this.pso.flush();
            } else {
                if (msg != null) {
                    System.err.println(msg);
                }
                e.printStackTrace();
            }
        }
    }

    public void enableDebug() {
        debug = true;
        this.enableDebug0();
    }

    private native void enableDebug0();

    public static String getNativeLibraryName() {
        String arch = System.getProperty("java.vm.name");
        String os = System.getProperty("os.name").toLowerCase();
        if (arch.indexOf("64") > -1) {
            if (os.indexOf("windows") > -1) {
                return LIB_ENC_WIN_X64_NAME;
            }
            if (os.indexOf("linux") > -1) {
                return LIB_ENC_TUX_X64_NAME;
            }
            return LIB_ENC_OSX_NAME;
        }
        if (os.indexOf("windows") > -1) {
            return LIB_ENC_WIN_NAME;
        }
        if (os.indexOf("linux") > -1) {
            return LIB_ENC_TUX_NAME;
        }
        return LIB_ENC_OSX_NAME;
    }

    public static String getLocalNativeLibraryName() {
        String arch = System.getProperty("java.vm.name");
        String os = System.getProperty("os.name").toLowerCase();
        if (arch.indexOf("64") > -1) {
            if (os.indexOf("windows") > -1) {
                return LIB_ENC_WIN_X64_LOCAL_NAME;
            }
            if (os.indexOf("linux") > -1) {
                return LIB_ENC_TUX_X64_LOCAL_NAME;
            }
            return LIB_ENC_OSX_LOCAL_NAME;
        }
        if (os.indexOf("windows") > -1) {
            return LIB_ENC_WIN_LOCAL_NAME;
        }
        if (os.indexOf("linux") > -1) {
            return LIB_ENC_TUX_LOCAL_NAME;
        }
        return LIB_ENC_OSX_LOCAL_NAME;
    }
}

