/*
 * Decompiled with CFR 0.152.
 */
package com.simplifiedlogic.nitro.loaders;

import com.simplifiedlogic.nitro.loaders.LicenseClientDelegate;
import com.simplifiedlogic.nitro.loaders.NitroClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseCommand {
    private static final String CMD_GETLICENSE = "getLicense";
    private static final String CMD_RELEASE = "releaseLicense";
    private static final String CMD_GETLICENSEINFO = "getLicenseInfo";
    private static final String CMD_SETPROXY = "setProxy";
    private static final String CMD_CLEARPROXY = "clearProxy";
    private static final String CMD_GETPROXY = "getProxy";
    private static final String OPT_EMAIL = "-e";
    private static final String OPT_PWD = "-w";
    private static final String OPT_PRODUCT = "-p";
    private static final String OPT_TYPE = "-t";
    private static final String OPT_COMPANY = "-c";
    private static final String OPT_VERSION = "-v";
    private static final String OPT_SOURCE = "-s";
    private static final String OPT_DAYS = "-d";
    private static final String OPT_USEQUEUE = "-q";
    private static final String OPT_SERVERONLY = "-a";
    private static final String OPT_HOST = "-h";
    private static final String OPT_PORT = "-o";
    private static final String OPT_USER = "-u";
    private static final String OPT_HELP1 = "-help";
    private static final String OPT_HELP2 = "-?";
    public static final String TYPE_DEMO = "demo";
    public static final String TYPE_FLOATING = "floating";
    public static final String TYPE_FIXED = "checkout";
    public static final String TYPE_LOCKED = "nodelock";
    private static final String[] cmdMaster = new String[]{"getLicense".toLowerCase(), "releaseLicense".toLowerCase(), "getLicenseInfo".toLowerCase(), "setProxy".toLowerCase(), "clearProxy".toLowerCase(), "getProxy".toLowerCase()};
    private static final String[] optMaster = new String[]{"-help", "-?", "-e", "-w", "-p", "-t", "-c", "-v", "-s", "-d", "-q", "-a", "-h", "-o", "-u"};

    public static void main(String[] args) {
        try {
            NitroClassLoader ncl = new NitroClassLoader(LicenseCommand.class.getClassLoader());
            ncl.registerNatives();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LicenseCommand handler = new LicenseCommand();
        handler.handle(args);
    }

    public void usage() {
        System.out.println("Usage: " + LicenseCommand.class.getName() + " <command> <options>");
        System.out.println("");
        System.out.println("Valid commands: ");
        for (int i = 0; i < cmdMaster.length; ++i) {
            System.out.println("   " + cmdMaster[i]);
        }
        System.out.println("");
    }

    public void handle(String[] args) {
        ArrayList<String> items = new ArrayList<String>();
        HashMap<String, String> opts = new HashMap<String, String>();
        if (args == null || args.length == 0) {
            this.usage();
            return;
        }
        String cmd = args[0].toLowerCase();
        if (cmd.toLowerCase().equals(OPT_HELP1) || cmd.toLowerCase().equals(OPT_HELP2)) {
            this.usage();
            return;
        }
        if (!LicenseCommand.validCommand(cmd)) {
            System.err.println("Unknown command: " + cmd);
            return;
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                String opt = args[i].toLowerCase();
                if (!LicenseCommand.validOption(opt)) {
                    System.err.println("Unknown option: " + args[i]);
                    return;
                }
                if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                    opts.put(opt, "");
                    continue;
                }
                opts.put(opt, args[i + 1]);
                ++i;
                continue;
            }
            items.add(args[i]);
        }
        int ret = -1;
        if (cmd.equals(CMD_GETLICENSE.toLowerCase())) {
            ret = this.getLicense(opts, items);
        } else if (cmd.equals(CMD_RELEASE.toLowerCase())) {
            ret = this.releaseLicense(opts, items);
        } else if (cmd.equals(CMD_GETLICENSEINFO.toLowerCase())) {
            ret = this.getLicenseInfo(opts, items);
        } else if (cmd.equals(CMD_SETPROXY.toLowerCase())) {
            this.setProxyInfo(opts, items);
        } else if (cmd.equals(CMD_CLEARPROXY.toLowerCase())) {
            this.removeProxy(opts, items);
        } else if (cmd.equals(CMD_GETPROXY.toLowerCase())) {
            this.getProxy(opts, items);
        } else {
            System.err.println("Command not handled: " + cmd);
        }
    }

    private static boolean validCommand(String cmd) {
        if (cmd == null) {
            return false;
        }
        for (int i = 0; i < cmdMaster.length; ++i) {
            if (!cmdMaster[i].equals(cmd)) continue;
            return true;
        }
        return false;
    }

    private static boolean validOption(String opt) {
        if (opt == null) {
            return false;
        }
        for (int i = 0; i < optMaster.length; ++i) {
            if (!optMaster[i].equals(opt)) continue;
            return true;
        }
        return false;
    }

    public static String typeString(String locktype) {
        if (locktype == null) {
            return null;
        }
        if (locktype.equals("D")) {
            return TYPE_DEMO;
        }
        if (locktype.equals("L")) {
            return TYPE_FIXED;
        }
        if (locktype.equals("F")) {
            return TYPE_FLOATING;
        }
        return null;
    }

    private String getOpt(String opt, Map opts, String descrip, boolean required) {
        String val = (String)opts.get(opt);
        if (val == null || val.length() == 0) {
            if (required) {
                System.err.println("Missing " + descrip);
            }
            return null;
        }
        return val;
    }

    private int getLicense(Map opts, List items) {
        String dayStr;
        if (opts.get(OPT_HELP1) != null || opts.get(OPT_HELP2) != null || opts.size() == 0 && items.size() == 0) {
            System.out.println("Usage: getLicense -e email -w password -p product-code -t license-type [-c company-code] [-v version] [-d number-of-days] [-q] ");
            System.out.println("");
            System.out.println("-e email            user's email address");
            System.out.println("-w password         user's password");
            System.out.println("-p product-code     code for the license required");
            System.out.println("-t license-type     type of license to get");
            System.out.println("                    Valid license-types are demo, checkout, floating");
            System.out.println("-c company-code     code for the company that owns the license");
            System.out.println("                    Required if the type is checkout or floating");
            System.out.println("-v version          software version for validation");
            System.out.println("-d number-of-days   number of days for the license");
            System.out.println("                    Required for checkout, optional for demo, ignored for floating");
            System.out.println("-q                  automatically use license queue if available.");
            return -1;
        }
        String email = this.getOpt(OPT_EMAIL, opts, "email address", true);
        if (email == null) {
            return -1;
        }
        String pwd = this.getOpt(OPT_PWD, opts, "password", true);
        if (pwd == null) {
            return -1;
        }
        String product = this.getOpt(OPT_PRODUCT, opts, "product-code", true);
        if (product == null) {
            return -1;
        }
        String type = this.getOpt(OPT_TYPE, opts, "license-type", true);
        if (type == null) {
            return -1;
        }
        String company = null;
        Integer days = null;
        boolean useQueue = false;
        if (type.equals(TYPE_DEMO)) {
            dayStr = this.getOpt(OPT_DAYS, opts, "number-of-days", false);
            if (dayStr != null) {
                try {
                    days = Integer.valueOf(dayStr);
                }
                catch (Exception e) {
                    System.err.println("Invalid number-of-days value");
                    return -1;
                }
            }
        } else if (type.equals(TYPE_FLOATING)) {
            company = this.getOpt(OPT_COMPANY, opts, "company-code", true);
            if (company == null) {
                return -1;
            }
            String queueStr = this.getOpt(OPT_USEQUEUE, opts, "use-queue flag", false);
            if (queueStr != null) {
                useQueue = true;
            }
        } else if (type.equals(TYPE_FIXED)) {
            company = this.getOpt(OPT_COMPANY, opts, "company-code", true);
            if (company == null) {
                return -1;
            }
            dayStr = this.getOpt(OPT_DAYS, opts, "number-of-days", true);
            if (dayStr == null) {
                return -1;
            }
            try {
                days = Integer.valueOf(dayStr);
            }
            catch (Exception e) {
                System.err.println("Invalid number-of-days value");
                return -1;
            }
            String queueStr = this.getOpt(OPT_USEQUEUE, opts, "use-queue flag", false);
            if (queueStr != null) {
                useQueue = true;
            }
        } else {
            System.err.println("Unknown license-type: " + type);
        }
        String version = this.getOpt(OPT_VERSION, opts, "version", false);
        String market_source = this.getOpt(OPT_SOURCE, opts, "source", false);
        LicenseClientDelegate lc = new LicenseClientDelegate();
        int ret = lc.getLicense(email, pwd, company, product, version, days, market_source, useQueue);
        System.out.println("Response:" + lc.getResponseMessage(ret));
        return ret;
    }

    private int releaseLicense(Map opts, List items) {
        if (opts.get(OPT_HELP1) != null || opts.get(OPT_HELP2) != null || opts.size() == 0 && items.size() == 0) {
            System.out.println("Usage: releaseLicense -p product-code [-v version] [-a] ");
            System.out.println("");
            System.out.println("-p product-code   code for the license required");
            System.out.println("-v version        software version for validation");
            System.out.println("-a                auto-renew license on next validation.");
            return -1;
        }
        String product = this.getOpt(OPT_PRODUCT, opts, "product-code", true);
        if (product == null) {
            return -1;
        }
        String version = this.getOpt(OPT_VERSION, opts, "version", false);
        boolean serveronly = false;
        String queueStr = this.getOpt(OPT_USEQUEUE, opts, "use-queue flag", false);
        if (queueStr != null) {
            serveronly = true;
        }
        LicenseClientDelegate lc = new LicenseClientDelegate();
        int ret = lc.releaseLicense(product, version, serveronly);
        System.out.println("Response:" + lc.getResponseMessage(ret));
        return ret;
    }

    private int getLicenseInfo(Map opts, List items) {
        Boolean bval;
        Date dval;
        HashMap licenseValues;
        if (opts.get(OPT_HELP1) != null || opts.get(OPT_HELP2) != null || opts.size() == 0 && items.size() == 0) {
            System.out.println("Usage: getLicenseInfo -p product-code [-v version] ");
            System.out.println("");
            System.out.println("-p product-code   code for the license required");
            System.out.println("-v version        software version for validation");
            return -1;
        }
        String product = this.getOpt(OPT_PRODUCT, opts, "product-code", true);
        if (product == null) {
            return -1;
        }
        LicenseClientDelegate lc = new LicenseClientDelegate();
        String version = this.getOpt(OPT_VERSION, opts, "version", false);
        int ret = lc.getLicenseDisplayInfo(version, product, licenseValues = new HashMap());
        if (ret != 0) {
            System.err.println("No license info available: " + lc.getResponseMessage(ret));
            return -1;
        }
        String sval = (String)licenseValues.get("locktype");
        if (sval != null) {
            System.out.println("license-type: " + LicenseCommand.typeString(sval));
        }
        if ((sval = (String)licenseValues.get("product")) != null) {
            System.out.println("product-code: " + sval);
        }
        if ((dval = (Date)licenseValues.get("expires")) != null) {
            System.out.println("expires: " + dval.toString());
        }
        if ((bval = (Boolean)licenseValues.get("disabled")) != null && bval.booleanValue()) {
            System.out.println("LICENSE IS DISABLED");
        }
        return ret;
    }

    private void setProxyInfo(Map opts, List items) {
        if (opts.get(OPT_HELP1) != null || opts.get(OPT_HELP2) != null || opts.size() == 0 && items.size() == 0) {
            System.out.println("Usage: setProxy -h proxy-host -o proxy-port [-u user-login] [-w user-password] ");
            System.out.println("");
            System.out.println("-h proxy-host      host name for the proxy");
            System.out.println("-o proxy-port      port for the proxy");
            System.out.println("-u user-login      username for the proxy");
            System.out.println("-w user-password   user's password for the proxy");
            return;
        }
        String host = this.getOpt(OPT_HOST, opts, "proxy-host", true);
        if (host == null) {
            return;
        }
        String port = this.getOpt(OPT_PORT, opts, "product-port", true);
        if (port == null) {
            return;
        }
        String user = this.getOpt(OPT_USER, opts, "user-login", false);
        String password = this.getOpt(OPT_PWD, opts, "user-password", false);
        LicenseClientDelegate lc = new LicenseClientDelegate();
        lc.setProxyInfo(host, port, user, password);
    }

    private void removeProxy(Map opts, List items) {
        if (opts.get(OPT_HELP1) != null || opts.get(OPT_HELP2) != null) {
            System.out.println("Usage: clearProxy ");
            return;
        }
        LicenseClientDelegate lc = new LicenseClientDelegate();
        lc.removeProxy();
    }

    private void getProxy(Map opts, List items) {
        if (opts.get(OPT_HELP1) != null || opts.get(OPT_HELP2) != null) {
            System.out.println("Usage: getProxy ");
            return;
        }
        LicenseClientDelegate lc = new LicenseClientDelegate();
        Map proxyMap = lc.getProxy();
        if (proxyMap == null) {
            System.out.println("No proxy defined");
            return;
        }
        System.out.println("proxy-host: " + proxyMap.get("host"));
        System.out.println("proxy-port: " + proxyMap.get("port"));
        System.out.println("user-login: " + proxyMap.get("user"));
    }
}

