﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Syncfusion.PdfViewer.Mvc;
using System.IO;
//using Microsoft.WindowsAzure.ServiceRuntime;
using Syncfusion.Pdf.Parsing;
//using Microsoft.WindowsAzure.StorageClient;
using System.Threading;
using Syncfusion.Pdf;
using Syncfusion.Pdf.Graphics;
using Syncfusion.Pdf.HtmlToPdf;
using Syncfusion.HtmlConverter;
using System.Drawing;
using Syncfusion.Mvc.Pdf.Web;

namespace HTMLPDF.Controllers
{
    public partial class PdfViewerController : Controller
    {
        string url = "www.google.com";
        PdfDocument doc;
        public ActionResult PdfViewerFeatures(string urlPath)
        {
            try
            {
                Thread t = new Thread(CreateDocument);
                t.SetApartmentState(ApartmentState.STA);
                t.Start();
                t.Join();
            }
            catch(Exception e)
            {
                ViewData["Message"] = "Error during conversion, Loading default PDF..";
            }

            return doc.ExportAsActionResult("sample.pdf", HttpContext.ApplicationInstance.Response, HttpReadType.Save);
        }

        public void Export()
        {

        }

        public void CreateDocument()
        {
            doc = new PdfDocument();
            doc.PageSettings.Margins.All = 0;
            PdfPage page = doc.Pages.Add();
            try
            {

                PdfUnitConvertor convertor = new PdfUnitConvertor();
                float width = convertor.ConvertToPixels(doc.PageSettings.Width, PdfGraphicsUnit.Point);

                using (var converter = new HtmlConverter())
                {
                    HtmlToPdfResult result = converter.Convert(url, ImageType.Metafile, (int)width, -1, AspectRatio.KeepWidth);

                    result.Render(page, new PdfLayoutFormat());
                }
            }
            catch(Exception ex)
            {
            PdfFont titleFont = new PdfStandardFont(PdfFontFamily.Helvetica, 14);
            doc.Pages[0].Graphics.DrawString(ex.ToString(), titleFont, PdfBrushes.Black, new PointF(0, 0));
            }
            
            ViewData["ProductName"] = "PdfViewer..";
            ViewData["Message"] = "Success..";
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult PdfViewerFeatures(PdfViewerParams args)
        {
            return View();
        }
    }
}
