﻿#region Copyright
// Copyright Syncfusion Inc. 2001 - 2012. All rights reserved.
// Use of this code is subject to the terms of our license.
// A copy of the current license can be obtained at any time by e-mailing
// licensing@syncfusion.com. Any infringement will be prosecuted under
// applicable laws. 
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;
using Syncfusion.Pdf;
using Syncfusion.Pdf.Graphics;


namespace Syncfusion.Mvc.Pdf.Web
{
    public class PdfResult : ActionResult
    {
        private string m_filename;
        private PdfDocument m_pdfDocument;
        private HttpResponse m_response;
        private HttpReadType m_readType;

        public string FileName
        {
            get
            {
                return m_filename;
            }
            set
            {
                m_filename = value;
            }
        }
        public PdfDocument PdfDoc
        {
            get
            {
                if (m_pdfDocument != null)
                    return m_pdfDocument;
                return null;
            }
        }
        public HttpResponse Response
        {
            get
            {
                return m_response;
            }
        }
        public HttpReadType ReadType
        {
            get
            {
                return m_readType;
            }
            set
            {
                m_readType = value;
            }
        }

        public PdfResult(PdfDocument pdfDocument, string filename, HttpResponse respone, HttpReadType type)
        {
            this.m_pdfDocument = pdfDocument;
            this.FileName = filename;
            this.m_response = respone;
            this.ReadType = type;
        }
        public override void ExecuteResult(ControllerContext context)
        {
            if (context == null)
                return;
            this.PdfDoc.Save(FileName, Response, ReadType);
        }


    }
}
