﻿using Syncfusion.SfDiagram.XForms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace GettingStarted
{
    // Learn more about making custom code visible in the Xamarin.Forms previewer
    // by visiting https://aka.ms/xamarinforms-previewer
    [DesignTimeVisible(false)]
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            //Initializes the SfDiagram
            Node Begin = AddNode("Begin", 150, 60, 120, 40, "Begin", ShapeType.Ellipse);
            Node Process = AddNode("Process", 150, 140, 120, 60, "Process", ShapeType.Rectangle);
            Node End = AddNode("End", 190, 225, 40, 40, "End", ShapeType.Ellipse);
            //Add nodes to the SfDiagram
            diagram.AddNode(Begin);
            diagram.AddNode(Process);
            diagram.AddNode(End);
            Connector connector1 = new Connector()
            {
                SourceNode = Begin,
                TargetNode = Process,
            };
            Connector connector2 = new Connector()
            {
                SourceNode = Process,
                TargetNode = End,
            };
            //Add connectors to the SfDiagram
            diagram.AddConnector(connector1);
            diagram.AddConnector(connector2);
        }

        ///<summary>
        ///create the node
        ///</summary>
        public Node AddNode(string id, float offsetX, float offsetY, float width, float height, string text, ShapeType shape)
        {
            Node node = new Node();
            node.OffsetX = offsetX;
            node.OffsetY = offsetY;
            node.Height = height;
            node.Width = width;
            node.ShapeType = shape;
            node.Style.Brush = new SolidBrush(Color.FromRgb(100, 149, 237));
            node.Annotations.Add(new Annotation() { Content = text });
            return node;
        }
    }
}