/*******************************************************************************

Copyright (c) 2001-2006, Intel Corporation 
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright 
    notice, this list of conditions and the following disclaimer in the 
    documentation and/or other materials provided with the distribution.

 3. Neither the name of the Intel Corporation nor the names of its 
    contributors may be used to endorse or promote products derived from 
    this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#include "UICommon.h"

string getErrMessage(int err) {
    switch (err) {
    case S_OK: return "";
    case ASF_ERROR_PROXY_NOT_REACHABLE: return "Management console cannot be reached.";
    case ASF_ERROR_ADAPTERMISSING: return "The requested adapter is missing.";
    case ASF_ERROR_NOASFADAPTERS_FOUND: return "No ASF-capable adapters found in the system.";
	case ASF_ERROR_NO_WATCHDOG_MODULE: return "Watchdog module is not loaded.";
	case ASF_ERROR_NO_SMBUS_ACCESS_MODULE: return "SMBus access module is not loaded.";
    case ASF_ERROR_NO_HOST_DRIVER: return "Host interface driver is not loaded.";
	case ASF_ERROR_UNSUPPORTED_OS: return "The configuration software does not support this operating system.";
    case ASF_ERROR_ACCESS_REGISTRY: return "Failed accessing configuration/rules file.";
    case ASF_ERROR_VALUES_REGISTRY: return "Wrong values in configuration/rules file.";
    case ASF_ERROR_NONASF_DRIVER: return "The system requires drivers that support ASF.";
    case ASF_ERROR_INVALID_SMBUSADDR: return "SMBUS ARP Address of ASF Capable adapters may be invalid.";
	case ASF_ERROR_SMBIOS_GLOBAL_DISABLE: return "ASF disabled due to BIOS configuration setting.";
	case ASF_ERROR_BIOS_CAP_SEC_CONFLICT: return "Conflict in ACPI BIOS capabilities: a function is supported both as secure and as non-secure";
	case ASF_ERROR_NO_ACPI_BIOS: return "ACPI Bios is not present in the system.";
    case ASF_ERROR_INITIALIZE_FAILED: return "Initialization failed.";
    case ASF_ERROR_NOTINITIALIZED: return "The agent is not initialized.";
    case ASF_ERROR_NOTIMPLEMENTED: return "The requested feature is not implemented.";
	case ASF_ERROR_END_OF_FCTLIST: return "No more functions available.";
	case ASF_ERROR_FCTID_NOT_VALID: return "The given function-id is invalid.";
    case ASF_ERROR_INVALIDPARAM: return "One of the given parameters is invalid.";
	case ASF_ERROR_INVALID_TWO_PARAMS: return "The two given parameters are invalid.";
    case ASF_ERROR_NOSUCH_ADAPTER_FOUND: return "The requested adapter was not found.";
	case ASF_ERROR_VERSION_MISMATCH: return "The ASF library is incompatible with the daemon. Please reinstall asfd.";
	case ASF_ERROR_NO_KEYS_SET: return "ASF 2.0 security keys are not set in the system.";
	case ASF_ERROR_ADAPTER_DOES_NOT_SUPPORT_ASF2_SEC: return "Selected adapter does not support ASF 2.0 Security.";
	case ASF_ERROR_NO_ADAPTERS_SUPPORTING_ASF2_SEC: return "No ASF 2.0 Security Capable adapters found in the system.";
	case ASF_ERROR_BIOS_DOES_NOT_SUPPORT_ASF2_SEC: return "ACPI BIOS does not support ASF 2.0 Security.";
	case ASF_ERROR_INVALIDUNIT: return "Invalid value - check the parameter's unit.";
    case ASF_ERROR_FATAL_UNKNOWN:
    case ASF_ERROR_EXCEPTION: 
	case E_FAIL:
    default:
        return "The operation has failed.";
    }
}

