/*******************************************************************************

Copyright (c) 2001-2006, Intel Corporation 
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright 
    notice, this list of conditions and the following disclaimer in the 
    documentation and/or other materials provided with the distribution.

 3. Neither the name of the Intel Corporation nor the names of its 
    contributors may be used to endorse or promote products derived from 
    this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef __ASF_CONFIG_DEFINES_H
#define __ASF_CONFIG_DEFINES_H

									
//This struct is used for adapter enumeration, in the API function
//EnumerateASFAdapters()									
///////////////////////////////////////////////////////////////////////////////////////
typedef struct tagASF_ADAPTER_INFO 
{
	char* 	      adapter_key;	 	//adapter handle 
	int	          smbus_addr;		//adapter's smbus address
	char*         description;		//description string
	unsigned char asf_enable;		//is ASF enabled on this adapter (not disabled and not in safe mode)
	char*         mac_addr;			//adapter's MAC address
	int	          adapter_type;		//currently unused
	int  	      hw_asic_version;	//currently unused
} ASFAGT_ADAPTER_INFO;

//This struct is used for adapter enumeration, in the API function
//EnumerateASFAdaptersEx()									
///////////////////////////////////////////////////////////////////////////////////////
typedef struct tagASF_ADAPTER_INFO_EX 
{
	char* 	      adapter_key;	 	//adapter handle 
	int	          smbus_addr;		//adapter's smbus address
	char*         description;		//description string
	unsigned char asf_enable_by_user;		//did user choose to enable ASF on this adapter
	unsigned char asf_active;		//is ASF enabled on this adapter (not disabled and not in safe mode)
	char*         mac_addr;			//adapter's MAC address
	int	          adapter_type;		//currently unused
	int  	      hw_asic_version;	//currently unused
} ASFAGT_ADAPTER_INFO_EX;


// Safe mode reasons and return values enum (see details below)
///////////////////////////////////////////////////////////////////////////////////////
enum AsfError {	
	//the following values have two uses:
	//1) as "safe-mode" reasons in the API function AsfGetConfigurationStatus()
	//   they are arranged by priority: a higher enum value indicates a more severe status
	//2) as return values in all API functions
	S_OK = 0,
	ASF_ERROR_PROXY_NOT_REACHABLE,			   	//Management console cannot be reached
	ASF_ERROR_NO_KEYS_SET,						//ASF 2.0 security keys are not set in the system
	ASF_ERROR_ADAPTER_DOES_NOT_SUPPORT_ASF2_SEC,//Selected adapter does not support ASF 2.0 Security
	ASF_ERROR_NO_ADAPTERS_SUPPORTING_ASF2_SEC,	//No ASF 2.0 Security Capable adapters found in the system
	ASF_ERROR_BIOS_DOES_NOT_SUPPORT_ASF2_SEC,	//ACPI BIOS does not support ASF 2.0 Security
	ASF_ERROR_ADAPTERMISSING,  					//The requested adapter is missing
	ASF_ERROR_NOASFADAPTERS_FOUND,				//No ASF-capable adapters found in the system
	ASF_ERROR_NO_WATCHDOG_MODULE,				//Watchdog module is not loaded
	ASF_ERROR_NO_SMBUS_ACCESS_MODULE,			//SMBus access module is not loaded
	ASF_ERROR_NO_HOST_DRIVER,					//Host Driver is not loaded
	ASF_ERROR_UNSUPPORTED_OS,					//The configuration software does not support this operating system
	ASF_ERROR_ACCESS_REGISTRY,					//Failed accessing configuration/rules file
	ASF_ERROR_VALUES_REGISTRY,					//Wrong values in configuration/rules file
	ASF_ERROR_NONASF_DRIVER,					//The system requires drivers that support ASF
	ASF_ERROR_INVALID_SMBUSADDR,				//SMBUS ARP Address of ASF Capable adapters may be invalid
	ASF_ERROR_SMBIOS_GLOBAL_DISABLE,			//ASF disabled due to BIOS configuration setting
	ASF_ERROR_BIOS_CAP_SEC_CONFLICT,			//Conflict in ACPI BIOS capabilities
	ASF_ERROR_NO_ACPI_BIOS,						//ACPI BIOS is not present in the system
	ASF_ERROR_FATAL_UNKNOWN,					//Unknown fatal error

	//the following values are used as return values only
	ASF_ERROR_INITIALIZE_FAILED,				//Initialization failed
	ASF_ERROR_NOTINITIALIZED,					//The agent is not initialized
	ASF_ERROR_NOTIMPLEMENTED,					//The requested feature is not implemented
	ASF_ERROR_END_OF_FCTLIST,					//No more functions available
	ASF_ERROR_FCTID_NOT_VALID,					//The given function-id is invalid
	ASF_ERROR_INVALIDPARAM,						//One of the given parameters is invalid
	ASF_ERROR_INVALID_TWO_PARAMS,				//The two given parameters are invalid
	ASF_ERROR_NOSUCH_ADAPTER_FOUND,				//The requested adapter was not found
	ASF_ERROR_VERSION_MISMATCH,					//The ASF library is incompatible with the daemon
	ASF_ERROR_EXCEPTION,						//Indicates an exception
	E_FAIL,										//Indicates failure
	ASF_ERROR_INVALIDUNIT						//Unit of the given parameters is invalid
};


//Flags used in the API function AsfGetConfigurationStatus(), for providing information
//about the current configuration:
///////////////////////////////////////////////////////////////////////////////////////
//ASF agent is in the process of auto-searching for an adapter:
#define ASF_STATUS_ADAPTER_SEARCH		0x00000001	

#endif
