#! /bin/sh
#
# asfd       Bring up/down the ASF agent
#
### BEGIN INIT INFO
# Provides: ASFD
# Required-Start: $syslog $network
# Required-Stop:  $syslog $network
# Default-Start:  2 3 5
# Default-Stop:   0 1 6
# Description:    Activates/Deactivates the ASF agent daemon
#
### END INIT INFO

# Source SuSE config (if still necessary, most info has been moved)
test -r /etc/rc.config && . /etc/rc.config

# Check for missing binaries (stale symlinks should not happen)
ASFD_BIN=/usr/sbin/asfd
test -x $ASFD_BIN || exit 5

# Check for existence of needed config file and read it
ASFD_CONFIG=/etc/asfd/asfrules.ini
test -r $ASFD_CONFIG || exit 6

# Shell functions sourced from /etc/rc.status:
. /etc/rc.status

# First reset status of this service
rc_reset
 
  
case "$1" in
    start)
	## Start daemon with startproc(8). If this fails
	## the echo return value is set appropriate.

	# NOTE: startproc returns 0, even if service is 
	# already running to match LSB spec.
	
	I2C_NEEDED="no"	
	modprobe i2c-i8254x >& /dev/null  #gigabit bit bang module
	if [ $? == 0 ]; then
	    I2C_NEEDED="yes"
	fi	
	modprobe i2c-i82551 >& /dev/null  #FE bit bang module
	if [ $? == 0 ]; then
	    I2C_NEEDED="yes"
	fi
	
	if [ "$I2C_NEEDED" == "yes" ]; then  
	    echo -n "Loading the I2C modules" 
	    /sbin/modprobe i2c-dev
	    rc_status -v
	    rc_reset
	    echo -n "Loading the ASF watchdog module"
	    /sbin/modprobe asfwdg
	    rc_status -v
	    rc_reset
	fi
	echo -n "Loading the host-i/f driver"
	/sbin/modprobe mng_host_if >& /dev/null
	rc_status -v
	rc_reset	
	echo -n "Starting ASFD"
	startproc $ASFD_BIN
	touch /var/lock/subsys/asfd
	rc_status -v
	;;
    stop)
	rm -f /var/lock/subsys/asfd
	echo -n "Shutting down ASFD"
	## Stop daemon with killproc(8) and if this fails
	## set echo the echo return value.
	killproc -TERM $ASFD_BIN
	while [ -n "`pidof asfd`" ] ; do usleep 50000; done;
	# Remember status and be verbose
	rc_status -v
	;;
    restart|reload)
	## Stop the service and regardless of whether it was
	## running or not, start it again.
	$0 stop
	$0 start
	# Remember status and be quiet
	rc_status
	;;
	status)
	echo -n "ASFD Daemon status: "
	checkproc $ASFD_BIN
	rc_status -v
	;;
	version)
        echo -n "Package asf-apps "
        rpm -q --queryformat Version:\ %{VERSION}\ Build:\ %{RELEASE}\\n asf-apps
        echo -n "Package asf-modules "
        rpm -q --queryformat Version:\ %{VERSION}\ Build:\ %{RELEASE}\\n asf-modules

        /usr/sbin/asfd --v
	if [ -e /usr/sbin/asfcli ]; then
		/usr/sbin/asfcli version
	fi
	if [ -e /usr/sbin/alertapp ]; then
		/usr/sbin/alertapp --version
	fi
	modinfo -d i2c-i8254x
	modinfo -d i2c-i82551
        modinfo -d asfwdg
	modinfo -d mng_host_if
	;;
	*)
        echo $"Usage: $0 {start|stop|restart|reload|status|version}"
        exit 1
    ;;
esac
rc_exit