/*******************************************************************************

  Copyright (c) 2001-2009, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef PORTS_H
#define PORTS_H

#include "dcb_osdep.h"
#include "mibdata.h"

#ifndef ETH_ALEN
#define ETH_ALEN    6
#endif
#ifndef IFNAMSIZ
#define IFNAMSIZ    16  /* must match MAX_DEVICE_NAME_LEN */
#endif
#ifndef ETH_P_ALL
#define ETH_P_ALL   0x0003
#endif

#ifndef BIT
#define BIT(x) (1 << (x))
#endif

#define MAX_INTERFACES          16

#define DEFAULT_TX_HOLD         4
#define DEFAULT_TX_INTERVAL     30
#define FASTSTART_TX_INTERVAL   1
#define FASTSTART_TX_COUNT      5
#define DEFAULT_TX_DELAY        1
#define FASTSTART_TX_DELAY      1
#define REINIT_DELAY            2

#define DORMANT_DELAY	15

struct porttimers {
	u16 dormantDelay;
/* Tx */
	u16 reinitDelay;
	u16 msgTxHold;
	u16 msgTxInterval;
	u16 txDelay;
	u16 txTTR;
	u16 txShutdownWhile;
	u16 txDelayWhile;
/* Rx */
	u16 tooManyNghbrsTimer;
	u16 rxTTL;
	u16 lastrxTTL;  /* cache last received */
};

struct porttx {
	u8 *frameout;
	u32 sizeout;
	u8 state;
	u8 localChange;
	u16 txTTL;
};

struct portstats {
/* Tx */
	u32 statsFramesOutTotal;
/* Rx */
	u32 statsAgeoutsTotal;
	u32 statsFramesDiscardedTotal;
	u32 statsFramesInErrorsTotal;
	u32 statsFramesInTotal;
	u32 statsTLVsDiscardedTotal;
	u32 statsTLVsUnrecognizedTotal;
};

typedef struct rxmanifest{
	struct unpacked_tlv *chassis;
	struct unpacked_tlv *portid;
	struct unpacked_tlv *ttl;
	struct unpacked_tlv *portdesc;
	struct unpacked_tlv *sysname;
	struct unpacked_tlv *sysdesc;
	struct unpacked_tlv *syscap;
	struct unpacked_tlv *mgmtadd;
}rxmanifest;

struct portrx {
	u8 *framein;
	u16 sizein;
	u8 state;
	u8 badFrame;
	u8 rcvFrame;
	u8 rxInfoAge;
	u8 remoteChange;
	u8 tooManyNghbrs;
	u8 dupTlvs;
	u8 dcbx_st;
	rxmanifest *manifest;
};

struct eth_hdr {
	char dst[6];
	char src[6];
	u16 ethertype;
};

enum portAdminStatus {
	disabled,
	enabledTxOnly,
	enabledRxOnly,
	enabledRxTx,
};

struct porttlvs{
	struct unpacked_tlv *cur_peer; /* Should be in manifest */
	struct unpacked_tlv *last_peer;
};

struct port {
	char *ifname;
	u8 hw_resetting;
	u8 portEnabled;
	u8 prevPortEnabled;
	u8 adminStatus;
	u8 rxChanges;
	u16   lldpdu;
	struct l2_packet_data *l2;
	struct portrx rx;
	struct porttx tx;
	struct porttlvs tlvs;
	struct portstats stats;
	struct porttimers timers;
	struct msap msap;
	struct port *next;
};

extern struct port *porthead;
extern struct port *portcurrent;
extern struct port *porttail;

#ifdef __cplusplus
extern "C" {
#endif
int add_port(const char *);
int remove_port(const char *);
#ifdef __cplusplus
}
#endif
int set_port_hw_resetting(const char *ifname, int resetting);
int get_port_hw_resetting(const char *ifname);
void set_lldp_port_enable_state(const char *ifname, int enable);
void set_lldp_port_admin(const char *ifname, int enable);

int get_lldp_port_statistics(char *ifname, struct portstats *stats);

int get_local_tlvs(char *ifname, unsigned char *tlvs, int *size);
int get_neighbor_tlvs(char *ifname, unsigned char *tlvs, int *size);

int port_needs_shutdown(struct port *port);

static inline struct port *port_find_by_name(const char *ifname)
{
	struct port *port = porthead;

	while (port) {
		if (!strncmp(ifname, port->ifname, IFNAMSIZ))
			return port;
		port = port->next;
	}
	return NULL;
}
#endif /* PORTS_H */
