/*******************************************************************************

  Copyright (c) 2001-2009, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _TLV_DCBX_H_
#define _TLV_DCBX_H_

#include "lldp_dcbx.h"
#include "dcb_types.h"
#include "lldp.h"

/* Received TLV types */
#define RCVD_LLDP_DCBX1_TLV         0x0200
#define RCVD_LLDP_DCBX2_TLV         0x0400

#define RCVD_DCBX1_TLV_CTRL         0x0001
#define RCVD_DCBX2_TLV_CTRL         0x0002
#define RCVD_DCBX_TLV_PG            0x0004
#define RCVD_DCBX_TLV_PFC           0x0008
#define RCVD_DCBX_TLV_APP           0x0020
#define RCVD_DCBX_TLV_LLINK         0x0040

/* DCB TLV Definitions */
#define DCB_CONTROL_TLV                1
#define DCB_PRIORITY_GROUPS_TLV        2
#define DCB_PRIORITY_FLOW_CONTROL_TLV  3
#define DCB_BCN_TLV                    4
#define DCB_APPLICATION_TLV            5
#define DCB_LLINK_TLV                  6

#define DCB_CONTROL_TLV2               1
#define DCB_PRIORITY_GROUPS_TLV2       2
#define DCB_PRIORITY_FLOW_CONTROL_TLV2 3
#define DCB_APPLICATION_TLV2           4

/* DCBX CTRL TLV byte offsets */
#define DCBX_CTRL_OPER_VER_OFFSET   0
#define DCBX_CTRL_MAX_VER_OFFSET    (DCBX_CTRL_OPER_VER_OFFSET + sizeof(u8))
#define DCBX_CTRL_SEQNO_OFFSET      (DCBX_CTRL_MAX_VER_OFFSET + sizeof(u8))
#define DCBX_CTRL_ACKNO_OFFSET      (DCBX_CTRL_SEQNO_OFFSET + sizeof(u32))
#define DCBX_CTRL_LEN               sizeof(struct dcb_control_info)

struct dcbx_tlv_header {
	u8 oper_version;
	u8 max_version;
	u8 ewe;
	u8 sub_type;
};

/* DCBX TLV HEADER byte offsets */
#define DCBX_HDR_OPER_VERSION_OFFSET    0
#define DCBX_HDR_MAX_VERSION_OFFSET     1
#define DCBX_HDR_EWE_OFFSET             2
#define DCBX_HDR_SUB_TYPE_OFFSET        3

#define DCB_PGID_BYTES                  MAX_BANDWIDTH_GROUPS/2

#pragma pack(1) /*packon*/
struct dcbx1_pg_cfg {
	u8 pg_percent[MAX_BANDWIDTH_GROUPS];/* % of link BW per BWG */
	struct {
		u8  byte1;
			/* :3 BWG ID */
			/* :2 strict_prio 2 (1: LSP, 2: GSP, 3: reserved */
			/* :3 padding */
		u8  byte2;                /* percentage of BWG bandwidth */
	} up_cfg[MAX_USER_PRIORITIES];/* Index is user priority */
};
struct dcbx2_pg_cfg {
	u8 pg_ids[DCB_PGID_BYTES];
	/* byte 0 :4 PG ID for UP 0 */
	/*        :4 PG ID for UP 1 */ 
	/* byte 1 :4 PG ID for UP 2 */
	/*        :4 PG ID for UP 3 */ 
	/* byte 2 :4 PG ID for UP 4 */
	/*        :4 PG ID for UP 5 */ 
	/* byte 3 :4 PG ID for UP 6 */
	/*        :4 PG ID for UP 7 */ 
	u8 pg_percent[MAX_BANDWIDTH_GROUPS];/* % of link BW per PGID */
	u8 num_tcs; 
};
#pragma pack() /*packoff*/
/* DCBX PG TLV byte offsets */
#define DCBX1_PG_PERCENT_OFFSET     sizeof(struct dcbx_tlv_header)
#define DCBX1_PG_SETTINGS_OFFSET    (DCBX1_PG_PERCENT_OFFSET + \
				 sizeof(u8)*MAX_BANDWIDTH_GROUPS)
#define BYTE1_OFFSET                 0
#define BYTE2_OFFSET                 1

#define DCBX2_PG_PGID_UP            sizeof(struct dcbx_tlv_header)
#define DCBX2_PG_PERCENT_OFFSET     (DCBX2_PG_PGID_UP + \
					sizeof(u8)*DCB_PGID_BYTES)
#define DCBX2_PG_NUM_TC_OFFSET      (DCBX2_PG_PERCENT_OFFSET + \
					sizeof(u8)*MAX_BANDWIDTH_GROUPS)

#pragma pack(1) /*packon*/
struct dcbx1_pfc_cfg {
	u8 admin_map; /* bitmap of admin mode, bit position is user priority */
};
struct dcbx2_pfc_cfg {
	u8 admin_map; /* bitmap of admin mode, bit position is user priority */
	u8 num_tcs; 
};
#pragma pack() /*packoff*/

/* DCBX PFC TLV byte offsets */
#define DCBX_PFC_MAP_OFFSET            sizeof(struct dcbx_tlv_header)
#define DCBX2_PFC__NUM_TC_OFFSET      (DCBX_PFC_MAP_OFFSET + sizeof(u8))

#pragma pack(1) /*packon*/
struct dcbx2_app_cfg {
	u16 prot_id;
	u8  byte1;
		/* :6 high 7 bits of OUI */
		/* :2 selector field */
	u16 low_oui; /* low 16 bits of OUI */
	u8  up_map;
};
#pragma pack() /*packoff*/
/* DCBX APP TLV byte offsets */
#define DCBX1_APP_DATA_OFFSET          sizeof(struct dcbx_tlv_header)
#define DCBX2_APP_DATA_OFFSET          sizeof(struct dcbx_tlv_header)
/* To support looping, these do *not* include the header */
#define DCBX2_APP_PROTO_OFFSET         0
#define DCBX2_APP_BYTE1_OFFSET         (DCBX2_APP_PROTO_OFFSET + sizeof(u16))
#define DCBX2_APP_LOW_OUI_OFFSET1      (DCBX2_APP_BYTE1_OFFSET + sizeof(u8))
#define DCBX2_APP_LOW_OUI_OFFSET2      (DCBX2_APP_LOW_OUI_OFFSET1 + sizeof(u8))
#define DCBX2_APP_UP_MAP_OFFSET        (DCBX2_APP_LOW_OUI_OFFSET2 + sizeof(u8))

#pragma pack(1) /*packon*/
struct dcbx1_pg_info {
	struct dcbx_tlv_header hdr;
	struct dcbx1_pg_cfg data;
};
struct dcbx2_pg_info {
	struct dcbx_tlv_header hdr;
	struct dcbx2_pg_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX1_PG_LEN                    sizeof(struct dcbx1_pg_info)
#define DCBX2_PG_LEN                    sizeof(struct dcbx2_pg_info)

#pragma pack(1) /*packon*/
struct dcbx1_pfc_info {
	struct dcbx_tlv_header hdr;
	struct dcbx1_pfc_cfg data;
};
struct dcbx2_pfc_info {
	struct dcbx_tlv_header hdr;
	struct dcbx2_pfc_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX1_PFC_LEN                  sizeof(struct dcbx1_pfc_info)
#define DCBX2_PFC_LEN                  sizeof(struct dcbx2_pfc_info)

#pragma pack(1) /*packon*/
struct dcbx1_app_info {
	struct dcbx_tlv_header hdr;
	u8 data[];
};
struct dcbx2_app_info {
	struct dcbx_tlv_header hdr;
	struct dcbx2_app_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX1_APP_LEN                  DCBX1_APP_DATA_OFFSET
#define DCBX2_APP_LEN                  sizeof(struct dcbx2_app_info)
#define DCBX2_APP_SIZE                 sizeof(struct dcbx2_app_cfg)

#ifdef _DCB_LLINK_SUPPORT
#pragma pack(1) /*packon*/
struct dcbx_llink_cfg {
	u8 byte1; /* :1 - logical link status */
};            /* :7 - reserved */
#pragma pack() /*packoff*/

/* DCB_TLV TYPE 6 byte offset */
#define DCBX_LLINK_STATUS_OFFSET       sizeof(struct dcbx_tlv_header)

#pragma pack(1) /*packon*/
struct dcbx_llink_info {
	struct dcbx_tlv_header hdr;
	struct dcbx_llink_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX_LLINK_LEN                 sizeof(struct dcbx_llink_info)
#endif /*_DCB_LLINK_SUPPORT */

/* Organizationally Unique Identifier */
#define DCB_OUI_LEN     3
#define OUI_SUBTYPE_LEN 1

struct dcb_tlv {
	u8 oui[DCB_OUI_LEN];
	u8 oui_subtype;
};

#pragma pack(1) /*packon*/
struct dcb_control_info {
	u8  oper_version;
	u8  max_version;
	u32 seqno;
	u32 ackno;
};
#pragma pack() /*packoff*/

#ifdef __cplusplus
extern "C" {
#endif
void        process_dcbx_tlv(struct port *,struct unpacked_tlv *);

struct unpacked_tlv *bld_dcbx1_tlv(struct dcbx_tlvs *dcbx);
struct unpacked_tlv *bld_dcbx2_tlv(struct dcbx_tlvs *dcbx);
struct unpacked_tlv *bld_dcbx_ctrl_tlv(struct dcbx_tlvs *dcbx);
struct unpacked_tlv *bld_dcbx1_pg_tlv(struct dcbx_tlvs *, bool *success);
struct unpacked_tlv *bld_dcbx2_pg_tlv(struct dcbx_tlvs *, bool *success);
struct unpacked_tlv *bld_dcbx1_pfc_tlv(struct dcbx_tlvs *, bool *success);
struct unpacked_tlv *bld_dcbx2_pfc_tlv(struct dcbx_tlvs *, bool *success);
struct unpacked_tlv *bld_dcbx1_app_tlv(struct dcbx_tlvs *dcbx, u32 sub_type,
					bool *success);
struct unpacked_tlv *bld_dcbx2_app_tlv(struct dcbx_tlvs *, u32 sub_type,
					bool *success);
#ifdef _DCB_LLINK_SUPPORT
struct unpacked_tlv *bld_dcbx_llink_tlv(struct dcbx_tlvs *, u32 sub_type,
					bool *success);
#endif /*_DCB_LLINK_SUPPORT */

bool   unpack_dcbx1_tlvs(struct port *, struct unpacked_tlv *);
bool   unpack_dcbx2_tlvs(struct port *, struct unpacked_tlv *);
bool   process_dcbx_ctrl_tlv(struct port *);
bool   process_dcbx_pg_tlv(struct port *);
bool   process_dcbx_pfc_tlv(struct port *);
bool   process_dcbx_app_tlv(struct port *);
#ifdef _DCB_LLINK_SUPPORT
bool   process_dcbx_llink_tlv(struct port *);
#endif //_DCB_LLINK_SUPPORT

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
