/*******************************************************************************

  Copyright (c) 2001-2009, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _LLDP_UTIL_H
#define _LLDP_UTIL_H

#include "lldp/ports.h"

#ifndef ETHTOOL_GLINK
#define ETHTOOL_GLINK  0x0000000a    /* Get link status (ethtool_value) */
#endif

int is_active(const char *ifname);
int is_bond(const char *ifname);
int is_san_mac(u8 *addr);
int is_bridge(const char *ifname);
int is_vlan(const char *ifname);
int is_vlan_capable(const char *ifname);
int is_wlan(const char *ifname);
int is_valid_mac(const u8 *mac);
int is_san_mac(u8 *addr);
int is_ether(const char *ifname);
int is_loopback(const char *ifname);
int is_p2p(const char *ifname);
int is_noarp(const char *ifname);
int is_mbond(const char *ifname);
int is_sbond(const char *ifname);
int is_autoneg_enabled(const char *ifname);
int is_autoneg_supported(const char *ifname);
int get_mtu(const char *);
int get_mfs(const char *);
int get_ifflags(const char *);
int get_maucaps(const char *);
int get_mautype(const char *);
int get_ifpflags(const char *);
int get_iftype(const char *);
int get_src_mac_from_bond(struct port *bond_port, char *ifname, u8 *addr);
int get_mac(const char *ifname, u8 mac[]);
int get_macstr(const char *ifname, char *addr, size_t size);
int get_saddr(const char *ifname, struct sockaddr_in *saddr);
int get_ipaddr(const char *ifname, struct in_addr *);
int get_ipaddrstr(const char *ifname, char *ipaddr, size_t size);
int get_saddr6(const char *ifname, struct sockaddr_in6 *saddr);
int get_ipaddr6(const char *ifname, struct in6_addr *);
int get_ipaddr6str(const char *ifname, char *ipaddr, size_t size);
u16 get_caps(const char *ifname);
int mac2str(const u8 *mac, char *dst, size_t size);
int str2mac(const char *src, u8 *mac, size_t size);
int str2addr(int domain, const char *src, void *dst, size_t size);
int addr2str(int domain, const void *src, char *dst, size_t size);
int is_slave(const char *ifmaster, const char *ifslave);
int get_ifidx(const char *ifname);
int get_master(const char *ifname);
int get_addr(const char *ifname, int domain, void *buf);
int check_link_status(const char *ifname);

#define ntohll(x) be64_to_cpu(x)
#define htonll(x) cpu_to_be64(x)

#define ntoh24(p) (((p)[0] << 16) | ((p)[1] << 8) | ((p)[2]))

#define hton24(p, v)	do {			\
		p[0] = (((v) >> 16) & 0xFF);	\
		p[1] = (((v) >> 8) & 0xFF);	\
		p[2] = ((v) & 0xFF);		\
	} while (0)


#endif /* _LLDP_UTIL_H */
