/*******************************************************************************

  Copyright (c) 2001-2009, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _LLDP_MED_H
#define _LLDP_MED_H

#include "lldp.h"
#include "lldp_mod.h"

#define LLDP_MOD_MED	OUI_TIA_TR41

struct med_data {
	char ifname[IFNAMSIZ];
	struct unpacked_tlv *medcaps;
	struct unpacked_tlv *netpoli;
	struct unpacked_tlv *locid;
	struct unpacked_tlv *extpvm;
	struct unpacked_tlv *inv_hwrev;
	struct unpacked_tlv *inv_fwrev;
	struct unpacked_tlv *inv_swrev;
	struct unpacked_tlv *inv_serial;
	struct unpacked_tlv *inv_manufacturer;
	struct unpacked_tlv *inv_modelname;
	struct unpacked_tlv *inv_assetid;
	LIST_ENTRY(med_data) entry;
};

struct med_user_data {
	LIST_HEAD(med_head, med_data) head;
};

struct lldp_module *med_register(void);
void med_unregister(struct lldp_module *mod);
struct packed_tlv *med_gettlv(struct port *port);
void med_ifdown(char *);
void med_ifup(char *);

#endif /* _LLDP_MED_H */
