/*******************************************************************************

  Copyright (c) 2001-2009, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _LLDP_DCBX_H
#define _LLDP_DCBX_H

#include <sys/un.h>
#include "lldpad.h"
#include "dcb_osdep.h"

#define LLDP_MOD_DCBX 0x001b2101

struct dcbx_manifest {
	struct unpacked_tlv *dcbx1;
	struct unpacked_tlv *dcbx2;
	struct unpacked_tlv *dcbx_ctrl;
	struct unpacked_tlv *dcbx_pg;
	struct unpacked_tlv *dcbx_pfc;
	struct unpacked_tlv *dcbx_app;
	struct unpacked_tlv *dcbx_llink;
};

struct dcbx_tlvs {
	u16  dcbdu;
	u8   dcbx_st;
	char ifname[IFNAMSIZ];
	struct dcbx_manifest *manifest;
	struct unpacked_tlv *dcbx1;
	struct unpacked_tlv *dcbx2;
	struct unpacked_tlv *control;
	struct unpacked_tlv *pg1;
	struct unpacked_tlv *pg2;
	struct unpacked_tlv *pfc1;
	struct unpacked_tlv *pfc2;
	struct unpacked_tlv *app1;
	struct unpacked_tlv *app2;
	struct unpacked_tlv *llink;
	struct port *port;
	LIST_ENTRY(dcbx_tlvs) entry;
};

struct dcbd_user_data {
	LIST_HEAD(dcbx_head, dcbx_tlvs) head;
};

#ifdef __cplusplus
extern "C" {
#endif
struct dcbx_tlvs *dcbx_data(const char *);
#ifdef __cplusplus
}
#endif

struct packed_tlv *dcbx_gettlv(struct port *port);
int dcbx_rchange(struct port *port,  struct unpacked_tlv *tlv);
u8 dcbx_mibDeleteObjects(struct port *port);
void dcbx_ifup(char *device_name);
void dcbx_ifdown(char *device_name);
struct lldp_module *dcbx_register(void);
void dcbx_unregister(struct lldp_module *);
int dcbx_clif_cmd(void *, struct sockaddr_un *,
		  socklen_t , char *, int, char *);

#endif /* _LLDP_DCBX_H */
