/*******************************************************************************

  Copyright (c) 2001-2009, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _DCB_RULE_CHK_H
#define _DCB_RULE_CHK_H

#include "dcb_types.h"

#define MAX_USER_PRIORITY       MAX_USER_PRIORITIES
#define MAX_TRAFFIC_CLASS       MAX_TRAFFIC_CLASSES
#define MAX_BW_GROUP            MAX_BANDWIDTH_GROUPS
#define BW_PERCENT              100

/* DCB error Codes */
#define DCB_SUCCESS                  0
#define DCB_ERR_CONFIG              -1
#define DCB_ERR_PARAM               -2

/* Trasmit  and receive Errors */
/* Error in bandwidth group allocation */
#define DCB_TX_ERR_BW_GROUP         -4
#define DCB_RX_ERR_BW_GROUP         -5
/* Error in traffic class bandwidth allocation */
#define DCB_TX_ERR_TC_BW            -6
#define DCB_RX_ERR_TC_BW            -7
/* Traffic class has both link strict and group strict enabled */
#define DCB_TX_ERR_LS_GS            -8
#define DCB_RX_ERR_LS_GS            -9
/* Link strict traffic class has non zero bandwidth */
#define DCB_TX_ERR_LS_BW_NONZERO    -0xA
#define DCB_RX_ERR_LS_BW_NONZERO    -0xB
/* Link strict bandwidth group has non zero bandwidth */
#define DCB_TX_ERR_LS_BWG_NONZERO    -0xC
#define DCB_RX_ERR_LS_BWG_NONZERO    -0xD
/*  Traffic calss has zero bandwidth */
#define DCB_TX_ERR_TC_BW_ZERO       -0xE
#define DCB_RX_ERR_TC_BW_ZERO       -0xF

#define DCB_NOT_IMPLEMENTED          0x7FFFFFFF


#endif /* _DCB_RULE_CHK_H */

