/*******************************************************************************

  Copyright (c) 2001-2009, Intel Corporation
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   3. Neither the name of the Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

#ifndef _DCB_DRIVER_INTERFACE_H_
#define _DCB_DRIVER_INTERFACE_H_
#include "dcb_driver_if_types.h"

#ifdef __linux
#ifdef __cplusplus
extern "C" {
#endif
#endif

int set_hw_pg(char *device_name, pgroup_attribs *pg_data, bool Opermode);
int set_hw_pfc(char *device_name, dcb_pfc_list_type pfc_data, bool Opermode);
#ifdef DCB_APP_DRV_IF_SUPPORTED
int set_hw_app(char *device_name, appgroup_attribs *app_data);
#endif /* DCB_APP_DRV_IF_SUPPORTED */
int set_hw_all(char *device_name);

int get_dcb_capabilities(char *device_name, struct feature_support *dcb_capabilites);
u32 double_to_fixpt_int(double double_val);

int get_dcb_numtcs(char *device_name, u8 *pgtcs, u8 *pfctcs);

#ifdef __linux
#ifdef  __cplusplus
}
#endif
#endif

#endif /* _DCB_DRIVER_INTERFACE_H_ */

