/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class ShaderH3DFixer {
    public static final int NOT_A_FILE = 0;
    public static final int VS_2 = 1;
    public static final int PS_2 = 2;
    public static final int VS_3 = 3;
    public static final int PS_3 = 4;
    public static final int ALREADY_FIXED = 5;
    private File shaderFile;
    private File tempFile;
    private StringBuffer shaderCode;
    private PrintWriter pw;
    private int cPos;

    public int readFile(String file) {
        block10: {
            this.shaderFile = new File(file);
            if (this.shaderFile.isFile()) break block10;
            return 0;
        }
        try {
            this.tempFile = new File(String.valueOf(this.shaderFile.getAbsolutePath()) + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(file));
            this.pw = new PrintWriter(new FileWriter(this.tempFile));
            this.shaderCode = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                this.shaderCode.append(String.valueOf(line) + "\n");
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.shaderCode.indexOf("texldl r11") != -1) {
            this.pw.close();
            this.tempFile.delete();
            return 5;
        }
        if (this.shaderCode.indexOf("vs_2") != -1) {
            return 1;
        }
        if (this.shaderCode.indexOf("ps_2") != -1) {
            return 2;
        }
        if (this.shaderCode.indexOf("vs_3") != -1) {
            return 3;
        }
        if (this.shaderCode.indexOf("ps_3") != -1) {
            return 4;
        }
        return 0;
    }

    private void saveFile() {
        this.pw.println(this.shaderCode.toString());
        this.pw.close();
        if (!this.shaderFile.delete()) {
            System.out.println("Could not delete file");
            return;
        }
        if (!this.tempFile.renameTo(this.shaderFile)) {
            System.out.println("Could not rename file");
        }
    }

    public void toVs3() {
    }

    public void toPs3() {
    }

    public void fixVS() {
        this.cPos = this.shaderCode.indexOf("screenTransform");
        if (this.cPos != -1) {
            this.fixVSScreenTransform();
        } else {
            this.cPos = this.shaderCode.indexOf("hud");
            if (this.cPos != -1) {
                this.fixVSHud();
            } else {
                this.cPos = this.shaderCode.indexOf("ReflectionViewMatrix");
                if (this.cPos != -1) {
                    this.fixVSReflections();
                } else {
                    this.cPos = this.shaderCode.indexOf("vs_3_0");
                    if (this.cPos != -1) {
                        this.shaderCode.insert(this.cPos + 9, "def c253, 0, 0, 0.0625, 1\n  ");
                    }
                    if ((this.cPos = this.shaderCode.indexOf("dcl_")) != -1) {
                        this.shaderCode.insert(this.cPos - 2, "dcl_2d s0\n  ");
                    }
                    String outPos = "";
                    this.cPos = this.shaderCode.indexOf("dcl_position o");
                    if (this.cPos != -1) {
                        outPos = this.shaderCode.substring(this.cPos).split(" ")[1].split("\n")[0];
                        System.out.println("outPos = " + outPos);
                    }
                    String tempReg = "";
                    String outTex = "";
                    this.cPos = this.shaderCode.indexOf("mov " + outPos + ", r");
                    if (this.cPos != -1 || (this.cPos = this.shaderCode.indexOf("mov " + outPos + ".xyw, r")) != -1) {
                        tempReg = this.shaderCode.substring(this.cPos).split(" ")[2].split("\n")[0];
                        System.out.println("tempReg = " + tempReg);
                        String cmd = "";
                        String cmd2 = "";
                        int regnum = 0;
                        while (regnum <= 10) {
                            cmd = String.format("mov o%d, " + tempReg, regnum);
                            cmd2 = String.format("mov o%d.xyw, " + tempReg, regnum);
                            this.cPos = this.shaderCode.indexOf(cmd);
                            if (!(this.cPos == -1 && (this.cPos = this.shaderCode.indexOf(cmd2)) == -1 || outPos.equals("o" + regnum))) {
                                outTex = this.shaderCode.substring(this.cPos).split(" ")[1];
                                outTex = outTex.substring(0, outTex.length() - 1);
                                System.out.println("outTex = " + outTex);
                            }
                            ++regnum;
                        }
                    }
                    if (!outTex.equals("")) {
                        this.cPos = this.shaderCode.indexOf(String.valueOf(outTex) + ",");
                        if (this.cPos != -1) {
                            this.shaderCode.replace(this.cPos, this.cPos + outTex.length(), "r12");
                        }
                        if ((this.cPos = this.shaderCode.lastIndexOf("\n//")) != -1) {
                            this.shaderCode.insert(this.cPos, " texldl r11, c253.z, s0\n if_ne r12.w, c253.w\n add r11.y, r12.w, -r11.y\n mul r11.x, r11.x, r11.y\n add r12.x, r12.x, r11.x\n endif\n mov " + outTex + ", r12\n");
                        }
                    }
                    this.saveFile();
                }
            }
        }
    }

    public void fixVSReflections() {
        String reflVMVec = null;
        String projw = null;
        String dReg = null;
        this.addDeclarations();
        this.cPos = this.shaderCode.indexOf("Proj ");
        if (this.cPos != -1 && (this.cPos = (projw = this.shaderCode.substring(this.cPos).split("\n")[0]).indexOf("c")) != -1) {
            projw = projw.trim().split("c")[1].split(" ")[0];
            projw = "c" + (Integer.parseInt(projw) + 3);
        }
        if ((this.cPos = this.shaderCode.indexOf("ReflectionViewMatrix0 ")) != -1 && (this.cPos = (reflVMVec = this.shaderCode.substring(this.cPos).split("\n")[0]).indexOf("c")) != -1) {
            reflVMVec = "c" + reflVMVec.trim().split("c")[2].split(" ")[0];
        }
        String line = "";
        int i = 0;
        while (line != null) {
            line = this.shaderCode.toString().split("\n")[i].trim();
            if (line.indexOf(", " + projw) != -1) {
                dReg = line.substring(4, 6);
                break;
            }
            ++i;
        }
        this.cPos = this.shaderCode.indexOf(line);
        if (dReg.charAt(0) != 'o') {
            this.shaderCode.insert(this.cPos + line.length() + 1, "   mov r10.w, " + dReg + ".w\n");
        } else {
            this.shaderCode.replace(this.cPos + 4, this.cPos + 6, "r13");
            this.shaderCode.insert(this.cPos + line.length() + 2, "   mov " + dReg + ", r13\n   mov r10.w, r13.w\n");
        }
        this.cPos = -1;
        int regNum = 0;
        while (this.cPos == -1 && regNum < 11) {
            this.cPos = this.shaderCode.lastIndexOf(String.format(".x, r%d, %s", regNum, reflVMVec));
            ++regNum;
        }
        String tempRegister = this.shaderCode.substring(this.cPos - 2, this.cPos);
        this.cPos = this.shaderCode.indexOf(".xy, " + tempRegister);
        String outRegister = this.shaderCode.substring(this.cPos - 2, this.cPos);
        this.shaderCode.replace(this.cPos - 2, this.cPos, "r12");
        this.cPos = this.shaderCode.lastIndexOf("\n//");
        if (this.cPos != -1) {
            this.shaderCode.insert(this.cPos, " texldl r11, c253.z, s0\n add r11.y, r10.w, -r11.y\n mul r11.x, r11.x, r11.y\n mul r11.x, r11.x, c253.x\n add r12.x, r12.x, r11.x\n mov " + outRegister + ".xy, r12.xy\n");
        }
        this.saveFile();
    }

    public void fixPS() {
        this.cPos = this.shaderCode.indexOf("screenToWorld");
        if (this.cPos != -1) {
            this.fixPSScreenToWorld();
        }
        if ((this.cPos = this.shaderCode.indexOf("ScreenToShadowMatrix")) != -1) {
            this.fixPSScreenToShadowMatrix();
        }
    }

    private void fixPSScreenToWorld() {
        String vector = "";
        this.cPos = this.shaderCode.indexOf("screenToWorld ");
        if (this.cPos != -1 && (this.cPos = (vector = this.shaderCode.substring(this.cPos).split("\n")[0]).indexOf("c")) != -1) {
            vector = "c" + vector.trim().split("c")[2].split(" ")[0];
        }
        if ((this.cPos = this.shaderCode.indexOf("dcl_")) != -1) {
            this.shaderCode.insert(this.cPos - 2, "dcl_texcoord8 v9.x\n  ");
        }
        String toFix = "";
        int regNum = 0;
        while (regNum < 9) {
            toFix = String.format("v%d.x, " + vector, regNum);
            this.cPos = this.shaderCode.indexOf(toFix);
            if (this.cPos != -1) {
                this.shaderCode.replace(this.cPos, this.cPos + toFix.length(), "v9.x, " + vector);
                break;
            }
            ++regNum;
        }
        this.saveFile();
    }

    private void fixPSScreenToShadowMatrix() {
        String vector = "";
        String sampler = "";
        String dReg = "";
        String tempRegister = "";
        this.cPos = this.shaderCode.indexOf("ScreenToShadowMatrix ");
        if (this.cPos != -1 && (this.cPos = (vector = this.shaderCode.substring(this.cPos).split("\n")[0]).indexOf("c")) != -1) {
            vector = "c" + vector.trim().split("c")[2].split(" ")[0];
        }
        System.out.println("vector = " + vector);
        this.cPos = this.shaderCode.indexOf("dcl_");
        if (this.cPos != -1) {
            this.shaderCode.insert(this.cPos - 2, "def c200, 0.5, 0, 0.0625, 0\n  dcl_2d s13\n  ");
        }
        if ((this.cPos = this.shaderCode.indexOf("SceneColorTexture ")) != -1 && (this.cPos = (sampler = this.shaderCode.substring(this.cPos).split("\n")[0]).indexOf("s")) != -1) {
            sampler = "s" + sampler.trim().split("s")[1].split(" ")[0];
        }
        System.out.println("sampler = " + sampler);
        this.cPos = this.shaderCode.indexOf(", " + sampler);
        if (this.cPos != -1) {
            System.out.println("prova: " + this.shaderCode.substring(this.cPos - 12, this.cPos - 4));
            dReg = this.shaderCode.substring(this.cPos - 12, this.cPos - 4).split(",")[0].split(" ")[1];
        }
        System.out.println("depth = " + dReg);
        boolean found = false;
        int regNum = 0;
        while (regNum < 16 && !found) {
            System.out.println("Searching: " + String.format("%s, r%d.", vector, regNum));
            this.cPos = this.shaderCode.indexOf(String.format("%s, r%d.", vector, regNum));
            if (this.cPos != -1) {
                tempRegister = this.shaderCode.substring(this.cPos + vector.length() + 2, this.cPos + vector.length() + 8).split(",")[0];
                found = true;
            } else {
                this.cPos = this.shaderCode.indexOf(", " + vector);
                if (this.cPos != -1) {
                    System.out.println("found: , " + vector);
                    tempRegister = this.shaderCode.substring(this.cPos - 6, this.cPos).split(" ")[1];
                    found = true;
                    this.cPos -= tempRegister.length();
                }
            }
            ++regNum;
        }
        System.out.println("tempRegister = " + tempRegister);
        this.shaderCode.insert(this.cPos - 10, "texldl r16, c200.z, s13\n  add r16.y, " + dReg + ".w, -r16.y\n  mul r16.x, r16.x, r16.y\n  add " + tempRegister + ", " + tempRegister + ", -r16.x\n  ");
        this.saveFile();
    }

    public void fixVSHud() {
        this.addDeclarations();
        this.saveFile();
    }

    public void fixVSScreenTransform() {
        String scrTrVec = null;
        this.addDeclarations();
        this.cPos = this.shaderCode.indexOf("screenTransform ");
        if (this.cPos != -1 && (this.cPos = (scrTrVec = this.shaderCode.substring(this.cPos).split("\n")[0]).indexOf("c")) != -1) {
            scrTrVec = "c" + scrTrVec.trim().split("c")[2].split(" ")[0];
        }
        this.cPos = -1;
        int regNum = 0;
        while (this.cPos == -1 && regNum < 11) {
            this.cPos = this.shaderCode.lastIndexOf(String.format("r%d.x, %s", regNum, scrTrVec));
            ++regNum;
        }
        if ((this.cPos = this.shaderCode.indexOf(".xyw, r" + --regNum)) != -1) {
            String outRegister = this.shaderCode.substring(this.cPos - 2, this.cPos);
            this.shaderCode.replace(this.cPos - 2, this.cPos, "r12");
            this.cPos = this.shaderCode.indexOf(String.valueOf(outRegister) + ".z");
            this.shaderCode.replace(this.cPos, this.cPos + 2, "r12");
            this.cPos = this.shaderCode.lastIndexOf("dcl_position");
            if (this.cPos != -1) {
                this.shaderCode.insert(this.cPos - 2, "dcl_texcoord8 o10.x\n  ");
            }
            String sendToPS = "";
            this.cPos = this.shaderCode.lastIndexOf(".x, " + scrTrVec);
            if (this.cPos != -1) {
                sendToPS = this.shaderCode.substring(this.cPos - 6).split("\n")[0];
                this.shaderCode.insert(this.cPos - 8, String.valueOf(sendToPS) + "\n  ");
                this.shaderCode.replace(this.cPos - 4, this.cPos, "o10.x");
            }
            if ((this.cPos = this.shaderCode.lastIndexOf("\n//")) != -1) {
                this.shaderCode.insert(this.cPos, " texldl r11, c253.z, s1\n add r11.y, r12.w, -r11.y\n mul r11.x, r11.x, r11.y\n mul r11.x, r11.x, c253.x\n add r12.x, r12.x, r11.x\n mov " + outRegister + ", r12\n");
            }
        }
        this.saveFile();
    }

    private void addDeclarations() {
        int cPos = this.shaderCode.indexOf("vs_3_0");
        if (cPos != -1) {
            this.shaderCode.insert(cPos + 9, "def c253, 0.5, 0, 0.0625, 1\n  ");
        }
        if ((cPos = this.shaderCode.indexOf("dcl_")) != -1) {
            this.shaderCode.insert(cPos - 2, "dcl_2d s0\n  ");
        }
    }
}

