/*
  Switch statement
 
  Demonstrates the use of a switch statement.  The switch
  statement allows you to choose from among a set of discrete values
  of a variable.  It's like a series of if statements.
 
  To see this sketch in action, but the board and sensor in a well-lit
  room, open the serial monitor, and and move your hand gradually
  down over the sensor.
 
  The circuit:
  * photoresistor from analog in 0 to +3V
  * 10K resistor from analog in 0 to ground
 
  created 1 Jul 2009
  by Tom Igoe 
  modified 30 Apr 2013
  by Adrian Fernandez 
  
  Hardware Required:
  * MSP-EXP430G2 LaunchPad
  * (1) photocell, or analog sensor
  * (1) 10k ohm resistors
  * breadboard
  * hook-up wire
 
  This example code is in the public domain.
 
*/

// these constants won't change. They are the
// lowest and highest readings you get from your sensor:
const int sensorMin = 0;      // sensor minimum, discovered through experiment
const int sensorMax = 600;    // sensor maximum, discovered through experiment

void setup() {
  // initialize serial communication:
  Serial.begin(9600);  
}

void loop() {
  // read the sensor:
  int sensorReading = analogRead(A3);
  // map the sensor range to a range of four options:
  int range = map(sensorReading, sensorMin, sensorMax, 0, 3);

  // do something different depending on the 
  // range value:
  switch (range) {
  case 0:    // your hand is on the sensor
    Serial.println("dark");
    break;
  case 1:    // your hand is close to the sensor
    Serial.println("dim");
    break;
  case 2:    // your hand is a few inches from the sensor
    Serial.println("medium");
    break;
  case 3:    // your hand is nowhere near the sensor
    Serial.println("bright");
    break;
  } 
  delay(1);        // delay in between reads for stability
}