/*
  For Loop Iteration
 
  Demonstrates the use of a for() loop. 
  Lights multiple LEDs in sequence, then in reverse.
 
  The circuit:
  * LEDs from pins 2 through 10 to ground
 
  created 2006
  by David A. Mellis
  modified 16 Apr 2011
  by Adrian Fernandez 
  
  Hardware Required:
  * MSP-EXP430G2 LaunchPad
  * (9) 220 ohm resistors
  * (9) LEDs
  * hook-up wire
  * breadboard

  This example code is in the public domain.
 
*/

int timer = 100;           // The higher the number, the slower the timing.

void setup() {
  // use a for loop to initialize each pin as an output:
  for (int thisPin = 2; thisPin < 11; thisPin++)  {
    pinMode(thisPin, OUTPUT);      
  }
}

void loop() {
  // loop from the lowest pin to the highest:
  for (int thisPin = 2; thisPin < 11; thisPin++) { 
    // turn the pin on:
    digitalWrite(thisPin, HIGH);   
    delay(timer);                  
    // turn the pin off:
    digitalWrite(thisPin, LOW);    
  }

  // loop from the highest pin to the lowest:
  for (int thisPin = 10; thisPin >= 2; thisPin--) { 
    // turn the pin on:
    digitalWrite(thisPin, HIGH);
    delay(timer);
    // turn the pin off:
    digitalWrite(thisPin, LOW);
  }
}
