/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import processing.app.Base;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;

public class Sizer
implements MessageConsumer {
    private String buildPath;
    private String sketchName;
    private String firstLine;
    private long size;
    private RunnerException exception;

    public Sizer(String buildPath, String sketchName) {
        this.buildPath = buildPath;
        this.sketchName = sketchName;
    }

    public long computeSize() throws RunnerException {
        String[] commandSize;
        String basePath;
        String arch = Base.getArch();
        if (arch == "msp430") {
            basePath = Base.getMSP430BasePath();
            commandSize = new String[]{basePath + "msp430-size", " "};
        } else if (arch == "lm4f") {
            basePath = Base.getLM4FBasePath();
            commandSize = new String[]{basePath + "arm-none-eabi-size", " "};
        } else {
            basePath = Base.getAvrBasePath();
            commandSize = new String[]{basePath + "avr-size", " "};
        }
        commandSize[1] = arch == "lm4f" ? this.buildPath + File.separator + this.sketchName + ".elf" : this.buildPath + File.separator + this.sketchName + ".hex";
        int r = 0;
        try {
            this.exception = null;
            this.size = -1L;
            this.firstLine = null;
            Process process = Runtime.getRuntime().exec(commandSize);
            MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
            MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
            boolean running = true;
            while (running) {
                try {
                    if (in.thread != null) {
                        in.thread.join();
                    }
                    if (err.thread != null) {
                        err.thread.join();
                    }
                    r = process.waitFor();
                    running = false;
                }
                catch (InterruptedException intExc) {}
            }
        }
        catch (Exception e) {
            this.exception = new RunnerException(e.toString() == null ? e.getClass().getName() + r : e.toString() + r);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.size == -1L) {
            throw new RunnerException(this.firstLine);
        }
        return this.size;
    }

    public void message(String s) {
        if (this.firstLine == null) {
            this.firstLine = s;
        } else {
            String arch = Base.getArch();
            StringTokenizer st = new StringTokenizer(s, " ");
            try {
                if (arch == "lm4f") {
                    this.size = new Integer(st.nextToken().trim()).longValue();
                    this.size += new Integer(st.nextToken().trim()).longValue();
                } else {
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    this.size += new Integer(st.nextToken().trim()).longValue();
                }
            }
            catch (NoSuchElementException e) {
                this.exception = new RunnerException(e.toString());
            }
            catch (NumberFormatException e) {
                this.exception = new RunnerException(e.toString());
            }
        }
    }
}

