/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.app.debug.Uploader;

public class MSP430Uploader
extends Uploader {
    private Editor editor;

    public MSP430Uploader(Editor editor) {
        this.editor = editor;
    }

    public boolean uploadUsingPreferences(String buildPath, String className, boolean usingProgrammer) throws RunnerException, SerialException {
        this.verbose = this.verbose;
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        Target target = Base.getTarget();
        ArrayList<String> params = new ArrayList<String>();
        if (Base.isMacOS() || Base.isLinux()) {
            params.add(boardPreferences.get("upload.protocol"));
            if (!Preferences.getBoolean("upload.verbose")) {
                params.add("-q");
            }
            params.add("--force-reset");
            if (Base.isLinux()) {
                params.add("prog " + buildPath + File.separator + className + ".hex");
            } else {
                params.add("prog " + buildPath + File.separator + className + ".hex");
            }
        } else {
            params.add("tilib");
            if (!Preferences.getBoolean("upload.verbose")) {
                params.add("-q");
            }
            params.add("--force-reset");
            params.add("\"prog " + buildPath + File.separator + className + ".hex\"");
        }
        boolean ret = this.mspdebug(params);
        boolean retry = false;
        if (this.exception == null) {
            return ret;
        }
        if (!ret && this.exception.message.indexOf("update needed") != -1) {
            JOptionPane.showMessageDialog(this.editor, "Oops, the firmware of your Launchpad programmer needs an update.\n You will need to update before you can upload your Sketch.\n To update, select \"Update programmer\" from the \"Tools\" menu\n", "Firmware update needed", 0);
        }
        return ret;
    }

    public boolean doFetUpdate() throws RunnerException, SerialException {
        ArrayList<String> params = new ArrayList<String>();
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        if (Base.isMacOS() || Base.isLinux()) {
            params.add(boardPreferences.get("upload.protocol"));
        } else {
            params.add("tilib");
        }
        params.add("--allow-fw-update");
        params.add("\"exit\"");
        boolean ret = true;
        ret = this.mspdebug(params);
        return ret;
    }

    public boolean burnBootloader() throws RunnerException {
        return false;
    }

    public boolean mspdebug(Collection params) throws RunnerException {
        ArrayList<String> commandDownloader = new ArrayList<String>();
        if (Base.isLinux()) {
            commandDownloader.add(Base.getMSP430BasePath() + "mspdebug");
        } else if (Base.isMacOS()) {
            commandDownloader.add(Base.getHardwarePath() + "/tools/msp430/mspdebug/mspdebug");
        } else {
            commandDownloader.add(Base.getHardwarePath() + "\\tools\\msp430\\mspdebug\\mspdebug");
        }
        commandDownloader.addAll(params);
        return this.executeUploadCommand(commandDownloader);
    }

    public boolean MSP430Flasher(Collection params) throws RunnerException {
        ArrayList<String> commandDownloader = new ArrayList<String>();
        commandDownloader.add(Base.toShortPath(Base.getHardwarePath()) + "\\tools\\msp430\\MSP430Flasher\\" + "MSP430Flasher.exe");
        commandDownloader.addAll(params);
        return this.executeUploadCommand(commandDownloader);
    }
}

