/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.MessageStream;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements MessageConsumer {
    static final String BUGS_URL = I18n._("http://code.google.com/p/arduino/issues/list");
    static final String SUPER_BADNESS = I18n.format(I18n._("Compiler error, please submit this code to {0}"), BUGS_URL);
    Sketch sketch;
    String buildPath;
    String primaryClassName;
    boolean verbose;
    boolean sketchIsCompiled;
    RunnerException exception;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public boolean compile(Sketch sketch, String buildPath, String primaryClassName, boolean verbose) throws RunnerException {
        ArrayList<String> commandObjcopy;
        String corePath;
        File coreFolder;
        Target t;
        this.sketch = sketch;
        this.buildPath = buildPath;
        this.primaryClassName = primaryClassName;
        this.verbose = verbose;
        this.sketchIsCompiled = false;
        MessageStream pms = new MessageStream(this);
        String basePath = Base.getBasePath();
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        String core = boardPreferences.get("build.core");
        if (core == null) {
            RunnerException re = new RunnerException(I18n._("No board selected; please choose a board from the Tools > Board menu."));
            re.hideStackTrace();
            throw re;
        }
        if (core.indexOf(58) == -1) {
            t = Base.getTarget();
            coreFolder = new File(new File(t.getFolder(), "cores"), core);
            corePath = coreFolder.getAbsolutePath();
        } else {
            t = Base.targetsTable.get(core.substring(0, core.indexOf(58)));
            coreFolder = new File(t.getFolder(), "cores");
            coreFolder = new File(coreFolder, core.substring(core.indexOf(58) + 1));
            corePath = coreFolder.getAbsolutePath();
        }
        String variant = boardPreferences.get("build.variant");
        String variantPath = null;
        if (variant != null) {
            File variantFolder;
            Target t2;
            if (variant.indexOf(58) == -1) {
                t2 = Base.getTarget();
                variantFolder = new File(new File(t2.getFolder(), "variants"), variant);
                variantPath = variantFolder.getAbsolutePath();
            } else {
                t2 = Base.targetsTable.get(variant.substring(0, variant.indexOf(58)));
                variantFolder = new File(t2.getFolder(), "variants");
                variantFolder = new File(variantFolder, variant.substring(variant.indexOf(58) + 1));
                variantPath = variantFolder.getAbsolutePath();
            }
        }
        ArrayList<File> objectFiles = new ArrayList<File>();
        sketch.setCompilingProgress(20);
        ArrayList<File> includePaths = new ArrayList<File>();
        includePaths.add((File)((Object)corePath));
        if (variantPath != null) {
            includePaths.add((File)((Object)variantPath));
        }
        for (File file : sketch.getImportedLibraries()) {
            includePaths.add((File)((Object)file.getPath()));
        }
        sketch.setCompilingProgress(30);
        objectFiles.addAll(this.compileFiles(basePath, buildPath, includePaths, Compiler.findFilesInPath(buildPath, "S", false), Compiler.findFilesInPath(buildPath, "c", false), Compiler.findFilesInPath(buildPath, "cpp", false), boardPreferences));
        this.sketchIsCompiled = true;
        sketch.setCompilingProgress(40);
        for (File libraryFolder : sketch.getImportedLibraries()) {
            File outputFolder = new File(buildPath, libraryFolder.getName());
            File utilityFolder = new File(libraryFolder, "utility");
            Compiler.createFolder(outputFolder);
            includePaths.add((File)((Object)utilityFolder.getAbsolutePath()));
            objectFiles.addAll(this.compileFiles(basePath, outputFolder.getAbsolutePath(), includePaths, Compiler.findFilesInFolder(libraryFolder, "S", false), Compiler.findFilesInFolder(libraryFolder, "c", false), Compiler.findFilesInFolder(libraryFolder, "cpp", false), boardPreferences));
            outputFolder = new File(outputFolder, "utility");
            Compiler.createFolder(outputFolder);
            objectFiles.addAll(this.compileFiles(basePath, outputFolder.getAbsolutePath(), includePaths, Compiler.findFilesInFolder(utilityFolder, "S", false), Compiler.findFilesInFolder(utilityFolder, "c", false), Compiler.findFilesInFolder(utilityFolder, "cpp", false), boardPreferences));
            includePaths.remove(includePaths.size() - 1);
        }
        sketch.setCompilingProgress(50);
        includePaths.clear();
        includePaths.add((File)((Object)corePath));
        if (variantPath != null) {
            includePaths.add((File)((Object)variantPath));
        }
        List<File> coreObjectFiles = this.compileFiles(basePath, buildPath, includePaths, Compiler.findFilesInPath(corePath, "S", true), Compiler.findFilesInPath(corePath, "c", true), Compiler.findFilesInPath(corePath, "cpp", true), boardPreferences);
        String arch = Base.getArch();
        String runtimeLibraryName = buildPath + File.separator + "core.a";
        ArrayList<String> baseCommandAR = arch == "msp430" ? new ArrayList<String>(Arrays.asList(basePath + "msp430-ar", "rcs", runtimeLibraryName)) : (arch == "lm4f" ? new ArrayList<String>(Arrays.asList(basePath + "arm-none-eabi-ar", "rcs", runtimeLibraryName)) : new ArrayList<String>(Arrays.asList(basePath + "avr-ar", "rcs", runtimeLibraryName)));
        for (File file : coreObjectFiles) {
            ArrayList<String> commandAR = new ArrayList<String>(baseCommandAR);
            commandAR.add(file.getAbsolutePath());
            this.execAsynchronously(commandAR);
        }
        String optRelax = "";
        String atmega2560 = new String("atmega2560");
        if (atmega2560.equals(boardPreferences.get("build.mcu"))) {
            optRelax = new String(",--relax");
        }
        sketch.setCompilingProgress(60);
        ArrayList<String> baseCommandLinker = arch == "msp430" ? new ArrayList<String>(Arrays.asList(basePath + "msp430-gcc", "-Os", "-Wl,-gc-sections,-u,main", "-mmcu=" + boardPreferences.get("build.mcu"), "-o", buildPath + File.separator + primaryClassName + ".elf")) : (arch == "lm4f" ? new ArrayList<String>(Arrays.asList(basePath + "arm-none-eabi-g++", "-Os", "-nostartfiles", "-nostdlib", "-Wl,--gc-sections", "-T", corePath + File.separator + "lm4fcpp.ld", "--entry=ResetISR", "-mthumb", "-mcpu=cortex-m4", "-mfloat-abi=hard", "-mfpu=fpv4-sp-d16", "-fsingle-precision-constant", "-o", buildPath + File.separator + primaryClassName + ".elf")) : new ArrayList<String>(Arrays.asList(basePath + "avr-gcc", "-Os", "-Wl,--gc-sections" + optRelax, "-mmcu=" + boardPreferences.get("build.mcu"), "-o", buildPath + File.separator + primaryClassName + ".elf")));
        for (File file : objectFiles) {
            baseCommandLinker.add(file.getAbsolutePath());
        }
        baseCommandLinker.add(runtimeLibraryName);
        baseCommandLinker.add("-L" + buildPath);
        if (arch == "lm4f") {
            baseCommandLinker.add("-lm");
            baseCommandLinker.add("-lc");
            baseCommandLinker.add("-lgcc");
        } else {
            baseCommandLinker.add("-lm");
        }
        this.execAsynchronously(baseCommandLinker);
        ArrayList<String> baseCommandObjcopy = arch == "msp430" ? new ArrayList<String>(Arrays.asList(basePath + "msp430-objcopy", "-O", "-R")) : (arch == "lm4f" ? new ArrayList<String>(Arrays.asList(basePath + "arm-none-eabi-objcopy", "-O")) : new ArrayList<String>(Arrays.asList(basePath + "avr-objcopy", "-O", "-R")));
        if (arch != "msp430" && arch != "lm4f") {
            sketch.setCompilingProgress(70);
            commandObjcopy = new ArrayList<String>(baseCommandObjcopy);
            commandObjcopy.add(2, "ihex");
            commandObjcopy.set(3, "-j");
            commandObjcopy.add(".eeprom");
            commandObjcopy.add("--set-section-flags=.eeprom=alloc,load");
            commandObjcopy.add("--no-change-warnings");
            commandObjcopy.add("--change-section-lma");
            commandObjcopy.add(".eeprom=0");
            commandObjcopy.add(buildPath + File.separator + primaryClassName + ".elf");
            commandObjcopy.add(buildPath + File.separator + primaryClassName + ".eep");
            this.execAsynchronously(commandObjcopy);
        }
        sketch.setCompilingProgress(80);
        commandObjcopy = new ArrayList<String>(baseCommandObjcopy);
        if (arch == "lm4f") {
            commandObjcopy.add(2, "binary");
            commandObjcopy.add(buildPath + File.separator + primaryClassName + ".elf");
            commandObjcopy.add(buildPath + File.separator + primaryClassName + ".bin");
        } else {
            commandObjcopy.add(2, "ihex");
            commandObjcopy.add(".eeprom");
            commandObjcopy.add(buildPath + File.separator + primaryClassName + ".elf");
            commandObjcopy.add(buildPath + File.separator + primaryClassName + ".hex");
        }
        this.execAsynchronously(commandObjcopy);
        sketch.setCompilingProgress(90);
        return true;
    }

    private List<File> compileFiles(String basePath, String buildPath, List<File> includePaths, List<File> sSources, List<File> cSources, List<File> cppSources, Map<String, String> boardPreferences) throws RunnerException {
        File dependFile;
        File objectFile;
        String dependPath;
        String objectPath;
        ArrayList<File> objectPaths = new ArrayList<File>();
        for (File file : sSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            this.execAsynchronously(Compiler.getCommandCompilerS(basePath, includePaths, file.getAbsolutePath(), objectPath, boardPreferences));
        }
        for (File file : cSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            dependPath = buildPath + File.separator + file.getName() + ".d";
            objectFile = new File(objectPath);
            dependFile = new File(dependPath);
            objectPaths.add(objectFile);
            if (this.is_already_compiled(file, objectFile, dependFile, boardPreferences)) continue;
            this.execAsynchronously(Compiler.getCommandCompilerC(basePath, includePaths, file.getAbsolutePath(), objectPath, boardPreferences));
        }
        for (File file : cppSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            dependPath = buildPath + File.separator + file.getName() + ".d";
            objectFile = new File(objectPath);
            dependFile = new File(dependPath);
            objectPaths.add(objectFile);
            if (this.is_already_compiled(file, objectFile, dependFile, boardPreferences)) continue;
            this.execAsynchronously(Compiler.getCommandCompilerCPP(basePath, includePaths, file.getAbsolutePath(), objectPath, boardPreferences));
        }
        return objectPaths;
    }

    private boolean is_already_compiled(File src, File obj, File dep, Map<String, String> prefs) {
        boolean ret = true;
        try {
            String line;
            long obj_modified;
            if (!obj.exists()) {
                return false;
            }
            if (!dep.exists()) {
                return false;
            }
            long src_modified = src.lastModified();
            if (src_modified >= (obj_modified = obj.lastModified())) {
                return false;
            }
            if (src_modified >= dep.lastModified()) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new FileReader(dep.getPath()));
            boolean need_obj_parse = true;
            while ((line = reader.readLine()) != null) {
                if (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                }
                if ((line = line.trim()).length() == 0) continue;
                if (need_obj_parse) {
                    if (line.endsWith(":")) {
                        File linefile;
                        String linepath;
                        line = line.substring(0, line.length() - 1);
                        String objpath = obj.getCanonicalPath();
                        if (objpath.compareTo(linepath = (linefile = new File(line)).getCanonicalPath()) == 0) {
                            need_obj_parse = false;
                            continue;
                        }
                        ret = false;
                        break;
                    }
                    ret = false;
                    break;
                }
                File prereq = new File(line);
                if (!prereq.exists()) {
                    ret = false;
                    break;
                }
                if (prereq.lastModified() < obj_modified) continue;
                ret = false;
                break;
            }
            reader.close();
        }
        catch (Exception e) {
            return false;
        }
        if (ret && (this.verbose || Preferences.getBoolean("build.verbose"))) {
            System.out.println("  Using previously compiled: " + obj.getPath());
        }
        return ret;
    }

    private void execAsynchronously(List commandList) throws RunnerException {
        Process process;
        String[] command = new String[commandList.size()];
        commandList.toArray(command);
        int result = 0;
        if (this.verbose || Preferences.getBoolean("build.verbose")) {
            for (int j = 0; j < command.length; ++j) {
                System.out.print(command[j] + " ");
            }
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
        boolean compiling = true;
        while (compiling) {
            try {
                if (in.thread != null) {
                    in.thread.join();
                }
                if (err.thread != null) {
                    err.thread.join();
                }
                result = process.waitFor();
                compiling = false;
            }
            catch (InterruptedException ignored) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(I18n.format(I18n._("{0} returned {1}"), command[0], result));
        }
        if (result != 0) {
            RunnerException re = new RunnerException(I18n._("Error compiling."));
            re.hideStackTrace();
            throw re;
        }
    }

    @Override
    public void message(String s) {
        String errorFormat;
        String[] pieces;
        if (!this.verbose) {
            int i;
            while ((i = s.indexOf(this.buildPath + File.separator)) != -1) {
                s = s.substring(0, i) + s.substring(i + (this.buildPath + File.separator).length());
            }
        }
        if ((pieces = PApplet.match((String)s, (String)(errorFormat = "([\\w\\d_]+.\\w+):(\\d+):\\s*error:\\s*(.*)\\s*"))) != null) {
            String error = pieces[3];
            String msg = "";
            if (pieces[3].trim().equals("SPI.h: No such file or directory")) {
                error = I18n._("Please import the SPI library from the Sketch > Import Library menu.");
                msg = I18n._("\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.\n\n");
            }
            if (pieces[3].trim().equals("'BYTE' was not declared in this scope")) {
                error = I18n._("The 'BYTE' keyword is no longer supported.");
                msg = I18n._("\nAs of Arduino 1.0, the 'BYTE' keyword is no longer supported.\nPlease use Serial.write() instead.\n\n");
            }
            if (pieces[3].trim().equals("no matching function for call to 'Server::Server(int)'")) {
                error = I18n._("The Server class has been renamed EthernetServer.");
                msg = I18n._("\nAs of Arduino 1.0, the Server class in the Ethernet library has been renamed to EthernetServer.\n\n");
            }
            if (pieces[3].trim().equals("no matching function for call to 'Client::Client(byte [4], int)'")) {
                error = I18n._("The Client class has been renamed EthernetClient.");
                msg = I18n._("\nAs of Arduino 1.0, the Client class in the Ethernet library has been renamed to EthernetClient.\n\n");
            }
            if (pieces[3].trim().equals("'Udp' was not declared in this scope")) {
                error = I18n._("The Udp class has been renamed EthernetUdp.");
                msg = I18n._("\nAs of Arduino 1.0, the Udp class in the Ethernet library has been renamed to EthernetClient.\n\n");
            }
            if (pieces[3].trim().equals("'class TwoWire' has no member named 'send'")) {
                error = I18n._("Wire.send() has been renamed Wire.write().");
                msg = I18n._("\nAs of Arduino 1.0, the Wire.send() function was renamed to Wire.write() for consistency with other libraries.\n\n");
            }
            if (pieces[3].trim().equals("'class TwoWire' has no member named 'receive'")) {
                error = I18n._("Wire.receive() has been renamed Wire.read().");
                msg = I18n._("\nAs of Arduino 1.0, the Wire.receive() function was renamed to Wire.read() for consistency with other libraries.\n\n");
            }
            RunnerException e = null;
            if (!this.sketchIsCompiled) {
                e = this.sketch.placeException(error, pieces[1], PApplet.parseInt((String)pieces[2]) - 1);
            }
            if (e != null && !this.verbose) {
                SketchCode code = this.sketch.getCode(e.getCodeIndex());
                String fileName = code.isExtension("ino") || code.isExtension("pde") ? code.getPrettyName() : code.getFileName();
                int lineNum = e.getCodeLine() + 1;
                s = fileName + ":" + lineNum + ": error: " + pieces[3] + msg;
            }
            if (this.exception == null && e != null) {
                this.exception = e;
                this.exception.hideStackTrace();
            }
        }
        System.err.print(s);
    }

    private static List getCommandCompilerS(String basePath, List includePaths, String sourceName, String objectName, Map<String, String> boardPreferences) {
        String arch = Base.getArch();
        ArrayList<String> baseCommandCompiler = arch == "msp430" ? new ArrayList<String>(Arrays.asList(basePath + "msp430-gcc", "-c", "-g", "-assembler-with-cpp", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-DARDUINO=101", "-DENERGIA=10")) : (arch == "lm4f" ? new ArrayList<String>(Arrays.asList(basePath + "arm-none-eabi-gcc", "-c", "-g", "-assembler-with-cpp", Preferences.getBoolean("build.verbose") ? "-Wall" : "-w", "-mthumb", "-mcpu=cortex-m4", "-mfloat-abi=hard", "-mfpu=fpv4-sp-d16", "-fsingle-precision-constant", "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-DARDUINO=101", "-DENERGIA=10")) : new ArrayList<String>(Arrays.asList(basePath + "avr-gcc", "-c", "-g", "-assembler-with-cpp", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-DARDUINO=101")));
        for (int i = 0; i < includePaths.size(); ++i) {
            baseCommandCompiler.add("-I" + (String)includePaths.get(i));
        }
        baseCommandCompiler.add(sourceName);
        baseCommandCompiler.add("-o" + objectName);
        return baseCommandCompiler;
    }

    private static List getCommandCompilerC(String basePath, List includePaths, String sourceName, String objectName, Map<String, String> boardPreferences) {
        String arch = Base.getArch();
        ArrayList<String> baseCommandCompiler = arch == "msp430" ? new ArrayList<String>(Arrays.asList(basePath + "msp430-gcc", "-c", "-g", "-Os", Preferences.getBoolean("build.verbose") ? "-Wall" : "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-MMD", "-DARDUINO=101", "-DENERGIA=10")) : (arch == "lm4f" ? new ArrayList<String>(Arrays.asList(basePath + "arm-none-eabi-gcc", "-c", "-g", "-Os", Preferences.getBoolean("build.verbose") ? "-Wall" : "-w", "-ffunction-sections", "-fdata-sections", "-mthumb", "-mcpu=cortex-m4", "-mfloat-abi=hard", "-mfpu=fpv4-sp-d16", "-fsingle-precision-constant", "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-MMD", "-DARDUINO=101", "-DENERGIA=10")) : new ArrayList<String>(Arrays.asList(basePath + "avr-gcc", "-c", "-g", "-Os", Preferences.getBoolean("build.verbose") ? "-Wall" : "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-MMD", "-DARDUINO=101")));
        for (int i = 0; i < includePaths.size(); ++i) {
            baseCommandCompiler.add("-I" + (String)includePaths.get(i));
        }
        baseCommandCompiler.add(sourceName);
        baseCommandCompiler.add("-o");
        baseCommandCompiler.add(objectName);
        return baseCommandCompiler;
    }

    private static List getCommandCompilerCPP(String basePath, List includePaths, String sourceName, String objectName, Map<String, String> boardPreferences) {
        String arch = Base.getArch();
        ArrayList<String> baseCommandCompilerCPP = arch == "msp430" ? new ArrayList<String>(Arrays.asList(basePath + "msp430-g++", "-c", "-g", "-Os", Preferences.getBoolean("build.verbose") ? "-Wall" : "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-MMD", "-DARDUINO=101", "-DENERGIA=10")) : (arch == "lm4f" ? new ArrayList<String>(Arrays.asList(basePath + "arm-none-eabi-g++", "-c", "-g", "-Os", Preferences.getBoolean("build.verbose") ? "-Wall" : "-w", "-fno-rtti", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mthumb", "-mcpu=cortex-m4", "-mfloat-abi=hard", "-mfpu=fpv4-sp-d16", "-fsingle-precision-constant", "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-MMD", "-DARDUINO=101", "-DENERGIA=10")) : new ArrayList<String>(Arrays.asList(basePath + "avr-g++", "-c", "-g", "-Os", Preferences.getBoolean("build.verbose") ? "-Wall" : "-w", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-MMD", "-DARDUINO=101")));
        for (int i = 0; i < includePaths.size(); ++i) {
            baseCommandCompilerCPP.add("-I" + (String)includePaths.get(i));
        }
        baseCommandCompilerCPP.add(sourceName);
        baseCommandCompilerCPP.add("-o");
        baseCommandCompilerCPP.add(objectName);
        return baseCommandCompilerCPP;
    }

    private static void createFolder(File folder) throws RunnerException {
        if (folder.isDirectory()) {
            return;
        }
        if (!folder.mkdir()) {
            throw new RunnerException("Couldn't create: " + folder);
        }
    }

    public static String[] headerListFromIncludePath(String path) {
        FilenameFilter onlyHFiles = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".h");
            }
        };
        return new File(path).list(onlyHFiles);
    }

    public static ArrayList<File> findFilesInPath(String path, String extension, boolean recurse) {
        return Compiler.findFilesInFolder(new File(path), extension, recurse);
    }

    public static ArrayList<File> findFilesInFolder(File folder, String extension, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        if (folder.listFiles() == null) {
            return files;
        }
        for (File file : folder.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            if (file.getName().endsWith("." + extension)) {
                files.add(file);
            }
            if (!recurse || !file.isDirectory()) continue;
            files.addAll(Compiler.findFilesInFolder(file, extension, true));
        }
        return files;
    }
}

