/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.Theme;
import processing.app.debug.MessageConsumer;
import processing.core.PApplet;

public class SerialMonitor
extends JFrame
implements MessageConsumer {
    private Serial serial;
    private String port;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JTextField textField;
    private JButton sendButton;
    private JCheckBox autoscrollBox;
    private JComboBox lineEndings;
    private JComboBox serialRates;
    private int serialRate;
    public Boolean isOpenPending;

    public SerialMonitor(String port) {
        super(port);
        this.port = port;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SerialMonitor.this.closeSerialPort();
            }
        });
        KeyStroke wc = Editor.WINDOW_CLOSE_KEYSTROKE;
        this.getRootPane().getInputMap(1).put(wc, "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SerialMonitor.this.closeSerialPort();
                SerialMonitor.this.setVisible(false);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = Preferences.getFont("editor.font");
        Font font = new Font(consoleFont.getName(), consoleFont.getStyle(), editorFont.getSize());
        this.textArea = new JTextArea(16, 40);
        this.textArea.setEditable(false);
        this.textArea.setFont(font);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        this.scrollPane = new JScrollPane(this.textArea);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.textField = new JTextField(40);
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
        this.sendButton = new JButton(I18n._("Send"));
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
        pane.add(this.textField);
        pane.add(Box.createRigidArea(new Dimension(4, 0)));
        pane.add(this.sendButton);
        this.getContentPane().add((Component)pane, "North");
        pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.autoscrollBox = new JCheckBox(I18n._("Autoscroll"), true);
        this.lineEndings = new JComboBox<String>(new String[]{I18n._("No line ending"), I18n._("Newline"), I18n._("Carriage return"), I18n._("Both NL & CR")});
        this.lineEndings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Preferences.setInteger("serial.line_ending", SerialMonitor.this.lineEndings.getSelectedIndex());
            }
        });
        if (Preferences.get("serial.line_ending") != null) {
            this.lineEndings.setSelectedIndex(Preferences.getInteger("serial.line_ending"));
        }
        this.lineEndings.setMaximumSize(this.lineEndings.getMinimumSize());
        String[] serialRateStrings = new String[]{"300", "1200", "2400", "4800", "9600", "14400", "19200", "28800", "38400", "57600", "115200"};
        this.serialRates = new JComboBox();
        for (int i = 0; i < serialRateStrings.length; ++i) {
            this.serialRates.addItem(serialRateStrings[i] + I18n._(" baud"));
        }
        this.serialRate = Preferences.getInteger("serial.debug_rate");
        this.serialRates.setSelectedItem(this.serialRate + I18n._(" baud"));
        this.serialRates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String wholeString = (String)SerialMonitor.this.serialRates.getSelectedItem();
                String rateString = wholeString.substring(0, wholeString.indexOf(32));
                SerialMonitor.this.serialRate = Integer.parseInt(rateString);
                Preferences.set("serial.debug_rate", rateString);
                SerialMonitor.this.closeSerialPort();
                try {
                    SerialMonitor.this.openSerialPort();
                }
                catch (SerialException e) {
                    System.err.println(e);
                }
            }
        });
        this.serialRates.setMaximumSize(this.serialRates.getMinimumSize());
        pane.add(this.autoscrollBox);
        pane.add(Box.createHorizontalGlue());
        pane.add(this.lineEndings);
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.serialRates);
        this.getContentPane().add((Component)pane, "South");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (Preferences.get("last.screen.height") != null) {
            String locationStr;
            int screenW = Preferences.getInteger("last.screen.width");
            int screenH = Preferences.getInteger("last.screen.height");
            if (screen.width == screenW && screen.height == screenH && (locationStr = Preferences.get("last.serial.location")) != null) {
                int[] location = PApplet.parseInt((String[])PApplet.split((String)locationStr, (char)','));
                this.setPlacement(location);
            }
        }
    }

    protected void setPlacement(int[] location) {
        this.setBounds(location[0], location[1], location[2], location[3]);
    }

    protected int[] getPlacement() {
        int[] location = new int[4];
        Rectangle bounds = this.getBounds();
        location[0] = bounds.x;
        location[1] = bounds.y;
        location[2] = bounds.width;
        location[3] = bounds.height;
        return location;
    }

    private void send(String s) {
        if (this.serial != null) {
            switch (this.lineEndings.getSelectedIndex()) {
                case 1: {
                    s = s + "\n";
                    break;
                }
                case 2: {
                    s = s + "\r";
                    break;
                }
                case 3: {
                    s = s + "\r\n";
                }
            }
            this.serial.write(s);
        }
    }

    public void openSerialPort() throws SerialException {
        this.isOpenPending = false;
        if (this.serial != null) {
            return;
        }
        this.serial = new Serial(this.port, this.serialRate);
        this.serial.addListener(this);
    }

    public void closeSerialPort() {
        if (this.serial != null) {
            int[] location = this.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            Preferences.set("last.serial.location", locationStr);
            this.textArea.setText("");
            this.serial.dispose();
            this.serial = null;
        }
    }

    public void message(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SerialMonitor.this.textArea.append(s);
                if (SerialMonitor.this.autoscrollBox.isSelected()) {
                    SerialMonitor.this.textArea.setCaretPosition(SerialMonitor.this.textArea.getDocument().getLength());
                }
            }
        });
    }
}

