/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import processing.app.Base;
import processing.app.EditorConsole;
import processing.app.EditorHeader;
import processing.app.EditorLineStatus;
import processing.app.EditorListener;
import processing.app.EditorStatus;
import processing.app.EditorToolbar;
import processing.app.FindReplace;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.SerialMonitor;
import processing.app.SerialNotFoundException;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Theme;
import processing.app.debug.AvrdudeUploader;
import processing.app.debug.MSP430Uploader;
import processing.app.debug.RunnerException;
import processing.app.debug.RunnerListener;
import processing.app.debug.Uploader;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.TextAreaPainter;
import processing.app.tools.DiscourseFormat;
import processing.app.tools.MenuScroller;
import processing.app.tools.Tool;
import processing.core.PApplet;

public class Editor
extends JFrame
implements RunnerListener {
    Base base;
    protected static final String EMPTY = "                                                                                                                                                                                                               ";
    static final int SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
    static final int SHORTCUT_ALT_KEY_MASK = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    boolean untitled;
    PageFormat pageFormat;
    PrinterJob printerJob;
    JMenu fileMenu;
    JMenu sketchMenu;
    JMenu toolsMenu;
    int numTools = 0;
    EditorToolbar toolbar;
    static JMenu toolbarMenu;
    static JMenu sketchbookMenu;
    static JMenu examplesMenu;
    static JMenu importMenu;
    static JMenu boardsMenu;
    static JMenu serialMenu;
    static SerialMenuListener serialMenuListener;
    static SerialMonitor serialMonitor;
    EditorHeader header;
    EditorStatus status;
    EditorConsole console;
    JSplitPane splitPane;
    JPanel consolePanel;
    JLabel lineNumberComponent;
    Sketch sketch;
    EditorLineStatus lineStatus;
    JEditTextArea textarea;
    EditorListener listener;
    Point sketchWindowLocation;
    JMenuItem exportAppItem;
    JMenuItem saveMenuItem;
    JMenuItem saveAsMenuItem;
    boolean running;
    boolean uploading;
    JMenuItem undoItem;
    JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    UndoManager undo;
    CompoundEdit compoundEdit;
    FindReplace find;
    Runnable doFetUpdateHandler;
    Runnable runHandler;
    Runnable presentHandler;
    Runnable stopHandler;
    Runnable exportHandler;
    Runnable exportAppHandler;

    public Editor(Base ibase, String path, int[] location) {
        super("Energia");
        this.base = ibase;
        Base.setIcon(this);
        this.resetHandlers();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Editor.this.base.handleClose(Editor.this);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Editor.this.base.handleActivated(Editor.this);
                Editor.this.fileMenu.insert(sketchbookMenu, 2);
                Editor.this.fileMenu.insert(examplesMenu, 3);
                Editor.this.sketchMenu.insert(importMenu, 7);
                Editor.this.toolsMenu.insert(boardsMenu, Editor.this.numTools);
                Editor.this.toolsMenu.insert(serialMenu, Editor.this.numTools + 1);
            }

            public void windowDeactivated(WindowEvent e) {
                Editor.this.fileMenu.remove(sketchbookMenu);
                Editor.this.fileMenu.remove(examplesMenu);
                Editor.this.sketchMenu.remove(importMenu);
                Editor.this.toolsMenu.remove(boardsMenu);
                Editor.this.toolsMenu.remove(serialMenu);
            }
        });
        if (serialMonitor == null) {
            serialMonitor = new SerialMonitor(Preferences.get("serial.port"));
            serialMonitor.setIconImage(this.getIconImage());
        }
        this.buildMenuBar();
        Container contentPain = this.getContentPane();
        contentPain.setLayout(new BorderLayout());
        JPanel pain = new JPanel();
        pain.setLayout(new BorderLayout());
        contentPain.add((Component)pain, "Center");
        Box box = Box.createVerticalBox();
        Box upper = Box.createVerticalBox();
        if (toolbarMenu == null) {
            int n = this.base.rebuildToolbarMenu(toolbarMenu = new JMenu());
            MenuScroller.setScrollerFor(toolbarMenu, -1, -1, 2, n > 0 ? n + 1 : 0);
        }
        this.toolbar = new EditorToolbar(this, toolbarMenu);
        upper.add(this.toolbar);
        this.header = new EditorHeader(this);
        upper.add(this.header);
        this.textarea = new JEditTextArea(new PdeTextAreaDefaults());
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        this.consolePanel = new JPanel();
        this.consolePanel.setLayout(new BorderLayout());
        this.status = new EditorStatus(this);
        this.consolePanel.add((Component)this.status, "North");
        this.console = new EditorConsole(this);
        this.console.setBorder(null);
        this.consolePanel.add((Component)this.console, "Center");
        this.lineStatus = new EditorLineStatus(this.textarea);
        this.consolePanel.add((Component)this.lineStatus, "South");
        upper.add(this.textarea);
        this.splitPane = new JSplitPane(0, upper, this.consolePanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        int dividerSize = Preferences.getInteger("editor.divider.size");
        if (dividerSize != 0) {
            this.splitPane.setDividerSize(dividerSize);
        }
        this.splitPane.setMinimumSize(new Dimension(600, 100));
        box.add(this.splitPane);
        this.listener = new EditorListener(this, this.textarea);
        pain.add(box);
        this.textarea.addKeyListener(this.toolbar);
        pain.setTransferHandler(new FileDropHandler());
        this.pack();
        this.setPlacement(location);
        this.setMinimumSize(new Dimension(Preferences.getInteger("editor.window.width.min"), Preferences.getInteger("editor.window.height.min")));
        this.applyPreferences();
        boolean loaded = this.handleOpenInternal(path);
        if (!loaded) {
            this.sketch = null;
        }
    }

    protected void setPlacement(int[] location) {
        this.setBounds(location[0], location[1], location[2], location[3]);
        if (location[4] != 0) {
            this.splitPane.setDividerLocation(location[4]);
        }
    }

    protected int[] getPlacement() {
        int[] location = new int[5];
        Rectangle bounds = this.getBounds();
        location[0] = bounds.x;
        location[1] = bounds.y;
        location[2] = bounds.width;
        location[3] = bounds.height;
        location[4] = this.splitPane.getDividerLocation();
        return location;
    }

    protected void applyPreferences() {
        boolean external = Preferences.getBoolean("editor.external");
        this.textarea.setEditable(!external);
        this.saveMenuItem.setEnabled(!external);
        this.saveAsMenuItem.setEnabled(!external);
        TextAreaPainter painter = this.textarea.getPainter();
        if (external) {
            Color color = Theme.getColor("editor.external.bgcolor");
            painter.setBackground(color);
            painter.setLineHighlightEnabled(false);
            this.textarea.setCaretVisible(false);
        } else {
            Color color = Theme.getColor("editor.bgcolor");
            painter.setBackground(color);
            boolean highlight = Preferences.getBoolean("editor.linehighlight");
            painter.setLineHighlightEnabled(highlight);
            this.textarea.setCaretVisible(true);
        }
        painter.setFont(Preferences.getFont("editor.font"));
        this.listener.applyPreferences();
    }

    protected void buildMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar = new JMenuBar();
        menubar.add(this.buildFileMenu());
        menubar.add(this.buildEditMenu());
        menubar.add(this.buildSketchMenu());
        menubar.add(this.buildToolsMenu());
        menubar.add(this.buildHelpMenu());
        this.setJMenuBar(menubar);
    }

    protected JMenu buildFileMenu() {
        this.fileMenu = new JMenu(I18n._("File"));
        JMenuItem item = Editor.newJMenuItem(I18n._("New"), 78);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleNew();
            }
        });
        this.fileMenu.add(item);
        item = Editor.newJMenuItem(I18n._("Open..."), 79);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleOpenPrompt();
            }
        });
        this.fileMenu.add(item);
        if (sketchbookMenu == null) {
            sketchbookMenu = new JMenu(I18n._("Sketchbook"));
            MenuScroller.setScrollerFor(sketchbookMenu);
            this.base.rebuildSketchbookMenu(sketchbookMenu);
        }
        this.fileMenu.add(sketchbookMenu);
        if (examplesMenu == null) {
            examplesMenu = new JMenu(I18n._("Examples"));
            this.rebuildExamplesMenu();
        }
        this.fileMenu.add(examplesMenu);
        item = Editor.newJMenuItem(I18n._("Close"), 87);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleClose(Editor.this);
            }
        });
        this.fileMenu.add(item);
        this.saveMenuItem = Editor.newJMenuItem(I18n._("Save"), 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSave(false);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem = Editor.newJMenuItemShift(I18n._("Save As..."), 83);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSaveAs();
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.addSeparator();
        item = Editor.newJMenuItem(I18n._("Upload"), 85);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleExport(false, false);
            }
        });
        this.fileMenu.add(item);
        item = Editor.newJMenuItem(I18n._("Upload and then Open Serial Monitor"), 77);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleExport(false, true);
            }
        });
        this.fileMenu.add(item);
        if (!Preferences.get("target").equals("msp430") || !Preferences.get("target").equals("lm4f")) {
            item = Editor.newJMenuItemShift(I18n._("Upload Using Programmer"), 85);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleExport(true, false);
                }
            });
            this.fileMenu.add(item);
            this.fileMenu.addSeparator();
        }
        item = Editor.newJMenuItemShift(I18n._("Page Setup"), 80);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePageSetup();
            }
        });
        this.fileMenu.add(item);
        item = Editor.newJMenuItem(I18n._("Print"), 80);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handlePrint();
            }
        });
        this.fileMenu.add(item);
        if (!Base.isMacOS()) {
            this.fileMenu.addSeparator();
            item = Editor.newJMenuItem(I18n._("Preferences"), 44);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handlePrefs();
                }
            });
            this.fileMenu.add(item);
            this.fileMenu.addSeparator();
            item = Editor.newJMenuItem(I18n._("Quit"), 81);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handleQuit();
                }
            });
            this.fileMenu.add(item);
        }
        return this.fileMenu;
    }

    private void rebuildExamplesMenu() {
        this.base.rebuildExamplesMenu(examplesMenu);
        int upper = 0;
        int lower = 0;
        for (int i = 0; i < examplesMenu.getMenuComponentCount(); ++i) {
            if (!examplesMenu.getMenuComponent(i).getClass().getName().contains("Separator")) continue;
            if (upper == 0) {
                upper = i;
                continue;
            }
            lower = examplesMenu.getItemCount() - i;
            break;
        }
        MenuScroller.setScrollerFor(examplesMenu, -1, -1, upper > 0 ? upper + 1 : 0, lower);
    }

    protected JMenu buildSketchMenu() {
        this.sketchMenu = new JMenu(I18n._("Sketch"));
        JMenuItem item = Editor.newJMenuItem(I18n._("Verify / Compile"), 82);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleRun(false);
            }
        });
        this.sketchMenu.add(item);
        this.sketchMenu.addSeparator();
        item = new JMenuItem(I18n._("Copy Hex File as Path"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String s = Editor.this.sketch.getSketchHexFilePath(true);
                if (Editor.this.sketch != null && s.length() > 0) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
                } else {
                    Base.showMessage(I18n._("No Hex File"), I18n._("There is no Hex for this Sketch yet. Verify the Sketch first"));
                }
            }
        });
        this.sketchMenu.add(item);
        item = Editor.newJMenuItemAlt(I18n._("Show Compilation Folder"), 82);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openFolder(Editor.this.sketch.getTempBuildFolder());
            }
        });
        this.sketchMenu.add(item);
        this.sketchMenu.addSeparator();
        if (importMenu == null) {
            importMenu = new JMenu(I18n._("Import Library..."));
            this.base.rebuildImportMenu(importMenu);
        }
        this.sketchMenu.add(importMenu);
        item = Editor.newJMenuItem(I18n._("Show Sketch Folder"), 75);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openFolder(Editor.this.sketch.getFolder());
            }
        });
        this.sketchMenu.add(item);
        item.setEnabled(Base.openFolderAvailable());
        item = new JMenuItem(I18n._("Add File..."));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.sketch.handleAddFile();
            }
        });
        this.sketchMenu.add(item);
        this.sketchMenu.addSeparator();
        if (importMenu == null) {
            importMenu = new JMenu(I18n._("Import Library"));
            int n = this.base.rebuildImportMenu(importMenu);
            MenuScroller.setScrollerFor(importMenu, -1, -1, n + 1, 0);
        }
        this.sketchMenu.add(importMenu);
        return this.sketchMenu;
    }

    protected JMenu buildToolsMenu() {
        JMenu menu = this.toolsMenu = new JMenu(I18n._("Tools"));
        this.addInternalTools(menu);
        JMenuItem item = Editor.newJMenuItemShift(I18n._("Serial Monitor"), 77);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleSerial();
            }
        });
        menu.add(item);
        this.addTools(menu, Base.getToolsFolder());
        File sketchbookTools = new File(Base.getSketchbookFolder(), "tools");
        this.addTools(menu, sketchbookTools);
        menu.addSeparator();
        this.numTools = menu.getItemCount();
        if (boardsMenu == null) {
            boardsMenu = new JMenu(I18n._("Board"));
            MenuScroller.setScrollerFor(boardsMenu);
            this.base.rebuildBoardsMenu(boardsMenu);
        }
        menu.add(boardsMenu);
        if (serialMenuListener == null) {
            serialMenuListener = new SerialMenuListener();
        }
        if (serialMenu == null) {
            serialMenu = new JMenu(I18n._("Serial Port"));
        }
        this.populateSerialMenu();
        menu.add(serialMenu);
        menu.addSeparator();
        item = new JMenuItem(I18n._("Update programmer"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleDoFetUpdate();
            }
        });
        menu.add(item);
        menu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                Editor.this.populateSerialMenu();
            }
        });
        return menu;
    }

    protected void addTools(JMenu menu, File sourceFolder) {
        HashMap<String, JMenuItem> toolItems = new HashMap<String, JMenuItem>();
        File[] folders = sourceFolder.listFiles(new FileFilter(){

            public boolean accept(File folder) {
                if (folder.isDirectory()) {
                    File subfolder = new File(folder, "tool");
                    return subfolder.exists();
                }
                return false;
            }
        });
        if (folders == null || folders.length == 0) {
            return;
        }
        for (int i = 0; i < folders.length; ++i) {
            File toolDirectory = new File(folders[i], "tool");
            try {
                File[] archives = toolDirectory.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip");
                    }
                });
                URL[] urlList = new URL[archives.length];
                for (int j = 0; j < urlList.length; ++j) {
                    urlList[j] = archives[j].toURI().toURL();
                }
                URLClassLoader loader = new URLClassLoader(urlList);
                String className = null;
                for (int j = 0; j < archives.length && (className = this.findClassInZipFile(folders[i].getName(), archives[j])) == null; ++j) {
                }
                if (className == null) continue;
                Class<?> toolClass = Class.forName(className, true, loader);
                final Tool tool = (Tool)toolClass.newInstance();
                tool.init(this);
                String title = tool.getMenuTitle();
                JMenuItem item = new JMenuItem(title);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(tool);
                    }
                });
                toolItems.put(title, item);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList toolList = new ArrayList(toolItems.keySet());
        if (toolList.size() == 0) {
            return;
        }
        menu.addSeparator();
        Collections.sort(toolList);
        for (String title : toolList) {
            menu.add((JMenuItem)toolItems.get(title));
        }
    }

    protected String findClassInZipFile(String base, File file) {
        String classFileName = "/" + base + ".class";
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(classFileName)) continue;
                return name.substring(0, name.length() - 6).replace('/', '.');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected JMenuItem createToolMenuItem(String className) {
        try {
            Class<?> toolClass = Class.forName(className);
            final Tool tool = (Tool)toolClass.newInstance();
            JMenuItem item = new JMenuItem(tool.getMenuTitle());
            tool.init(this);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(tool);
                }
            });
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected JMenu addInternalTools(JMenu menu) {
        JMenuItem item = this.createToolMenuItem("processing.app.tools.AutoFormat");
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        item.setAccelerator(KeyStroke.getKeyStroke(84, modifiers));
        menu.add(item);
        menu.add(this.createToolMenuItem("processing.app.tools.Archiver"));
        menu.add(this.createToolMenuItem("processing.app.tools.FixEncoding"));
        return menu;
    }

    protected void selectSerialPort(String name) {
        if (serialMenu == null) {
            System.out.println(I18n._("serialMenu is null"));
            return;
        }
        if (name == null) {
            System.out.println(I18n._("name is null"));
            return;
        }
        JCheckBoxMenuItem selection = null;
        for (int i = 0; i < serialMenu.getItemCount(); ++i) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)serialMenu.getItem(i);
            if (item == null) {
                System.out.println(I18n._("name is null"));
                continue;
            }
            item.setState(false);
            if (!name.equals(item.getText())) continue;
            selection = item;
        }
        if (selection != null) {
            selection.setState(true);
        }
        Preferences.set("serial.port", name);
        serialMonitor.closeSerialPort();
        serialMonitor.setVisible(false);
        serialMonitor = new SerialMonitor(Preferences.get("serial.port"));
    }

    protected void populateSerialMenu() {
        serialMenu.removeAll();
        boolean empty = true;
        try {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commportidentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commportidentifier.getPortType() != 1) continue;
                String curr_port = commportidentifier.getName();
                JCheckBoxMenuItem rbMenuItem = new JCheckBoxMenuItem(curr_port, curr_port.equals(Preferences.get("serial.port")));
                rbMenuItem.addActionListener(serialMenuListener);
                serialMenu.add(rbMenuItem);
                empty = false;
            }
            if (!empty) {
                serialMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            System.out.println(I18n._("error retrieving port list"));
            exception.printStackTrace();
        }
        if (serialMenu.getItemCount() == 0) {
            serialMenu.setEnabled(false);
        }
    }

    protected JMenu buildHelpMenu() {
        JMenu menu = new JMenu(I18n._("Help"));
        JMenuItem item = new JMenuItem(I18n._("Getting Started"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.showGettingStarted();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._("Environment"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.showEnvironment();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._("Troubleshooting"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.showTroubleshooting();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._("Reference"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.showReference();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItemShift(I18n._("Find in Reference"), 70);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleFindReference();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(I18n._("Frequently Asked Questions"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.showFAQ();
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._("Visit Energia.nu"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL(I18n._("http://energia.nu/"));
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._("Goto the Support Forum"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL(I18n._("http://energia.nu/forum"));
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._("Goto the Wiki"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL(I18n._("http://energia.nu/wiki"));
            }
        });
        menu.add(item);
        item = new JMenuItem(I18n._("File a Bug"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL(I18n._("http://energia.nu/bugs"));
            }
        });
        menu.add(item);
        if (!Base.isMacOS()) {
            menu.addSeparator();
            item = new JMenuItem(I18n._("About Energia"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.base.handleAbout();
                }
            });
            menu.add(item);
        }
        return menu;
    }

    protected JMenu buildEditMenu() {
        JMenu menu = new JMenu(I18n._("Edit"));
        this.undoItem = Editor.newJMenuItem(I18n._("Undo"), 90);
        this.undoAction = new UndoAction();
        this.undoItem.addActionListener(this.undoAction);
        menu.add(this.undoItem);
        this.redoItem = !Base.isMacOS() ? Editor.newJMenuItem(I18n._("Redo"), 89) : Editor.newJMenuItemShift(I18n._("Redo"), 90);
        this.redoAction = new RedoAction();
        this.redoItem.addActionListener(this.redoAction);
        menu.add(this.redoItem);
        menu.addSeparator();
        JMenuItem item = Editor.newJMenuItem(I18n._("Cut"), 88);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCut();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._("Copy"), 67);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.copy();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItemShift(I18n._("Copy for Forum"), 67);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new DiscourseFormat(Editor.this, false).show();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItemAlt(I18n._("Copy as HTML"), 67);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new DiscourseFormat(Editor.this, true).show();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._("Paste"), 86);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.paste();
                Editor.this.sketch.setModified(true);
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._("Select All"), 65);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.textarea.selectAll();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Editor.newJMenuItem(I18n._("Comment/Uncomment"), 47);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleCommentUncomment();
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._("Increase Indent"), 93);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(true);
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._("Decrease Indent"), 91);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.handleIndentOutdent(false);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = Editor.newJMenuItem(I18n._("Find..."), 70);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setVisible(true);
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._("Find Next"), 71);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findNext();
                }
            }
        });
        menu.add(item);
        item = Editor.newJMenuItemShift(I18n._("Find Previous"), 71);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find != null) {
                    Editor.this.find.findPrevious();
                }
            }
        });
        menu.add(item);
        item = Editor.newJMenuItem(I18n._("Use Selection For Find"), 69);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Editor.this.find == null) {
                    Editor.this.find = new FindReplace(Editor.this);
                }
                Editor.this.find.setFindText(Editor.this.getSelectedText());
            }
        });
        menu.add(item);
        return menu;
    }

    public static JMenuItem newJMenuItem(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers |= 1));
        return menuItem;
    }

    public static JMenuItem newJMenuItemAlt(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_ALT_KEY_MASK));
        return menuItem;
    }

    public void setHandlers(Runnable runHandler, Runnable presentHandler, Runnable stopHandler, Runnable exportHandler, Runnable exportAppHandler, Runnable doFetUpdateHandler) {
        this.doFetUpdateHandler = doFetUpdateHandler;
        this.runHandler = runHandler;
        this.presentHandler = presentHandler;
        this.stopHandler = stopHandler;
        this.exportHandler = exportHandler;
        this.exportAppHandler = exportAppHandler;
    }

    public void resetHandlers() {
        this.doFetUpdateHandler = new DefaultDoFetUpdateHandler();
        this.runHandler = new DefaultRunHandler();
        this.presentHandler = new DefaultPresentHandler();
        this.stopHandler = new DefaultStopHandler();
        this.exportHandler = new DefaultExportHandler();
        this.exportAppHandler = new DefaultExportAppHandler();
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public JEditTextArea getTextArea() {
        return this.textarea;
    }

    public String getText() {
        return this.textarea.getText();
    }

    public String getText(int start, int stop) {
        return this.textarea.getText(start, stop - start);
    }

    public void setText(String what) {
        this.startCompoundEdit();
        this.textarea.setText(what);
        this.stopCompoundEdit();
    }

    public void insertText(String what) {
        this.startCompoundEdit();
        int caret = this.getCaretOffset();
        this.setSelection(caret, caret);
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public String getSelectedText() {
        return this.textarea.getSelectedText();
    }

    public void setSelectedText(String what) {
        this.textarea.setSelectedText(what);
    }

    public void setSelection(int start, int stop) {
        start = PApplet.constrain((int)start, (int)0, (int)this.textarea.getDocumentLength());
        stop = PApplet.constrain((int)stop, (int)0, (int)this.textarea.getDocumentLength());
        this.textarea.select(start, stop);
    }

    public int getCaretOffset() {
        return this.textarea.getCaretPosition();
    }

    public boolean isSelectionActive() {
        return this.textarea.isSelectionActive();
    }

    public int getSelectionStart() {
        return this.textarea.getSelectionStart();
    }

    public int getSelectionStop() {
        return this.textarea.getSelectionStop();
    }

    public String getLineText(int line) {
        return this.textarea.getLineText(line);
    }

    public void setLineText(int line, String what) {
        this.startCompoundEdit();
        this.textarea.select(this.getLineStartOffset(line), this.getLineStopOffset(line));
        this.textarea.setSelectedText(what);
        this.stopCompoundEdit();
    }

    public int getLineStartOffset(int line) {
        return this.textarea.getLineStartOffset(line);
    }

    public int getLineStopOffset(int line) {
        return this.textarea.getLineStopOffset(line);
    }

    public int getLineCount() {
        return this.textarea.getLineCount();
    }

    public void startCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    public void stopCompoundEdit() {
        this.compoundEdit.end();
        this.undo.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        this.compoundEdit = null;
    }

    public int getScrollPosition() {
        return this.textarea.getScrollPosition();
    }

    protected void setCode(SketchCode code) {
        SyntaxDocument document = (SyntaxDocument)code.getDocument();
        if (document == null) {
            document = new SyntaxDocument();
            code.setDocument(document);
            document.setTokenMarker(new PdeKeywords());
            try {
                document.insertString(0, code.getProgram(), null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            document.addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    if (Editor.this.compoundEdit != null) {
                        Editor.this.compoundEdit.addEdit(e.getEdit());
                    } else if (Editor.this.undo != null) {
                        Editor.this.undo.addEdit(e.getEdit());
                        Editor.this.undoAction.updateUndoState();
                        Editor.this.redoAction.updateRedoState();
                    }
                }
            });
        }
        this.textarea.setDocument(document, code.getSelectionStart(), code.getSelectionStop(), code.getScrollPosition());
        this.textarea.requestFocus();
        this.undo = code.getUndo();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    public void handleCut() {
        this.textarea.cut();
        this.sketch.setModified(true);
    }

    public void handleCopy() {
        this.textarea.copy();
    }

    protected void handleDiscourseCopy() {
        new DiscourseFormat(this, false).show();
    }

    protected void handleHTMLCopy() {
        new DiscourseFormat(this, true).show();
    }

    public void handlePaste() {
        this.textarea.paste();
        this.sketch.setModified(true);
    }

    public void handleSelectAll() {
        this.textarea.selectAll();
    }

    protected void handleCommentUncomment() {
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        int length = this.textarea.getDocumentLength();
        boolean commented = true;
        for (int i = startLine; commented && i <= stopLine; ++i) {
            int pos = this.textarea.getLineStartOffset(i);
            if (pos + 2 > length) {
                commented = false;
                continue;
            }
            String begin = this.textarea.getText(pos, 2);
            commented = begin.equals("//");
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartOffset(line);
            if (commented) {
                this.textarea.select(location, location + 2);
                if (!this.textarea.getSelectedText().equals("//")) continue;
                this.textarea.setSelectedText("");
                continue;
            }
            this.textarea.select(location, location);
            this.textarea.setSelectedText("//");
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
    }

    protected void handleIndentOutdent(boolean indent) {
        int tabSize = Preferences.getInteger("editor.tabs.size");
        String tabString = EMPTY.substring(0, tabSize);
        this.startCompoundEdit();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        int lastLineStart = this.textarea.getLineStartOffset(stopLine);
        int selectionStop = this.textarea.getSelectionStop();
        if (selectionStop == lastLineStart && this.textarea.isSelectionActive()) {
            --stopLine;
        }
        for (int line = startLine; line <= stopLine; ++line) {
            int location = this.textarea.getLineStartOffset(line);
            if (indent) {
                this.textarea.select(location, location);
                this.textarea.setSelectedText(tabString);
                continue;
            }
            this.textarea.select(location, location + tabSize);
            if (!this.textarea.getSelectedText().equals(tabString)) continue;
            this.textarea.setSelectedText("");
        }
        this.textarea.select(this.textarea.getLineStartOffset(startLine), this.textarea.getLineStopOffset(stopLine) - 1);
        this.stopCompoundEdit();
    }

    protected void handleFindReference() {
        String text = this.searchReference(this.textarea, true);
        if (text.length() == 0) {
            this.statusNotice(I18n._("First select a word to find in the reference."));
        } else {
            String referenceFile = PdeKeywords.getReference(text);
            if (referenceFile == null) {
                this.statusNotice(I18n.format(I18n._("No reference available for \"{0}\""), text));
            } else {
                Base.showReference(I18n.format(I18n._("{0}.html"), referenceFile));
            }
        }
    }

    public void handleRun(boolean verbose) {
        this.internalCloseRunner();
        this.running = true;
        this.toolbar.activate(0);
        this.status.progress(I18n._("Compiling sketch..."));
        for (int i = 0; i < 10; ++i) {
            System.out.println();
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        new Thread(verbose ? this.presentHandler : this.runHandler).start();
    }

    public void setSketchLocation(Point p) {
        this.sketchWindowLocation = p;
    }

    public Point getSketchLocation() {
        return this.sketchWindowLocation;
    }

    public void handleStop() {
        this.internalCloseRunner();
        this.toolbar.deactivate(0);
        this.toFront();
    }

    public void internalRunnerClosed() {
        this.running = false;
        this.toolbar.deactivate(0);
    }

    public void internalCloseRunner() {
        this.running = false;
        if (this.stopHandler != null) {
            try {
                this.stopHandler.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sketch.cleanup();
    }

    protected boolean checkModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        String prompt = I18n.format(I18n._("Save changes to \"{0}\"?  "), this.sketch.getName());
        if (!Base.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(this, prompt, I18n._("Close"), 1, 3);
            if (result == 0) {
                return this.handleSave(true);
            }
            if (result == 1) {
                return true;
            }
            if (result == 2) {
                return false;
            }
            throw new IllegalStateException();
        }
        JOptionPane pane = new JOptionPane(I18n._("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost."), 3);
        Object[] options = new String[]{I18n._("Save"), I18n._("Cancel"), I18n._("Don't Save")};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(this, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return this.handleSave(true);
        }
        return result == options[2];
    }

    protected void handleOpenUnchecked(String path, int codeIndex, int selStart, int selStop, int scrollPos) {
        this.internalCloseRunner();
        this.handleOpenInternal(path);
        this.untitled = false;
        this.sketch.setCurrentCode(codeIndex);
        this.textarea.select(selStart, selStop);
        this.textarea.setScrollPosition(scrollPos);
    }

    protected boolean handleOpenInternal(String path) {
        File file = new File(path);
        String fileName = file.getName();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        String pdeName = parentName + ".pde";
        File altPdeFile = new File(parent, pdeName);
        String inoName = parentName + ".ino";
        File altInoFile = new File(parent, pdeName);
        if (!pdeName.equals(fileName) && !inoName.equals(fileName)) {
            if (altPdeFile.exists()) {
                path = altPdeFile.getAbsolutePath();
            } else if (altInoFile.exists()) {
                path = altInoFile.getAbsolutePath();
            } else {
                if (!path.endsWith(".ino") && !path.endsWith(".pde")) {
                    Base.showWarning(I18n._("Bad file selected"), I18n._("Processing can only open its own sketches\nand other files ending in .ino or .pde"), null);
                    return false;
                }
                String properParent = fileName.substring(0, fileName.length() - 4);
                Object[] options = new Object[]{I18n._("OK"), I18n._("Cancel")};
                String prompt = I18n.format(I18n._("The file \"{0}\" needs to be inside\na sketch folder named \"{1}\".\nCreate this folder, move the file, and continue?"), fileName, properParent);
                int result = JOptionPane.showOptionDialog(this, prompt, I18n._("Moving"), 0, 3, null, options, options[0]);
                if (result == 0) {
                    File properFolder = new File(file.getParent(), properParent);
                    if (properFolder.exists()) {
                        Base.showWarning(I18n._("Error"), I18n.format(I18n._("A folder named \"{0}\" already exists. Can't open sketch."), properParent), null);
                        return false;
                    }
                    if (!properFolder.mkdirs()) {
                        Base.showWarning(I18n._("Error"), I18n._("Could not create the sketch folder."), null);
                        return false;
                    }
                    File properPdeFile = new File(properFolder, file.getName());
                    File origPdeFile = new File(path);
                    try {
                        Base.copyFile(origPdeFile, properPdeFile);
                    }
                    catch (IOException e) {
                        Base.showWarning(I18n._("Error"), I18n._("Could not copy to a proper location."), e);
                        return false;
                    }
                    origPdeFile.delete();
                    path = properPdeFile.getAbsolutePath();
                } else if (result == 1) {
                    return false;
                }
            }
        }
        try {
            this.sketch = new Sketch(this, path);
        }
        catch (IOException e) {
            Base.showWarning(I18n._("Error"), I18n._("Could not create the sketch."), e);
            return false;
        }
        this.header.rebuild();
        this.setTitle(I18n.format(I18n._("{0} | Energia {1}"), this.sketch.getName(), Base.VERSION_NAME));
        this.untitled = false;
        this.base.storeSketches();
        Preferences.save();
        return true;
    }

    public boolean handleSave(boolean immediately) {
        this.handleStop();
        if (this.untitled) {
            return this.handleSaveAs();
        }
        if (immediately) {
            return this.handleSave2();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Editor.this.handleSave2();
            }
        });
        return true;
    }

    protected boolean handleSave2() {
        this.toolbar.activate(4);
        this.statusNotice(I18n._("Saving..."));
        boolean saved = false;
        try {
            saved = this.sketch.save();
            if (saved) {
                this.statusNotice(I18n._("Done Saving."));
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
        this.toolbar.deactivate(4);
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSaveAs() {
        block6: {
            this.handleStop();
            this.toolbar.activate(4);
            this.statusNotice(I18n._("Saving..."));
            try {
                if (this.sketch.saveAs()) {
                    this.statusNotice(I18n._("Done Saving."));
                    break block6;
                }
                this.statusNotice(I18n._("Save Canceled."));
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.statusError(e);
            }
            finally {
                this.toolbar.deactivate(4);
            }
        }
        return true;
    }

    public boolean serialPrompt() {
        int count = serialMenu.getItemCount();
        Object[] names = new Object[count];
        for (int i = 0; i < count; ++i) {
            names[i] = ((JCheckBoxMenuItem)serialMenu.getItem(i)).getText();
        }
        String result = (String)JOptionPane.showInputDialog(this, I18n.format(I18n._("Serial port {0} not found.\nRetry the upload with another serial port?"), Preferences.get("serial.port")), "Serial port not found", -1, null, names, 0);
        if (result == null) {
            return false;
        }
        this.selectSerialPort(result);
        this.base.onBoardOrPortChange();
        this.console.clear();
        return true;
    }

    public synchronized void handleExport(boolean usingProgrammer, boolean showSerialMonitor) {
        this.toolbar.activate(1);
        this.console.clear();
        this.status.progress(I18n._("Uploading to I/O Board..."));
        if (!usingProgrammer) {
            this.exportHandler = new DefaultExportHandler(showSerialMonitor);
        }
        new Thread(usingProgrammer ? this.exportAppHandler : this.exportHandler).start();
    }

    protected boolean handleExportCheckModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        Object[] options = new Object[]{I18n._("OK"), I18n._("Cancel")};
        int result = JOptionPane.showOptionDialog(this, I18n._("Save changes before export?"), I18n._("Save"), 2, 3, null, options, options[0]);
        if (result != 0) {
            this.statusNotice(I18n._("Export canceled, changes must first be saved."));
            return false;
        }
        this.handleSave(true);
        return true;
    }

    public void handleSerial() {
        if (this.uploading) {
            Editor.serialMonitor.isOpenPending = true;
            return;
        }
        try {
            serialMonitor.openSerialPort();
            serialMonitor.setVisible(true);
        }
        catch (SerialException e) {
            this.statusError(e);
        }
    }

    protected void handleBurnBootloader() {
        this.console.clear();
        this.statusNotice(I18n._("Burning bootloader to I/O Board (this may take a minute)..."));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    AvrdudeUploader uploader = new AvrdudeUploader();
                    if (((Uploader)uploader).burnBootloader()) {
                        Editor.this.statusNotice(I18n._("Done burning bootloader."));
                    } else {
                        Editor.this.statusError(I18n._("Error while burning bootloader."));
                    }
                }
                catch (RunnerException e) {
                    Editor.this.statusError(I18n._("Error while burning bootloader."));
                    e.printStackTrace();
                }
                catch (Exception e) {
                    Editor.this.statusError(I18n._("Error while burning bootloader."));
                    e.printStackTrace();
                }
            }
        });
    }

    protected void handleDoFetUpdate() {
        this.console.clear();
        this.internalCloseRunner();
        this.running = true;
        this.status.progressIndeterminate(I18n._("Updating programmer (this may take a minute)..."));
        for (int i = 0; i < 10; ++i) {
            System.out.println();
        }
        if (Preferences.getBoolean("console.auto_clear")) {
            this.console.clear();
        }
        new Thread(this.doFetUpdateHandler).start();
    }

    public void handlePageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void handlePrint() {
        this.statusNotice(I18n._("Printing..."));
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat != null) {
            this.printerJob.setPrintable(this.textarea.getPainter(), this.pageFormat);
        } else {
            this.printerJob.setPrintable(this.textarea.getPainter());
        }
        this.printerJob.setJobName(this.sketch.getCurrentCode().getPrettyName());
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
                this.statusNotice(I18n._("Done printing."));
            }
            catch (PrinterException pe) {
                this.statusError(I18n._("Error while printing."));
                pe.printStackTrace();
            }
        } else {
            this.statusNotice(I18n._("Printing canceled."));
        }
    }

    public void statusError(String what) {
        this.status.error(what);
        this.toolbar.deactivate(0);
    }

    public void statusError(Exception e) {
        String mess;
        e.printStackTrace();
        if (e instanceof RunnerException) {
            RunnerException re = (RunnerException)e;
            if (re.hasCodeIndex()) {
                this.sketch.setCurrentCode(re.getCodeIndex());
            }
            if (re.hasCodeLine()) {
                int line = re.getCodeLine();
                if (line >= this.textarea.getLineCount() && this.textarea.getLineText(line = this.textarea.getLineCount() - 1).length() == 0) {
                    --line;
                }
                if (line < 0 || line >= this.textarea.getLineCount()) {
                    System.err.println(I18n.format(I18n._("Bad error line: {0}"), line));
                } else {
                    this.textarea.select(this.textarea.getLineStartOffset(line), this.textarea.getLineStopOffset(line) - 1);
                }
            }
        }
        if ((mess = e.getMessage()) != null) {
            String rxString;
            String javaLang = "java.lang.";
            if (mess.indexOf(javaLang) == 0) {
                mess = mess.substring(javaLang.length());
            }
            if (mess.indexOf(rxString = "RuntimeException: ") == 0) {
                mess = mess.substring(rxString.length());
            }
            this.statusError(mess);
        }
    }

    public void statusNotice(String msg) {
        this.status.notice(msg);
    }

    public void statusEmpty() {
        this.statusNotice(EMPTY);
    }

    protected void onArchChanged() {
        this.base.rebuildImportMenu(importMenu);
        this.base.rebuildExamplesMenu(examplesMenu);
    }

    protected void onBoardOrPortChange() {
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        this.lineStatus.setBoardName(boardPreferences.get("name"));
        this.lineStatus.setSerialPort(Preferences.get("serial.port"));
        this.lineStatus.repaint();
    }

    public String searchReference(JEditTextArea jtext) {
        return this.searchReference(jtext, false);
    }

    public String searchReference(JEditTextArea jtext, boolean returnSelection) {
        String t = jtext.getText();
        String ref = null;
        if (t.length() > 0) {
            String sel = "";
            if (jtext.isSelectionActive()) {
                sel = jtext.getSelectedText();
            }
            if (ref == null) {
                int start = Math.max(0, jtext.getCaretPosition() - 1);
                sel = this.findKeyword(t, start, start);
            }
            sel = sel.trim();
            if (returnSelection) {
                return sel;
            }
            if (sel.length() > 0) {
                ref = PdeKeywords.getReference(sel);
            }
        }
        return returnSelection ? "" : ref;
    }

    private boolean isValid(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    private String findKeyword(String text, int start, int end2) {
        int l = text.length();
        if (l > 0) {
            boolean validStart = true;
            boolean validEnd = true;
            if (start > 0 && start < end2 && this.isValid(text.charAt(start))) {
                --start;
                validStart = false;
            }
            if (end2 < l - 1 && this.isValid(text.charAt(end2))) {
                ++end2;
                validEnd = false;
            }
            if (validStart && validEnd) {
                int nend = Math.min(l, end2 + (this.isValid(text.charAt(end2)) ? 1 : 0));
                int nstart = Math.max(0, start + (this.isValid(text.charAt(start)) ? 0 : 1));
                if (nstart < nend && nend - nstart > 0) {
                    return text.substring(nstart, nend);
                }
            } else {
                return this.findKeyword(text, start, end2);
            }
        }
        return "";
    }

    class TextAreaPopup
    extends JPopupMenu {
        private String referenceFile = null;
        private JMenuItem cutItem;
        private JMenuItem copyItem;
        private JMenuItem discourseItem;
        private JMenuItem referenceItem;
        private JMenuItem openURLItem = new JMenuItem(I18n._("Open URL"));
        private JSeparator openURLItemSeparator;
        private String clickedURL;

        public TextAreaPopup() {
            this.openURLItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Base.openURL(TextAreaPopup.this.clickedURL);
                }
            });
            this.add(this.openURLItem);
            this.openURLItemSeparator = new JSeparator();
            this.add(this.openURLItemSeparator);
            this.cutItem = new JMenuItem(I18n._("Cut"));
            this.cutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCut();
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem(I18n._("Copy"));
            this.copyItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCopy();
                }
            });
            this.add(this.copyItem);
            this.discourseItem = new JMenuItem(I18n._("Copy for Forum"));
            this.discourseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleDiscourseCopy();
                }
            });
            this.add(this.discourseItem);
            this.discourseItem = new JMenuItem(I18n._("Copy as HTML"));
            this.discourseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleHTMLCopy();
                }
            });
            this.add(this.discourseItem);
            JMenuItem item = new JMenuItem(I18n._("Paste"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handlePaste();
                }
            });
            this.add(item);
            item = new JMenuItem(I18n._("Select All"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleSelectAll();
                }
            });
            this.add(item);
            this.addSeparator();
            item = new JMenuItem(I18n._("Comment/Uncomment"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleCommentUncomment();
                }
            });
            this.add(item);
            item = new JMenuItem(I18n._("Increase Indent"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(true);
                }
            });
            this.add(item);
            item = new JMenuItem(I18n._("Decrease Indent"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleIndentOutdent(false);
                }
            });
            this.add(item);
            this.addSeparator();
            this.referenceItem = new JMenuItem(I18n._("Find in Reference"));
            this.referenceItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.handleFindReference();
                }
            });
            this.add(this.referenceItem);
        }

        public void show(Component component, int x, int y) {
            int offset2 = Editor.this.textarea.xyToOffset(x, y);
            int lineNo = Editor.this.textarea.getLineOfOffset(offset2);
            int offset = Editor.this.textarea.xToOffset(lineNo, x);
            String line = Editor.this.textarea.getLineText(lineNo);
            this.clickedURL = Editor.this.textarea.checkClickedURL(line, offset);
            if (this.clickedURL != null) {
                this.openURLItem.setVisible(true);
                this.openURLItemSeparator.setVisible(true);
            } else {
                this.openURLItem.setVisible(false);
                this.openURLItemSeparator.setVisible(false);
            }
            if (Editor.this.textarea.isSelectionActive()) {
                int selStart = Editor.this.textarea.getSelectionStart();
                if (selStart >= offset2 || Editor.this.textarea.getSelectedText().length() + selStart <= offset2) {
                    Editor.this.textarea.setCaretPosition(offset2);
                }
            } else {
                Editor.this.textarea.setCaretPosition(offset2);
            }
            this.referenceFile = Editor.this.searchReference(Editor.this.textarea);
            this.referenceItem.setEnabled(this.referenceFile != null);
            super.show(component, x, y);
        }
    }

    class DefaultDoFetUpdateHandler
    implements Runnable {
        DefaultDoFetUpdateHandler() {
        }

        public void run() {
            try {
                MSP430Uploader uploader = new MSP430Uploader(Editor.this);
                if (uploader.doFetUpdate()) {
                    Editor.this.statusNotice(I18n._("Done updating programmer."));
                } else {
                    Editor.this.statusError(I18n._("Error while updating programmer."));
                }
            }
            catch (RunnerException e) {
                Editor.this.statusError(I18n._("Error while burning bootloader."));
                e.printStackTrace();
            }
            catch (Exception e) {
                Editor.this.statusError(I18n._("Error while burning bootloader."));
                e.printStackTrace();
            }
            Editor.this.status.unprogress();
        }
    }

    class DefaultExportAppHandler
    implements Runnable {
        DefaultExportAppHandler() {
        }

        public void run() {
            try {
                serialMonitor.closeSerialPort();
                serialMonitor.setVisible(false);
                Editor.this.uploading = true;
                boolean success = Editor.this.sketch.exportApplet(true);
                if (success) {
                    Editor.this.statusNotice(I18n._("Done uploading."));
                }
            }
            catch (SerialNotFoundException e) {
                Editor.this.populateSerialMenu();
                if (serialMenu.getItemCount() == 0) {
                    Editor.this.statusError(e);
                } else if (Editor.this.serialPrompt()) {
                    this.run();
                } else {
                    Editor.this.statusNotice(I18n._("Upload canceled."));
                }
            }
            catch (RunnerException e) {
                Editor.this.status.unprogress();
                Editor.this.statusError(e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Editor.this.status.unprogress();
            Editor.this.uploading = false;
            Editor.this.toolbar.deactivate(1);
        }
    }

    class DefaultExportHandler
    implements Runnable {
        DefaultExportHandler(Boolean openSerial) {
            Editor.serialMonitor.isOpenPending = openSerial;
        }

        DefaultExportHandler() {
            if (serialMonitor != null) {
                Editor.serialMonitor.isOpenPending = false;
            }
        }

        public void run() {
            try {
                serialMonitor.closeSerialPort();
                serialMonitor.setVisible(false);
                Editor.this.uploading = true;
                boolean success = Editor.this.sketch.exportApplet(false);
                if (success) {
                    Editor.this.statusNotice(I18n._("Done uploading."));
                    if (Editor.serialMonitor.isOpenPending.booleanValue()) {
                        serialMonitor.openSerialPort();
                        serialMonitor.setVisible(true);
                    }
                } else {
                    Editor.this.statusNotice(I18n._("Upload failed."));
                }
            }
            catch (SerialNotFoundException e) {
                Editor.this.populateSerialMenu();
                if (serialMenu.getItemCount() == 0) {
                    Editor.this.statusError(e);
                } else if (Editor.this.serialPrompt()) {
                    this.run();
                } else {
                    Editor.this.statusNotice(I18n._("Upload canceled."));
                }
            }
            catch (RunnerException e) {
                Editor.this.status.unprogress();
                Editor.this.statusError(e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Editor.this.status.unprogress();
            Editor.this.uploading = false;
            Editor.this.toolbar.deactivate(1);
            Editor.serialMonitor.isOpenPending = false;
        }
    }

    class DefaultStopHandler
    implements Runnable {
        DefaultStopHandler() {
        }

        public void run() {
        }
    }

    class DefaultPresentHandler
    implements Runnable {
        DefaultPresentHandler() {
        }

        public void run() {
            try {
                Editor.this.sketch.prepare();
                Editor.this.sketch.build(true);
                Editor.this.statusNotice(I18n._("Done compiling."));
            }
            catch (Exception e) {
                Editor.this.status.unprogress();
                Editor.this.statusError(e);
            }
            Editor.this.status.unprogress();
            Editor.this.toolbar.deactivate(0);
        }
    }

    class DefaultRunHandler
    implements Runnable {
        DefaultRunHandler() {
        }

        public void run() {
            try {
                Editor.this.sketch.prepare();
                Editor.this.sketch.build(false);
                Editor.this.statusNotice(I18n._("Done compiling."));
            }
            catch (Exception e) {
                Editor.this.status.unprogress();
                Editor.this.statusError(e);
            }
            Editor.this.status.unprogress();
            Editor.this.toolbar.deactivate(0);
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.updateRedoState();
            Editor.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (Editor.this.undo.canRedo()) {
                Editor.this.redoItem.setEnabled(true);
                Editor.this.redoItem.setText(Editor.this.undo.getRedoPresentationName());
                this.putValue("Name", Editor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                Editor.this.redoItem.setEnabled(false);
                Editor.this.redoItem.setText(I18n._("Redo"));
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            Editor.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (Editor.this.undo.canUndo()) {
                this.setEnabled(true);
                Editor.this.undoItem.setEnabled(true);
                Editor.this.undoItem.setText(Editor.this.undo.getUndoPresentationName());
                this.putValue("Name", Editor.this.undo.getUndoPresentationName());
                if (Editor.this.sketch != null) {
                    Editor.this.sketch.setModified(true);
                }
            } else {
                this.setEnabled(false);
                Editor.this.undoItem.setEnabled(false);
                Editor.this.undoItem.setText(I18n._("Undo"));
                this.putValue("Name", "Undo");
                if (Editor.this.sketch != null) {
                    Editor.this.sketch.setModified(false);
                }
            }
        }
    }

    class SerialMenuListener
    implements ActionListener {
        SerialMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Editor.this.selectSerialPort(((JCheckBoxMenuItem)e.getSource()).getText());
            Editor.this.base.onBoardOrPortChange();
        }
    }

    class FileDropHandler
    extends TransferHandler {
        FileDropHandler() {
        }

        public boolean canImport(JComponent dest, DataFlavor[] flavors) {
            return true;
        }

        public boolean importData(JComponent src, Transferable transferable) {
            int successful = 0;
            try {
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (int i = 0; i < list.size(); ++i) {
                        File file = (File)list.get(i);
                        if (!Editor.this.sketch.addFile(file)) continue;
                        ++successful;
                    }
                } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                    String data = (String)transferable.getTransferData(uriListFlavor);
                    String[] pieces = PApplet.splitTokens((String)data, (String)"\r\n");
                    for (int i = 0; i < pieces.length; ++i) {
                        if (pieces[i].startsWith("#")) continue;
                        String path = null;
                        if (pieces[i].startsWith("file:///")) {
                            path = pieces[i].substring(7);
                        } else if (pieces[i].startsWith("file:/")) {
                            path = pieces[i].substring(5);
                        }
                        if (!Editor.this.sketch.addFile(new File(path))) continue;
                        ++successful;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (successful == 0) {
                Editor.this.statusError(I18n._("No files were added to the sketch."));
            } else if (successful == 1) {
                Editor.this.statusNotice(I18n._("One file added to the sketch."));
            } else {
                Editor.this.statusNotice(I18n.format(I18n._("{0} files added to the sketch."), successful));
            }
            return true;
        }
    }
}

