/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.PasswordField;
import com.edgytech.swingfast.TextField;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class UserDialog
extends FormDialog {
    public UserDialog() {
        this.setEnumBinding(Item.values(), null);
    }

    String _hash(String username, char[] passwd) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(username.length() + 20 + passwd.length);
        try {
            bout.write(username.getBytes());
            bout.write(":mongo:".getBytes());
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)passwd[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray());
    }

    void resetForEdit(BasicDBObject user) {
        this.xmlLoadCheckpoint();
        this.setStringFieldValue(Item.user, user.getString(Item.user.name()));
        ((TextField)this.getBoundJComponentUnit((Enum)Item.user)).editable = false;
        ((PasswordField)this.getBoundJComponentUnit((Enum)Item.password)).nonEmpty = false;
        this.setStringFieldValue(Item.userSource, user.getString(Item.userSource.name()));
        BasicDBList roles = (BasicDBList)user.get("roles");
        if (roles != null) {
            for (Role role : Role.values()) {
                this.setBooleanFieldValue(role.item, roles.contains(role.name()));
            }
        } else {
            boolean ro = user.getBoolean("readOnly");
            if (ro) {
                this.setBooleanFieldValue(Item.readWrite, true);
            } else {
                this.setBooleanFieldValue(Item.read, true);
            }
        }
        this.updateComponent();
    }

    void resetForNew() {
        this.xmlLoadCheckpoint();
    }

    BasicDBObject getUser(BasicDBObject userObj) {
        String userSrc;
        String pass;
        String user = this.getStringFieldValue(Item.user);
        if (userObj == null) {
            userObj = new BasicDBObject("user", user);
        }
        if (!(pass = this.getStringFieldValue(Item.password)).isEmpty()) {
            userObj.put("pwd", (Object)this._hash(user, pass.toCharArray()));
        }
        if (!(userSrc = this.getStringFieldValue(Item.userSource)).trim().isEmpty()) {
            userObj.put(Item.userSource.name(), (Object)userSrc);
            userObj.removeField("pwd");
        }
        if (!this.getBooleanFieldValue(Item.version22)) {
            BasicDBList roles = new BasicDBList();
            for (Role role : Role.values()) {
                if (!this.getBooleanFieldValue(role.item)) continue;
                roles.add(role.name());
            }
            userObj.put("roles", (Object)roles);
            userObj.removeField("readOnly");
        } else {
            if (!this.getBooleanFieldValue(Item.readWrite)) {
                userObj.put("readOnly", (Object)true);
            }
            userObj.removeField("roles");
        }
        return userObj;
    }

    static enum Role {
        read(Item.read),
        readWrite(Item.readWrite),
        dbAdmin(Item.dbAdmin),
        userAdmin(Item.userAdmin),
        clusterAdmin(Item.clusterAdmin),
        readAnyDatabase(Item.readAnyDatabase),
        readWriteAnyDatabase(Item.readWriteAnyDatabase),
        dbAdminAnyDatabase(Item.dbAdminAnyDatabase),
        userAdminAnyDatabase(Item.userAdminAnyDatabase);

        Item item;

        private Role(Item item) {
            this.item = item;
        }
    }

    static enum Item {
        user,
        password,
        userSource,
        read,
        readWrite,
        dbAdmin,
        userAdmin,
        clusterAdmin,
        readAnyDatabase,
        readWriteAnyDatabase,
        dbAdminAnyDatabase,
        userAdminAnyDatabase,
        version22;

    }
}

