/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.Application;
import com.edgytech.swingfast.ConfirmDialog;
import com.edgytech.swingfast.Frame;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.Scroller;
import com.edgytech.swingfast.TabbedDiv;
import com.edgytech.swingfast.Tree;
import com.edgytech.swingfast.XmlJComponentUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.BinaryDecoder;
import com.edgytech.umongo.CollectionNode;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbNode;
import com.edgytech.umongo.ErrorDialog;
import com.edgytech.umongo.GlobalStore;
import com.edgytech.umongo.IndexNode;
import com.edgytech.umongo.JobBar;
import com.edgytech.umongo.MainMenu;
import com.edgytech.umongo.MainToolBar;
import com.edgytech.umongo.MongoNode;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.PluginClassLoader;
import com.edgytech.umongo.PreferencesDialog;
import com.edgytech.umongo.ReplSetNode;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.RouterNode;
import com.edgytech.umongo.ServerNode;
import com.edgytech.umongo.Workspace;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.jar.JarFile;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.xml.sax.SAXException;

public class UMongo
extends Application
implements Runnable {
    public static final UMongo instance = new UMongo();
    private ArrayList<MongoNode> mongos = new ArrayList();
    boolean stopped = false;
    BaseTreeNode node = null;
    FileWriter activityLogWriter = null;
    boolean activityLogFirstResult = false;
    Handler applicationLogHandler = null;
    String pluginFolder = null;
    BinaryDecoder binaryDecoder = null;
    long _nextTreeUpdate = System.currentTimeMillis();
    ConcurrentLinkedQueue<BaseTreeNode> nodesToRefresh = new ConcurrentLinkedQueue();

    public UMongo() {
        super(true);
        this.setEnumBinding(Item.values(), null);
    }

    Frame getFrame() {
        return (Frame)this.getBoundUnit(Item.frame);
    }

    Workspace getWorkspace() {
        return (Workspace)this.getBoundUnit(Item.workspace);
    }

    Scroller getWorkspaceScroll() {
        return (Scroller)this.getBoundUnit(Item.workspaceScroll);
    }

    Tree getTree() {
        return (Tree)this.getBoundUnit(Item.tree);
    }

    MainMenu getMainMenu() {
        return (MainMenu)this.getBoundUnit(Item.mainMenu);
    }

    PreferencesDialog getPreferences() {
        return this.getMainMenu().getPreferences();
    }

    MainToolBar getMainToolBar() {
        return (MainToolBar)this.getBoundUnit(Item.mainToolBar);
    }

    public void load() throws IOException, SAXException {
        this.xmlLoad(Resource.getXmlDir(), Resource.File.umongo, null);
    }

    public void loadSettings() throws IOException, SAXException {
        try {
            this.xmlLoad(Resource.getConfDir(), Resource.File.umongo, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void saveSettings() {
        try {
            this.xmlSave(Resource.getConfDir(), Resource.File.umongo, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void initialize() {
        try {
            this.load();
            this.loadSettings();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        Thread maintenance = new Thread(this);
        maintenance.setDaemon(true);
        maintenance.start();
    }

    @Override
    public void wrapUp() {
        this.saveSettings();
    }

    public void start() {
        this.getLogger().log(Level.INFO, "UMONGO STARTING");
    }

    public void stop() {
        this.getLogger().log(Level.INFO, "UMONGO STOPPING");
        this.stopped = true;
    }

    public static void main(String[] args) {
        instance.launch();
    }

    GlobalStore getGlobalStore() {
        return (GlobalStore)this.getBoundUnit(Item.globalStore);
    }

    void addMongoClient(MongoClient mongo, List<String> dbs) throws MongoException, UnknownHostException {
        MongoNode node = new MongoNode(mongo, dbs);
        this.getTree().addChild(node);
        this.mongos.add(node);
        this.getTree().structureComponent();
        this.getTree().expandNode(node);
        this.getTree().selectNode(node);
    }

    void disconnect(MongoNode node) {
        this.mongos.remove(node);
        node.removeNode();
        MongoClient mongo = node.getMongoClient();
        mongo.close();
        if (this.mongos.size() > 0) {
            MongoNode other = this.mongos.get(0);
            this.getTree().expandNode(other);
            this.getTree().selectNode(other);
        } else {
            this.displayElement(null);
        }
    }

    public ArrayList<MongoNode> getMongos() {
        return this.mongos;
    }

    void displayElement(XmlJComponentUnit unit) {
        this.getWorkspace().setContent(unit);
    }

    void showError(String in, Exception ex) {
        ErrorDialog dia = this.getGlobalStore().getErrorDialog();
        dia.setException(ex, in);
        dia.show();
    }

    TabbedDiv getTabbedResult() {
        return (TabbedDiv)this.getBoundUnit(Item.tabbedResult);
    }

    void removeAllTabs() {
        TabbedDiv tabs = this.getTabbedResult();
        tabs.removeAllChildren();
        tabs.structureComponent();
    }

    JobBar getJobBar() {
        return (JobBar)this.getBoundUnit(Item.jobBar);
    }

    public void displayNode(BaseTreeNode node) {
        this.node = node;
        BasePanel panel = null;
        if (node instanceof MongoNode) {
            panel = this.getGlobalStore().getMongoPanel();
        } else if (node instanceof DbNode) {
            panel = this.getGlobalStore().getDbPanel();
        } else if (node instanceof CollectionNode) {
            panel = this.getGlobalStore().getCollectionPanel();
        } else if (node instanceof IndexNode) {
            panel = this.getGlobalStore().getIndexPanel();
        } else if (node instanceof ServerNode) {
            panel = this.getGlobalStore().getServerPanel();
        } else if (node instanceof RouterNode) {
            panel = this.getGlobalStore().getRouterPanel();
        } else if (node instanceof ReplSetNode) {
            panel = this.getGlobalStore().getReplSetPanel();
        }
        panel.setNode(node);
        this.displayElement(panel);
    }

    public BaseTreeNode getNode() {
        return this.node;
    }

    public void runJob(DbJob job) {
        this.getJobBar().addJob(job);
        job.start();
    }

    public void removeJob(DbJob job) {
        this.getJobBar().removeJob(job);
    }

    void addNodeToRefresh(BaseTreeNode node) {
        this.nodesToRefresh.add(node);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                long now = System.currentTimeMillis();
                int treeRate = this.getPreferences().getTreeUpdateRate();
                if (treeRate > 0 && this._nextTreeUpdate < now) {
                    this._nextTreeUpdate = now + (long)treeRate;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            long start = System.currentTimeMillis();
                            UMongo.this.getTree().structureComponent();
                            UMongo.this.getLogger().log(Level.FINE, "Tree update took " + (System.currentTimeMillis() - start));
                        }
                    });
                }
                BaseTreeNode node = null;
                while ((node = this.nodesToRefresh.poll()) != null) {
                    node.refresh();
                    final BaseTreeNode fnode = node;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            fnode.updateComponent(false);
                        }
                    });
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        String text;
        ConfirmDialog confirm;
        if (this.getJobBar().hasChildren() && !(confirm = new ConfirmDialog(null, "Confirm Exit", null, text = "There are jobs running, force exit?")).show()) {
            return;
        }
        super.windowClosing(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLogging() {
        UMongo uMongo = this;
        synchronized (uMongo) {
            try {
                Handler handler = this.getPreferences().getApplicationLogHandler();
                if (handler == null) {
                    if (this.applicationLogHandler != null) {
                        Logger.getLogger("").removeHandler(this.applicationLogHandler);
                    }
                } else if (this.applicationLogHandler == null) {
                    Logger.getLogger("").addHandler(handler);
                } else if (!this.applicationLogHandler.equals(handler)) {
                    Logger.getLogger("").removeHandler(this.applicationLogHandler);
                    Logger.getLogger("").addHandler(handler);
                }
                this.applicationLogHandler = handler;
                String logFile = this.getPreferences().getActivityLogFile();
                if (logFile != null) {
                    if (this.activityLogWriter != null) {
                        this.activityLogWriter.close();
                    }
                    this.activityLogWriter = new FileWriter(logFile, true);
                    this.activityLogFirstResult = this.getPreferences().getActivityLogFirstResult();
                } else {
                    if (this.activityLogWriter != null) {
                        this.activityLogWriter.close();
                    }
                    this.activityLogWriter = null;
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.WARNING, null, ex);
            }
        }
    }

    boolean isLoggingOn() {
        return this.activityLogWriter != null;
    }

    boolean isLoggingFirstResultOn() {
        return this.activityLogFirstResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logActivity(DBObject obj) {
        UMongo uMongo = this;
        synchronized (uMongo) {
            try {
                if ("Auth".equals(obj.get("name"))) {
                    return;
                }
                this.activityLogWriter.write(MongoUtils.getJSON(obj));
                this.activityLogWriter.write("\n");
                this.activityLogWriter.flush();
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, null, ex);
            }
        }
    }

    void updatePlugins() {
        String folder = this.getPreferences().getPluginFolder();
        if (folder != null && folder.equals(this.pluginFolder)) {
            return;
        }
        this.pluginFolder = folder;
        this.resetPlugins();
        if (folder == null) {
            return;
        }
        File dir = new File(this.pluginFolder);
        PluginClassLoader cl = new PluginClassLoader(dir);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                try {
                    List<Class> classes = null;
                    File file = files[i];
                    if (file.getPath().endsWith(".jar")) {
                        this.getLogger().info("Attempting to load plugin " + file.getPath());
                        JarFile jar = new JarFile(file);
                        classes = cl.loadClasses(jar);
                    }
                    for (Class c : classes) {
                        Class<?>[] intf = c.getInterfaces();
                        for (int j = 0; j < intf.length; ++j) {
                            BinaryDecoder bd;
                            if (!intf[j].getName().equals("com.edgytech.umongo.BinaryDecoder")) continue;
                            this.getLogger().info("Detected BinaryDecoder plugin in " + c.getCanonicalName());
                            this.binaryDecoder = bd = (BinaryDecoder)c.newInstance();
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.WARNING, null, ex);
                }
            }
        }
    }

    void resetPlugins() {
        this.binaryDecoder = null;
    }

    BinaryDecoder getBinaryDecoder() {
        return this.binaryDecoder;
    }

    @Override
    public void handleMacAbout() {
        ((MenuItem)this.getMainMenu().getBoundUnit(MainMenu.Item.about)).getButton().doClick();
    }

    static enum Item {
        workspace,
        workspaceScroll,
        tree,
        treeScroll,
        mainMenu,
        mainToolBar,
        frame,
        globalStore,
        docViewDialog,
        docTree,
        tabbedResult,
        jobBar;

    }
}

