/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.TabInterface;
import com.edgytech.swingfast.TabbedDiv;
import com.edgytech.swingfast.TextArea;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.Zone;
import com.edgytech.umongo.AutoUpdateDialog;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.UMongo;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TextView
extends Zone
implements EnumListener,
TabInterface,
Runnable {
    TabbedDiv tabbedDiv;
    Thread updateThread;
    int updateInterval;
    int updateCount;
    boolean running;
    DbJob job;

    public TextView(String id, String label, DbJob job) {
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.textView, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.setEnumBinding(Item.values(), this);
        this.setId(id);
        this.setLabel(label);
        this.job = job;
        this.setStringFieldValue(Item.tabTitle, label);
        ((MenuItem)this.getBoundUnit((Enum)Item.refresh)).enabled = true;
        ((MenuItem)this.getBoundUnit((Enum)Item.startAutoUpdate)).enabled = true;
    }

    public TextView(String id, String label, DbJob job, String text) {
        this(id, label, job);
        if (text != null) {
            this.setContent(text);
        }
    }

    public void close(ButtonBase button) {
        this.tabbedDiv.removeTab(this);
    }

    void addToTabbedDiv() {
        this.tabbedDiv = UMongo.instance.getTabbedResult();
        this.tabbedDiv.addTab(this, true);
    }

    public void actionPerformed(Enum enm, XmlComponentUnit unit, Object src) {
    }

    @Override
    public Component getTabComponent() {
        return this.getComponentBoundUnit("tabDiv").getComponent();
    }

    TextArea getTextArea() {
        return (TextArea)this.getBoundUnit(Item.textArea);
    }

    public void startAutoUpdate(ButtonBase button) {
        AutoUpdateDialog dia = UMongo.instance.getGlobalStore().getAutoUpdateDialog();
        if (!dia.show()) {
            return;
        }
        if (this.updateThread != null) {
            this.stopAutoUpdate(null);
        }
        this.updateThread = new Thread(this);
        this.updateInterval = dia.getComponentIntFieldValue(AutoUpdateDialog.Item.autoInterval);
        this.updateCount = dia.getComponentIntFieldValue(AutoUpdateDialog.Item.autoCount);
        this.running = true;
        this.updateThread.start();
        this.getComponentBoundUnit((Enum)Item.stopAutoUpdate).enabled = true;
        this.getComponentBoundUnit(Item.stopAutoUpdate).updateComponent();
    }

    public void stopAutoUpdate(ButtonBase button) {
        this.running = false;
        try {
            this.updateThread.interrupt();
            this.updateThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.updateThread = null;
        this.getComponentBoundUnit((Enum)Item.stopAutoUpdate).enabled = false;
        this.getComponentBoundUnit(Item.stopAutoUpdate).updateComponent();
    }

    @Override
    public void run() {
        int i = 0;
        while (this.running) {
            try {
                DbJob job;
                final DbJob fjob = job = this.getRefreshJob();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        fjob.addJob();
                    }
                });
                try {
                    fjob.join();
                }
                catch (InterruptedException ex) {
                    this.getLogger().log(Level.WARNING, null, ex);
                }
                catch (ExecutionException ex) {
                    this.getLogger().log(Level.WARNING, null, ex);
                }
                if (this.updateCount > 0 && ++i >= this.updateCount) break;
                Thread.sleep(this.updateInterval * 1000);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
        }
        this.getLogger().log(Level.INFO, "Ran " + i + " updates");
    }

    public void refresh(ButtonBase button) {
        this.getRefreshJob().addJob();
    }

    public DbJob getRefreshJob() {
        if (this.job == null) {
            return null;
        }
        DbJob newJob = new DbJob(){
            String result;

            @Override
            public Object doRun() throws Exception {
                this.result = (String)TextView.this.job.doRun();
                return null;
            }

            @Override
            public String getNS() {
                return TextView.this.job.getNS();
            }

            @Override
            public String getShortName() {
                return TextView.this.job.getShortName();
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                if (res == null && this.result != null) {
                    TextView.this.appendContent(this.result);
                    if (TextView.this.job.getPanel() != null) {
                        TextView.this.job.getPanel().refresh();
                    }
                }
            }
        };
        return newJob;
    }

    public void setContent(String text) {
        this.setStringFieldValue(Item.textArea, text);
    }

    public void swapContent(String text) {
        TextArea ta = (TextArea)this.getBoundUnit(Item.textArea);
        int val = ((JScrollPane)ta.getComponent()).getVerticalScrollBar().getValue();
        int max = ((JScrollPane)ta.getComponent()).getVerticalScrollBar().getMaximum();
        int vis = ((JScrollPane)ta.getComponent()).getVerticalScrollBar().getVisibleAmount();
        this.setStringFieldValue(Item.textArea, text);
        this.updateComponent();
        if (val < max - vis) {
            ((JScrollPane)ta.getComponent()).getVerticalScrollBar().setValue(val);
        }
    }

    public void appendContent(String text) {
        int last;
        final TextArea ta = (TextArea)this.getBoundUnit(Item.textArea);
        String old = ta.getComponentStringValue();
        String lastLine = old.substring((last = old.lastIndexOf("\n", old.length() - 5)) + 1);
        int pos = text.indexOf(lastLine);
        if (pos >= 0) {
            text = text.substring(pos + lastLine.length());
        }
        final int val = ((JScrollPane)ta.getComponent()).getVerticalScrollBar().getValue();
        int max = ((JScrollPane)ta.getComponent()).getVerticalScrollBar().getMaximum();
        int vis = ((JScrollPane)ta.getComponent()).getVerticalScrollBar().getVisibleAmount();
        Rectangle rect = ((JScrollPane)ta.getComponent()).getVisibleRect();
        ta.getTextArea().append(text);
        if (val < max - 2 * vis) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JScrollPane)ta.getComponent()).getVerticalScrollBar().setValue(val);
                }
            });
        }
    }

    static enum Item {
        textArea,
        tabDiv,
        tabTitle,
        tabClose,
        refresh,
        export,
        tools,
        startAutoUpdate,
        stopAutoUpdate;

    }
}

