/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.DynamicComboBox;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.umongo.DocBuilderField;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.HashSet;

public class TagRangeDialog
extends FormDialog {
    public TagRangeDialog() {
        this.setEnumBinding(Item.values(), null);
    }

    void resetForEdit(DB config, BasicDBObject range) {
        this.xmlLoadCheckpoint();
        ((DocBuilderField)this.getBoundUnit(Item.min)).setDBObject((DBObject)range.get("min"));
        ((DocBuilderField)this.getBoundUnit((Enum)Item.min)).enabled = false;
        ((DocBuilderField)this.getBoundUnit(Item.max)).setDBObject((DBObject)range.get("max"));
        ((DynamicComboBox)this.getBoundUnit((Enum)Item.tag)).items = TagRangeDialog.getExistingTags(config);
        this.setStringFieldValue(Item.tag, range.getString("tag"));
        this.updateComponent();
    }

    void resetForNew(DB config, String ns) {
        this.xmlLoadCheckpoint();
        DBObject collection = config.getCollection("collections").findOne(new BasicDBObject("_id", ns));
        DBObject shardKey = (DBObject)collection.get("key");
        ((DocBuilderField)this.getBoundUnit(Item.min)).setDBObject(shardKey);
        ((DocBuilderField)this.getBoundUnit(Item.max)).setDBObject(shardKey);
        ((DynamicComboBox)this.getBoundUnit((Enum)Item.tag)).items = TagRangeDialog.getExistingTags(config);
        this.updateComponent();
    }

    BasicDBObject getRange(String ns) {
        DBObject min = ((DocBuilderField)this.getBoundUnit(Item.min)).getDBObject();
        DBObject max = ((DocBuilderField)this.getBoundUnit(Item.max)).getDBObject();
        BasicDBObject range = new BasicDBObject("_id", new BasicDBObject("ns", ns).append("min", min));
        range.put("ns", (Object)ns);
        range.put("min", (Object)min);
        range.put("max", (Object)max);
        range.put("tag", (Object)this.getStringFieldValue(Item.tag));
        return range;
    }

    static String[] getExistingTags(DB config) {
        DBCursor cur = config.getCollection("shards").find();
        HashSet<String> tags = new HashSet<String>();
        while (cur.hasNext()) {
            DBObject shard = cur.next();
            if (!shard.containsField("tags")) continue;
            BasicDBList list = (BasicDBList)shard.get("tags");
            for (Object tag : list) {
                tags.add((String)tag);
            }
        }
        return tags.toArray(new String[tags.size()]);
    }

    static enum Item {
        min,
        max,
        tag;

    }
}

