/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.ConfirmDialog;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.Menu;
import com.edgytech.swingfast.Text;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.CollectionPanel;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbJobCmd;
import com.edgytech.umongo.DocBuilderField;
import com.edgytech.umongo.DocView;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.ReplSetNode;
import com.edgytech.umongo.ReplSetPanel;
import com.edgytech.umongo.ReplicaDialog;
import com.edgytech.umongo.ServerNode;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.JPanel;

public class ServerPanel
extends BasePanel
implements EnumListener<Item> {
    public ServerPanel() {
        this.setEnumBinding(Item.values(), this);
    }

    public ServerNode getServerNode() {
        return (ServerNode)this.getNode();
    }

    @Override
    protected void updateComponentCustom(JPanel comp) {
        try {
            ServerNode node = this.getServerNode();
            if (node.isConfig) {
                ((Menu)this.getBoundUnit((Enum)Item.replica)).enabled = false;
            }
            MongoClient svrMongo = node.getServerMongoClient();
            ServerAddress addr = this.getServerNode().getServerAddress();
            if (addr != null) {
                this.setStringFieldValue(Item.host, addr.toString());
                this.setStringFieldValue(Item.address, addr.getSocketAddress().toString());
            }
            CommandResult res = svrMongo.getDB("local").command("isMaster");
            boolean master = res.getBoolean("ismaster");
            String replication = MongoUtils.makeInfoString("master", master, "secondary", res.getBoolean("secondary"), "passive", res.getBoolean("passive"));
            this.setStringFieldValue(Item.replication, replication);
            ((Text)this.getBoundUnit((Enum)Item.replication)).showIcon = master;
            this.setStringFieldValue(Item.maxObjectSize, String.valueOf(svrMongo.getMaxBsonObjectSize()));
        }
        catch (Exception e) {
            UMongo.instance.showError(this.getClass().getSimpleName() + " update", e);
        }
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void rsStepDown(ButtonBase button) {
        final BasicDBObject cmd = new BasicDBObject("replSetStepDown", (Object)1);
        final DB admin = this.getServerNode().getServerMongoClient().getDB("admin");
        new DbJob(){

            @Override
            public Object doRun() {
                Object res = null;
                try {
                    res = admin.command(cmd);
                }
                catch (MongoException.Network e) {
                    res = "Operation was likely successful, but connection error: " + e.toString();
                }
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException ex) {
                    this.getLogger().log(Level.WARNING, null, ex);
                }
                return res;
            }

            @Override
            public String getNS() {
                return null;
            }

            @Override
            public String getShortName() {
                return "RS Step Down";
            }

            @Override
            public DBObject getRoot(Object result) {
                return cmd;
            }
        }.addJob();
    }

    public void rsFreeze(ButtonBase button) {
        int sec = this.getIntFieldValue(Item.rsFreezeTime);
        BasicDBObject cmd = new BasicDBObject("replSetFreeze", (Object)sec);
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), cmd).addJob();
    }

    public void getLog(ButtonBase button) {
        final DB db = this.getServerNode().getServerMongoClient().getDB("admin");
        String type = this.getStringFieldValue(Item.getLogType);
        final BasicDBObject cmd = new BasicDBObject("getLog", type);
        new DbJob(){

            @Override
            public Object doRun() throws Exception {
                CommandResult res = db.command(cmd);
                res.throwOnError();
                StringBuilder sb = new StringBuilder();
                BasicDBList list = (BasicDBList)res.get("log");
                for (Object str : list) {
                    sb.append(str);
                    sb.append("\n");
                }
                return sb.toString();
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return cmd.keySet().iterator().next();
            }
        }.addJob();
    }

    public void serverStatus(ButtonBase button) {
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), "serverStatus").addJob();
    }

    public void serverBuildInfo(ButtonBase button) {
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), "buildinfo").addJob();
    }

    public void isMaster(ButtonBase button) {
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), "isMaster").addJob();
    }

    public void rsConfig(ButtonBase button) {
        DBCollection col = this.getServerNode().getServerMongoClient().getDB("local").getCollection("system.replset");
        CollectionPanel.doFind(col, null);
    }

    public void rsStatus(ButtonBase button) {
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), "replSetGetStatus").addJob();
    }

    public void rsOplogInfo(ButtonBase button) {
        new DocView(null, "Oplog Info", null, (Object)("Oplog of " + this.getServerNode().getServerAddress()), MongoUtils.getReplicaSetInfo(this.getServerNode().getServerMongoClient())).addToTabbedDiv();
    }

    public void setParameter(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("setParameter", (Object)1);
        DBObject param = ((DocBuilderField)this.getBoundUnit(Item.setParameterValue)).getDBObject();
        cmd.putAll(param);
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), cmd).addJob();
    }

    public void getParameter(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("getParameter", (Object)1);
        String param = this.getStringFieldValue(Item.getParameterValue);
        if ("*".equals(param)) {
            cmd.put("getParameter", (Object)"*");
        } else {
            cmd.put(param, (Object)1);
        }
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), cmd).addJob();
    }

    public void setLogLevel(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("setParameter", (Object)1);
        int level = this.getIntFieldValue(Item.setLogLevelValue);
        cmd.put("logLevel", (Object)level);
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), cmd).addJob();
    }

    public void currentOps(ButtonBase button) {
        MongoClient mongo = this.getServerNode().getServerMongoClient();
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.currentOpsQuery)).getDBObject();
        CollectionPanel.doFind(mongo.getDB("admin").getCollection("$cmd.sys.inprog"), query);
    }

    public void killOp(ButtonBase button) {
        MongoClient mongo = this.getServerNode().getServerMongoClient();
        int opid = this.getIntFieldValue(Item.killOpId);
        BasicDBObject query = new BasicDBObject("op", (Object)opid);
        CollectionPanel.doFind(mongo.getDB("admin").getCollection("$cmd.sys.killop"), query);
    }

    public void rsRemove(ButtonBase button) throws Exception {
        int i;
        ReplSetNode replset = (ReplSetNode)this.getServerNode().getParentNode();
        DBCollection col = replset.getMongoClient().getDB("local").getCollection("system.replset");
        DBObject config = col.findOne();
        BasicDBList members = (BasicDBList)config.get("members");
        String myhost = this.getServerNode().getServerAddress().getHost() + ":" + this.getServerNode().getServerAddress().getPort();
        for (i = 0; i < members.size() && !myhost.equals(((DBObject)members.get(i)).get("host")); ++i) {
        }
        if (i == members.size()) {
            throw new Exception("No such server in configuration");
        }
        members.remove(i);
        ReplSetPanel.reconfigure(replset, config);
    }

    public void initiate(ButtonBase button) {
        DBObject config = ((DocBuilderField)this.getBoundUnit(Item.initConfig)).getDBObject();
        BasicDBObject cmd = new BasicDBObject("replSetInitiate", config);
        DB admin = this.getServerNode().getServerMongoClient().getDB("admin");
        new DbJobCmd(admin, cmd, this, null).addJob();
    }

    public void rsReconfigure(ButtonBase button) throws Exception {
        int i;
        ReplSetNode replset = (ReplSetNode)this.getServerNode().getParentNode();
        DBCollection col = replset.getMongoClient().getDB("local").getCollection("system.replset");
        DBObject config = col.findOne();
        BasicDBList members = (BasicDBList)config.get("members");
        String myhost = this.getServerNode().getServerAddress().getHost() + ":" + this.getServerNode().getServerAddress().getPort();
        for (i = 0; i < members.size() && !myhost.equals(((DBObject)members.get(i)).get("host")); ++i) {
        }
        if (i == members.size()) {
            throw new Exception("No such server in configuration");
        }
        ReplicaDialog dia = UMongo.instance.getGlobalStore().getReplicaDialog();
        BasicDBObject oldConf = (BasicDBObject)members.get(i);
        dia.updateFromReplicaConfig(oldConf);
        if (!dia.show()) {
            return;
        }
        BasicDBObject conf = dia.getReplicaConfig(oldConf.getInt("_id"));
        members.put(i, (Object)conf);
        ReplSetPanel.reconfigure(replset, config);
    }

    public void shutdown(ButtonBase button) {
        ConfirmDialog dia;
        int timeout;
        BasicDBObject cmd = new BasicDBObject("shutdown", (Object)1);
        boolean force = this.getBooleanFieldValue(Item.shutdownForce);
        if (force) {
            cmd.put("force", (Object)force);
        }
        if ((timeout = this.getIntFieldValue(Item.shutdownTimeout)) > 0) {
            cmd.put("timeoutSecs", (Object)timeout);
        }
        if (!(dia = (ConfirmDialog)this.getBoundUnit(Item.shutdownConfirm)).show()) {
            return;
        }
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), cmd).addJob();
    }

    public void logRotate(ButtonBase button) {
        new DbJobCmd(this.getServerNode().getServerMongoClient().getDB("admin"), "logRotate").addJob();
    }

    public void fsync(ButtonBase button) {
        BasicDBObject cmd = new BasicDBObject("fsync", (Object)1);
        DB admin = this.getServerNode().getServerMongoClient().getDB("admin");
        new DbJobCmd(admin, cmd).addJob();
    }

    public void fsyncAndLock(ButtonBase button) {
        if (!UMongo.instance.getGlobalStore().confirmLockingOperation()) {
            return;
        }
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                MongoClient mongo = ServerPanel.this.getServerNode().getServerMongoClient();
                boolean locked = mongo.isLocked();
                if (locked) {
                    return mongo.unlock();
                }
                return mongo.fsyncAndLock();
            }

            @Override
            public String getNS() {
                return null;
            }

            @Override
            public String getShortName() {
                return "FSync And Lock";
            }

            @Override
            public void wrapUp(Object res) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                super.wrapUp(res);
            }
        }.addJob();
    }

    static enum Item {
        icon,
        host,
        address,
        maxObjectSize,
        journaling,
        replication,
        clientPorts,
        rsConfig,
        rsStatus,
        rsOplogInfo,
        refresh,
        rsStepDown,
        rsFreeze,
        rsFreezeTime,
        initiate,
        initConfig,
        rsRemove,
        rsReconfigure,
        isMaster,
        serverStatus,
        serverBuildInfo,
        currentOps,
        currentOpsQuery,
        killOp,
        killOpId,
        getParameter,
        getParameterValue,
        setParameter,
        setParameterValue,
        setLogLevel,
        setLogLevelValue,
        getLog,
        getLogType,
        logRotate,
        replica,
        shutdown,
        shutdownForce,
        shutdownTimeout,
        shutdownConfirm,
        fsync,
        fsyncAndLock;

    }
}

