/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.Resource;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class ServerNode
extends BaseTreeNode {
    String host;
    ServerAddress serverAddress;
    MongoClient serverMongo;
    BasicDBObject stats;
    boolean isReplica = false;
    boolean isConfig = false;

    public ServerNode(MongoClient mongo, boolean isReplica, boolean isConfig) {
        this.serverMongo = mongo;
        this.serverAddress = mongo.getAddress();
        this.setLabel(this.serverAddress != null ? this.serverAddress.toString() : "?");
        this.isReplica = isReplica;
        this.isConfig = isConfig;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.serverNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.markStructured();
    }

    public ServerNode(ServerAddress serverAddress, MongoClientOptions opts, boolean isReplica, boolean isConfig) {
        this.setLabel(serverAddress.toString());
        this.serverAddress = serverAddress;
        this.serverMongo = new MongoClient(serverAddress, opts);
        this.serverMongo.addOption(4);
        this.isReplica = isReplica;
        this.isConfig = isConfig;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.serverNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.markStructured();
    }

    public ServerNode(String host, MongoClientOptions opts, boolean isReplica, boolean isConfig) throws UnknownHostException {
        this.setLabel(host);
        this.host = host;
        this.serverAddress = new ServerAddress(host);
        this.serverMongo = new MongoClient(this.serverAddress, opts);
        this.serverMongo.addOption(4);
        this.isReplica = isReplica;
        this.isConfig = isConfig;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.serverNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.markStructured();
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public MongoClient getServerMongoClient() {
        return this.serverMongo;
    }

    public DB getServerDB() {
        return this.serverMongo.getDB("admin");
    }

    @Override
    protected void populateChildren() {
    }

    @Override
    protected void updateNode() {
        boolean isArbiter = false;
        if (this.stats != null) {
            isArbiter = this.stats.getBoolean("arbiterOnly", false);
            if (isArbiter) {
                this.icon = "a.png";
            } else if (this.stats.getBoolean("ismaster", false)) {
                if (!this.isConfig) {
                    this.addOverlay("overlay/tick_circle_tiny.png");
                }
            } else if (!this.stats.getBoolean("secondary")) {
                this.addOverlay("overlay/error.png");
            }
            if (this.stats.getBoolean("hidden", false)) {
                this.addOverlay("overlay/hidden.png");
            }
        }
        this.label = this.isConfig ? "ConfigDB" : (isArbiter ? "Arbiter" : "MongoD");
        this.label = this.label + ": ";
        this.label = this.host != null ? this.label + this.host : (this.serverAddress != null ? this.label + this.serverAddress.toString() : this.label + "?");
    }

    @Override
    protected void refreshNode() {
        CommandResult res = this.getServerMongoClient().getDB("local").command("isMaster");
        res.throwOnError();
        this.stats = res;
    }

    boolean isReplica() {
        return this.isReplica;
    }

    boolean isConfig() {
        return this.isConfig;
    }
}

