/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.ComboBox;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.InfoDialog;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbJobCmd;
import com.edgytech.umongo.DocBuilderField;
import com.edgytech.umongo.DocField;
import com.edgytech.umongo.RouterNode;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.JPanel;
import org.bson.types.BSONTimestamp;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;

public class RouterPanel
extends BasePanel
implements EnumListener<Item> {
    public RouterPanel() {
        this.setEnumBinding(Item.values(), this);
    }

    RouterNode getRouterNode() {
        return (RouterNode)this.node;
    }

    @Override
    protected void updateComponentCustom(JPanel comp) {
        try {
            ServerAddress addr = this.getRouterNode().getAddress();
            this.setStringFieldValue(Item.host, addr.getHost() + ":" + addr.getPort());
            this.setStringFieldValue(Item.address, addr.getSocketAddress().toString());
            ((DocField)this.getBoundUnit(Item.shards)).setDoc(((RouterNode)this.node).shards);
        }
        catch (Exception e) {
            UMongo.instance.showError(this.getClass().getSimpleName() + " update", e);
        }
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void addShard(ButtonBase button) {
        RouterNode router = this.getRouterNode();
        String host = this.getStringFieldValue(Item.asHost);
        String shardName = this.getStringFieldValue(Item.asShardName);
        String replSetName = this.getStringFieldValue(Item.asReplSetName);
        int maxsize = this.getIntFieldValue(Item.asMaxSize);
        String server = host;
        if (!replSetName.isEmpty()) {
            server = replSetName + "/" + server;
        }
        BasicDBObject cmd = new BasicDBObject("addshard", server);
        if (!shardName.isEmpty()) {
            cmd.put("name", (Object)shardName);
        }
        if (maxsize > 0) {
            cmd.put("maxSize", (Object)maxsize);
        }
        DB db = router.getMongoClient().getDB("admin");
        new DbJobCmd(db, cmd, this, null).addJob();
    }

    public void removeShard(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.removeShard)).getDialog();
        ComboBox combo = (ComboBox)this.getBoundUnit(Item.rsShard);
        combo.value = 0;
        combo.items = this.getRouterNode().getShardNames();
        combo.structureComponent();
        if (!dialog.show()) {
            return;
        }
        BasicDBObject cmd = new BasicDBObject("removeshard", this.getStringFieldValue(Item.rsShard));
        DB db = this.getRouterNode().getMongoClient().getDB("admin");
        new DbJobCmd(db, cmd, this, null).addJob();
    }

    public void listShards(ButtonBase button) {
        new DbJobCmd(this.getRouterNode().getMongoClient().getDB("admin"), "listShards").addJob();
    }

    public void flushConfiguration(ButtonBase button) {
        new DbJobCmd(this.getRouterNode().getMongoClient().getDB("admin"), "flushRouterConfig").addJob();
    }

    public void balancer(ButtonBase button) {
        int stopped;
        MongoClient mongo = this.getRouterNode().getMongoClient();
        DB config = mongo.getDB("config");
        final DBCollection settings = config.getCollection("settings");
        FormDialog diag = (FormDialog)((MenuItem)this.getBoundUnit(Item.balancer)).getDialog();
        diag.xmlLoadCheckpoint();
        final BasicDBObject query = new BasicDBObject("_id", "balancer");
        BasicDBObject balDoc = (BasicDBObject)settings.findOne(query);
        if (balDoc != null) {
            BasicDBObject window;
            if (balDoc.containsField("stopped")) {
                this.setIntFieldValue(Item.balStopped, balDoc.getBoolean("stopped") ? 1 : 2);
            }
            if (balDoc.containsField("_secondaryThrottle")) {
                this.setIntFieldValue(Item.balSecThrottle, balDoc.getBoolean("_secondaryThrottle") ? 1 : 2);
            }
            if ((window = (BasicDBObject)balDoc.get("activeWindow")) != null) {
                this.setStringFieldValue(Item.balStartTime, window.getString("start"));
                this.setStringFieldValue(Item.balStopTime, window.getString("stop"));
            }
        }
        if (!diag.show()) {
            return;
        }
        if (balDoc == null) {
            balDoc = new BasicDBObject("_id", "balancer");
        }
        if ((stopped = this.getIntFieldValue(Item.balStopped)) > 0) {
            balDoc.put("stopped", (Object)(stopped == 1 ? 1 : 0));
        } else {
            balDoc.removeField("stopped");
        }
        int throttle = this.getIntFieldValue(Item.balSecThrottle);
        if (throttle > 0) {
            balDoc.put("_secondaryThrottle", (Object)(throttle == 1 ? 1 : 0));
        } else {
            balDoc.removeField("_secondaryThrottle");
        }
        if (!this.getStringFieldValue(Item.balStartTime).trim().isEmpty()) {
            BasicDBObject aw = new BasicDBObject();
            aw.put("start", (Object)this.getStringFieldValue(Item.balStartTime).trim());
            aw.put("stop", (Object)this.getStringFieldValue(Item.balStopTime).trim());
            balDoc.put("activeWindow", (Object)aw);
        }
        final BasicDBObject newDoc = balDoc;
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return settings.update(query, newDoc, true, false);
            }

            @Override
            public String getNS() {
                return settings.getFullName();
            }

            @Override
            public String getShortName() {
                return "Balancer";
            }

            @Override
            public void wrapUp(Object res) {
                this.updateComponent();
                super.wrapUp(res);
            }
        }.addJob();
    }

    public void regenConfigDB(ButtonBase button) throws UnknownHostException {
        MongoClient cmongo = this.getRouterNode().getMongoClient();
        String servers = this.getStringFieldValue(Item.regenServers);
        final String db = this.getStringFieldValue(Item.regenDB);
        final String col = this.getStringFieldValue(Item.regenCollection);
        final String ns = db + "." + col;
        final DBObject shardKey = ((DocBuilderField)this.getBoundUnit(Item.regenShardKey)).getDBObject();
        boolean unique = this.getBooleanFieldValue(Item.regenKeyUnique);
        final BasicDBObject result = new BasicDBObject();
        result.put("ns", (Object)ns);
        result.put("shardKey", (Object)shardKey);
        result.put("unique", (Object)unique);
        String[] serverList = servers.split("\n");
        ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
        String txt = "";
        String primaryShard = null;
        final BasicDBObject shardList = new BasicDBObject();
        HashMap<MongoClient, String> mongoToShard = new HashMap<MongoClient, String>();
        block0: for (String server : serverList) {
            DBObject index;
            String[] tokens = (server = server.trim()).split("/");
            if (tokens.length != 2) {
                new InfoDialog(null, "Error", null, "Server format must be like 'hostname:port/shard', one by line").show();
                return;
            }
            server = tokens[0];
            String shard = tokens[1];
            if (primaryShard == null) {
                primaryShard = shard;
            }
            ServerAddress addr = new ServerAddress(server);
            for (MongoClient replset : mongoToShard.keySet()) {
                if (!replset.getServerAddressList().contains(addr)) continue;
                continue block0;
            }
            list.clear();
            list.add(addr);
            MongoClient mongo = new MongoClient(list);
            mongo.getDatabaseNames();
            mongoToShard.put(mongo, shard);
            String desc = null;
            desc = !mongo.getDatabaseNames().contains(db) || !mongo.getDB(db).getCollectionNames().contains(col) ? "Collection not present!" : ((index = mongo.getDB(db).getCollection("system.indexes").findOne(new BasicDBObject("key", shardKey))) != null ? "shard key found" : "shard key NOT found!");
            txt = txt + mongo.toString() + " shard=" + shard + " - " + desc + "\n";
            BasicDBObject shardObj = new BasicDBObject("servers", mongo.toString());
            shardObj.put("status", (Object)desc);
            if (shardList.containsField(shard)) {
                new InfoDialog(null, "Error", null, "Duplicate Shard name " + shard).show();
                return;
            }
            shardList.put(shard, (Object)shardObj);
        }
        result.put("shards", (Object)shardList);
        FormDialog dia = (FormDialog)this.getBoundUnit(Item.regenRSList);
        dia.setStringFieldValue(Item.regenRSListArea, txt);
        if (!dia.show()) {
            return;
        }
        DB config = cmongo.getDB("config");
        BasicDBObject doc = new BasicDBObject("_id", db);
        doc.put("partitioned", (Object)true);
        doc.put("primary", (Object)primaryShard);
        config.getCollection("databases").save(doc);
        doc = new BasicDBObject("_id", ns);
        doc.put("lastmod", (Object)new Date());
        doc.put("dropped", (Object)false);
        doc.put("key", (Object)shardKey);
        doc.put("unique", (Object)unique);
        config.getCollection("collections").save(doc);
        final DBCollection chunks = config.getCollection("chunks");
        long count = chunks.count(new BasicDBObject("ns", ns));
        if (count > 0L) {
            dia = (FormDialog)this.getBoundUnit(Item.regenDeleteChunks);
            if (dia.show()) {
                chunks.remove(new BasicDBObject("ns", ns));
            } else {
                return;
            }
        }
        final DBCollection tmpchunks = config.getCollection("_tmpchunks_" + col);
        tmpchunks.drop();
        tmpchunks.setWriteConcern(WriteConcern.NORMAL);
        final BasicDBObject shardKeyFilter = new BasicDBObject();
        boolean hasId = false;
        for (String key : shardKey.keySet()) {
            shardKeyFilter.put(key, (Object)1);
            if (!key.equals("_id")) continue;
            hasId = true;
        }
        if (!hasId) {
            shardKeyFilter.put("_id", (Object)0);
        }
        if (!(dia = (FormDialog)this.getBoundUnit(Item.regenConfirm)).show()) {
            return;
        }
        final AtomicInteger todo = new AtomicInteger(mongoToShard.size());
        for (Map.Entry entry : mongoToShard.entrySet()) {
            final MongoClient mongo = (MongoClient)entry.getKey();
            final String shard = (String)entry.getValue();
            new DbJob(){

                @Override
                public Object doRun() throws Exception {
                    BasicDBObject shardObj = (BasicDBObject)shardList.get(shard);
                    long count = mongo.getDB(db).getCollection(col).count();
                    shardObj.put("count", (Object)count);
                    DBCursor cur = mongo.getDB(db).getCollection(col).find(new BasicDBObject(), shardKeyFilter);
                    long i = 0L;
                    int inserted = 0;
                    long start = System.currentTimeMillis();
                    while (cur.hasNext() && !this.isCancelled()) {
                        BasicDBObject key = (BasicDBObject)cur.next();
                        this.setProgress((int)((float)(++i) * 100.0f / (float)count));
                        try {
                            BasicDBObject entry = new BasicDBObject("_id", key);
                            entry.put("_shard", (Object)shard);
                            tmpchunks.insert(entry);
                            ++inserted;
                        }
                        catch (Exception e) {
                            this.getLogger().log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                    if (this.isCancelled()) {
                        shardObj.put("cancelled", (Object)true);
                    }
                    shardObj.put("inserted", (Object)inserted);
                    shardObj.put("scanTime", (Object)(System.currentTimeMillis() - start));
                    todo.decrementAndGet();
                    return null;
                }

                @Override
                public String getNS() {
                    return tmpchunks.getFullName();
                }

                @Override
                public String getShortName() {
                    return "Scanning " + shard;
                }

                @Override
                public boolean isDeterminate() {
                    return true;
                }
            }.addJob();
        }
        new DbJob(){

            @Override
            public Object doRun() throws Exception {
                long start = System.currentTimeMillis();
                while (todo.get() > 0 && !this.isCancelled()) {
                    Thread.sleep(2000L);
                }
                if (this.isCancelled()) {
                    result.put("cancelled", (Object)true);
                    return result;
                }
                DBCursor cur = chunks.find().sort(new BasicDBObject("lastmod", (Object)-1)).batchSize(-1);
                BasicDBObject chunk = (BasicDBObject)(cur.hasNext() ? cur.next() : null);
                BSONTimestamp ts = (BSONTimestamp)(chunk != null ? chunk.get("lastmod") : null);
                long count = tmpchunks.count();
                result.put("uniqueKeys", (Object)count);
                int numChunks = 0;
                cur = tmpchunks.find().sort(new BasicDBObject("_id", (Object)1));
                BasicDBObject prev = (BasicDBObject)cur.next();
                BasicDBObject next = null;
                BasicDBObject theid = (BasicDBObject)prev.get("_id");
                for (String key : shardKey.keySet()) {
                    theid.put(key, (Object)new MinKey());
                }
                String currentShard = prev.getString("_shard");
                int i = 1;
                while (cur.hasNext()) {
                    next = (BasicDBObject)cur.next();
                    this.setProgress((int)((float)(++i) * 100.0f / (float)count));
                    String newShard = next.getString("_shard");
                    if (newShard.equals(currentShard)) continue;
                    ts = RouterPanel.this.getNextTimestamp(ts);
                    chunk = RouterPanel.this.getChunk(ns, shardKey, prev, next, ts);
                    chunks.insert(chunk);
                    prev = next;
                    currentShard = prev.getString("_shard");
                    ++numChunks;
                }
                next = new BasicDBObject();
                for (String key : shardKey.keySet()) {
                    next.put(key, (Object)new MaxKey());
                }
                next = new BasicDBObject("_id", next);
                ts = RouterPanel.this.getNextTimestamp(ts);
                chunk = RouterPanel.this.getChunk(ns, shardKey, prev, next, ts);
                chunks.insert(chunk);
                result.put("numChunks", (Object)(++numChunks));
                result.put("totalTime", (Object)(System.currentTimeMillis() - start));
                return result;
            }

            @Override
            public String getNS() {
                return chunks.getFullName();
            }

            @Override
            public String getShortName() {
                return "Creating Chunks";
            }

            @Override
            public boolean isDeterminate() {
                return true;
            }
        }.addJob();
    }

    BasicDBObject getChunk(String ns, DBObject shardKey, BasicDBObject min, BasicDBObject max, BSONTimestamp ts) {
        BasicDBObject chunk = new BasicDBObject();
        BasicDBObject themin = (BasicDBObject)min.get("_id");
        BasicDBObject themax = (BasicDBObject)max.get("_id");
        String _id = ns;
        for (String key : shardKey.keySet()) {
            _id = _id + "-" + key + "_";
            Object val = themin.get(key);
            _id = _id + (val != null ? val.toString() : "null");
        }
        chunk.put("_id", (Object)_id);
        chunk.put("lastmod", (Object)ts);
        chunk.put("ns", (Object)ns);
        chunk.put("min", (Object)themin);
        chunk.put("max", (Object)themax);
        chunk.put("shard", (Object)min.getString("_shard"));
        return chunk;
    }

    BSONTimestamp getNextTimestamp(BSONTimestamp ts) {
        if (ts == null) {
            return new BSONTimestamp(1000, 0);
        }
        return new BSONTimestamp(ts.getTime(), ts.getInc() + 1);
    }

    static enum Item {
        refresh,
        host,
        address,
        shards,
        listShards,
        flushConfiguration,
        addShard,
        asHost,
        asShardName,
        asReplSetName,
        asMaxSize,
        removeShard,
        rsShard,
        balancer,
        balStopped,
        balSecThrottle,
        balStartTime,
        balStopTime,
        regenConfigDB,
        regenServers,
        regenDB,
        regenCollection,
        regenShardKey,
        regenKeyUnique,
        regenRSList,
        regenRSListArea,
        regenDeleteChunks,
        regenConfirm;

    }
}

