/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.ReplSetNode;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.ServerNode;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.xml.sax.SAXException;

public class RouterNode
extends BaseTreeNode {
    MongoClient mongo;
    ServerAddress addr;
    BasicDBList shards;

    public RouterNode(ServerAddress addr, MongoClient mongo) throws IOException, SAXException {
        this.addr = addr;
        this.mongo = mongo;
        this.xmlLoad(Resource.getXmlDir(), Resource.File.routerNode, null);
    }

    @Override
    protected void populateChildren() {
        CommandResult res = this.mongo.getDB("admin").command("listShards");
        this.shards = (BasicDBList)res.get("shards");
        if (this.shards == null) {
            return;
        }
        for (Object obj : this.shards) {
            try {
                DBObject shard = (DBObject)obj;
                String shardName = (String)shard.get("_id");
                String hosts = (String)shard.get("host");
                String repl = null;
                int slash = hosts.indexOf(47);
                if (slash >= 0) {
                    repl = hosts.substring(0, slash);
                    hosts = hosts.substring(slash + 1);
                }
                String[] hostList = hosts.split(",");
                ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
                for (String host : hostList) {
                    int colon = host.indexOf(58);
                    if (colon >= 0) {
                        addrs.add(new ServerAddress(host.substring(0, colon), Integer.parseInt(host.substring(colon + 1))));
                        continue;
                    }
                    addrs.add(new ServerAddress(host));
                }
                if (repl != null || addrs.size() > 1) {
                    this.addChild(new ReplSetNode(repl, addrs, this.mongo.getMongoClientOptions(), shardName));
                    continue;
                }
                this.addChild(new ServerNode((ServerAddress)addrs.get(0), this.mongo.getMongoClientOptions(), false, false));
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, null, e);
            }
        }
        try {
            String[] configsvrs;
            res = this.mongo.getDB("admin").command("getCmdLineOpts");
            String configStr = (String)((BasicDBObject)res.get("parsed")).get("configdb");
            for (String host : configsvrs = configStr.split(",")) {
                int colon = host.indexOf(58);
                ServerAddress addr = colon >= 0 ? new ServerAddress(host.substring(0, colon), Integer.parseInt(host.substring(colon + 1))) : new ServerAddress(host);
                this.addChild(new ServerNode(addr, this.mongo.getMongoClientOptions(), false, true));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, null, e);
        }
    }

    public ServerAddress getAddress() {
        return this.addr;
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    @Override
    protected void updateNode() {
        this.label = "MongoS: " + this.mongo.getConnectPoint();
    }

    @Override
    protected void refreshNode() {
    }

    BasicDBList getShards() {
        return this.shards;
    }

    String[] getShardNames() {
        if (!this.shards.isEmpty()) {
            String[] items = new String[this.shards.size()];
            for (int i = 0; i < this.shards.size(); ++i) {
                DBObject shard = (DBObject)this.shards.get(i);
                items[i] = shard.get("_id").toString();
            }
            return items;
        }
        return null;
    }
}

