/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.DynamicComboBox;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.InfoDialog;
import com.edgytech.swingfast.ListArea;
import com.edgytech.swingfast.Menu;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.swingfast.XmlUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.CollectionPanel;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbJobCmd;
import com.edgytech.umongo.DocBuilderField;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.ReplSetNode;
import com.edgytech.umongo.ReplicaDialog;
import com.edgytech.umongo.RouterNode;
import com.edgytech.umongo.ServerNode;
import com.edgytech.umongo.TagRangeDialog;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JPanel;

public class ReplSetPanel
extends BasePanel
implements EnumListener<Item> {
    public ReplSetPanel() {
        this.setEnumBinding(Item.values(), this);
    }

    public ReplSetNode getReplSetNode() {
        return (ReplSetNode)this.node;
    }

    @Override
    protected void updateComponentCustom(JPanel comp) {
        try {
            if (this.getReplSetNode().getShardName() == null) {
                ((Menu)this.getBoundUnit((Enum)Item.sharding)).enabled = false;
            }
            this.setStringFieldValue(Item.name, this.getReplSetNode().getName());
            String replicas = "";
            for (String replica : this.getReplSetNode().getReplicaNames()) {
                replicas = replicas + replica + ",";
            }
            replicas = replicas.substring(0, replicas.length() - 1);
            this.setStringFieldValue(Item.replicas, replicas);
        }
        catch (Exception e) {
            UMongo.instance.showError(this.getClass().getSimpleName() + " update", e);
        }
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void rsConfig(ButtonBase button) {
        DBCollection col = this.getReplSetNode().getMongoClient().getDB("local").getCollection("system.replset");
        CollectionPanel.doFind(col, null);
    }

    public void rsStatus(ButtonBase button) {
        new DbJobCmd(this.getReplSetNode().getMongoClient().getDB("admin"), "replSetGetStatus").addJob();
    }

    public void rsOplogInfo(ButtonBase button) {
        new DbJob(){

            @Override
            public Object doRun() {
                return MongoUtils.getReplicaSetInfo(ReplSetPanel.this.getReplSetNode().getMongoClient());
            }

            @Override
            public String getNS() {
                return null;
            }

            @Override
            public String getShortName() {
                return "Oplog Info";
            }
        }.addJob();
    }

    public void reconfigure(ButtonBase button) {
        DBCollection col = this.getReplSetNode().getMongoClient().getDB("local").getCollection("system.replset");
        DBObject oldConf = col.findOne();
        if (oldConf == null) {
            new InfoDialog(null, "reconfig error", null, "No existing replica set configuration").show();
            return;
        }
        ((DocBuilderField)this.getBoundUnit(Item.reconfConfig)).setDBObject(oldConf);
        if (!((MenuItem)this.getBoundUnit(Item.reconfigure)).getDialog().show()) {
            return;
        }
        DBObject config = ((DocBuilderField)this.getBoundUnit(Item.reconfConfig)).getDBObject();
        ReplSetPanel.reconfigure(this.getReplSetNode(), config);
    }

    public static void reconfigure(final ReplSetNode rsNode, DBObject config) {
        DBCollection col = rsNode.getMongoClient().getDB("local").getCollection("system.replset");
        DBObject oldConf = col.findOne();
        int version = (Integer)oldConf.get("version") + 1;
        config.put("version", version);
        final BasicDBObject cmd = new BasicDBObject("replSetReconfig", config);
        final DB admin = rsNode.getMongoClient().getDB("admin");
        new DbJob(){

            @Override
            public Object doRun() {
                BasicDBObject res = null;
                try {
                    res = admin.command(cmd);
                }
                catch (MongoException.Network e) {
                    res = new BasicDBObject("msg", "Operation was likely successful, but connection was bounced");
                }
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException ex) {
                    this.getLogger().log(Level.WARNING, null, ex);
                }
                return res;
            }

            @Override
            public String getNS() {
                return null;
            }

            @Override
            public String getShortName() {
                return "RS Reconfig";
            }

            @Override
            public DBObject getRoot(Object result) {
                return cmd;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                rsNode.structureComponent();
            }
        }.addJob();
    }

    public void addReplica(ButtonBase button) {
        DBCollection col = this.getReplSetNode().getMongoClient().getDB("local").getCollection("system.replset");
        DBObject config = col.findOne();
        if (config == null) {
            new InfoDialog(null, "reconfig error", null, "No existing replica set configuration").show();
            return;
        }
        BasicDBList members = (BasicDBList)config.get("members");
        int max = 0;
        for (int i = 0; i < members.size(); ++i) {
            int id = (Integer)((DBObject)members.get(i)).get("_id");
            if (id <= max) continue;
            max = id;
        }
        ReplicaDialog dia = UMongo.instance.getGlobalStore().getReplicaDialog();
        if (!dia.show()) {
            return;
        }
        BasicDBObject conf = dia.getReplicaConfig(max + 1);
        members.add(conf);
        ReplSetPanel.reconfigure(this.getReplSetNode(), config);
    }

    public void compareReplicas(ButtonBase button) {
        final String stat = this.getStringFieldValue(Item.crStat);
        new DbJob(){

            @Override
            public Object doRun() {
                ReplSetNode node = ReplSetPanel.this.getReplSetNode();
                if (!node.hasChildren()) {
                    return null;
                }
                ArrayList<MongoClient> svrs = new ArrayList<MongoClient>();
                for (XmlUnit unit : node.getChildren()) {
                    ServerNode svr = (ServerNode)unit;
                    MongoClient svrm = svr.getServerMongoClient();
                    try {
                        svrm.getDatabaseNames();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    svrs.add(svrm);
                }
                BasicDBObject res = new BasicDBObject();
                MongoClient m = ReplSetPanel.this.getReplSetNode().getMongoClient();
                for (String dbname : m.getDatabaseNames()) {
                    DB db = m.getDB(dbname);
                    BasicDBObject dbres = new BasicDBObject();
                    for (String colname : db.getCollectionNames()) {
                        DBCollection col = db.getCollection(colname);
                        BasicDBObject colres = new BasicDBObject();
                        BasicDBObject values = new BasicDBObject();
                        boolean same = true;
                        long ref = -1L;
                        for (MongoClient svrm : svrs) {
                            DBCollection svrcol = svrm.getDB(dbname).getCollection(colname);
                            long value = 0L;
                            if (stat.startsWith("Count")) {
                                value = svrcol.count();
                            } else if (stat.startsWith("Data Size")) {
                                CommandResult stats = svrcol.getStats();
                                value = stats.getLong("size");
                            }
                            values.append(svrm.getConnectPoint(), value);
                            if (ref < 0L) {
                                ref = value;
                                continue;
                            }
                            if (ref == value) continue;
                            same = false;
                        }
                        if (same) continue;
                        colres.append("values", values);
                        dbres.append(colname, colres);
                    }
                    if (dbres.isEmpty()) continue;
                    res.append(dbname, dbres);
                }
                return res;
            }

            @Override
            public String getNS() {
                return "*";
            }

            @Override
            public String getShortName() {
                return "Compare Replicas";
            }
        }.addJob();
    }

    public void queryOplog(ButtonBase button) {
        DBCollection oplog = this.getReplSetNode().getMongoClient().getDB("local").getCollection("oplog.rs");
        DBObject start = ((DocBuilderField)this.getBoundUnit(Item.qoStart)).getDBObject();
        DBObject end = ((DocBuilderField)this.getBoundUnit(Item.qoEnd)).getDBObject();
        DBObject extra = ((DocBuilderField)this.getBoundUnit(Item.qoQuery)).getDBObject();
        BasicDBObject query = new BasicDBObject();
        BasicDBObject range = new BasicDBObject();
        if (start != null) {
            range.put("$gte", start.get("ts"));
        }
        if (end != null) {
            range.put("$lte", end.get("ts"));
        }
        query.put("ts", (Object)range);
        if (extra != null) {
            query.putAll(extra);
        }
        CollectionPanel.doFind(oplog, query, null, null, 0, 0, 0, false, null, 8);
    }

    void refreshTagList() {
        BasicDBList tags;
        String shardName = this.getReplSetNode().getShardName();
        if (shardName == null) {
            return;
        }
        ListArea list = (ListArea)this.getBoundUnit(Item.tagList);
        DB db = ((RouterNode)this.getReplSetNode().getParentNode()).getMongoClient().getDB("config");
        DBObject shard = db.getCollection("shards").findOne(new BasicDBObject("_id", shardName));
        if (shard.containsField("tags") && (tags = (BasicDBList)shard.get("tags")).size() > 0) {
            String[] array = new String[tags.size()];
            int i = 0;
            for (Object tag : tags) {
                array[i++] = (String)tag;
            }
            list.items = array;
            list.structureComponent();
            return;
        }
        list.items = null;
        list.structureComponent();
    }

    public void manageTags(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.manageTags)).getDialog();
        this.refreshTagList();
        dialog.show();
    }

    public void addTag(ButtonBase button) {
        DB config = ((RouterNode)this.getReplSetNode().getParentNode()).getMongoClient().getDB("config");
        final DBCollection col = config.getCollection("shards");
        ((DynamicComboBox)this.getBoundUnit((Enum)Item.atTag)).items = TagRangeDialog.getExistingTags(config);
        FormDialog dia = (FormDialog)button.getDialog();
        if (!dia.show()) {
            return;
        }
        String tag = this.getStringFieldValue(Item.atTag);
        final BasicDBObject query = new BasicDBObject("_id", this.getReplSetNode().getShardName());
        final BasicDBObject update = new BasicDBObject("$addToSet", new BasicDBObject("tags", tag));
        new DbJob(){

            @Override
            public Object doRun() {
                return col.update(query, update);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Add Tag";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("query", query);
                obj.put("update", (Object)update);
                return obj;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                ReplSetPanel.this.refreshTagList();
            }
        }.addJob();
    }

    public void removeTag(ButtonBase button) {
        DB db = ((RouterNode)this.getReplSetNode().getParentNode()).getMongoClient().getDB("config");
        final DBCollection col = db.getCollection("shards");
        String tag = this.getComponentStringFieldValue(Item.tagList);
        if (tag == null) {
            return;
        }
        final BasicDBObject query = new BasicDBObject("_id", this.getReplSetNode().getShardName());
        final BasicDBObject update = new BasicDBObject("$pull", new BasicDBObject("tags", tag));
        new DbJob(){

            @Override
            public Object doRun() {
                return col.update(query, update);
            }

            @Override
            public String getNS() {
                return col.getFullName();
            }

            @Override
            public String getShortName() {
                return "Remove Tag";
            }

            @Override
            public DBObject getRoot(Object result) {
                BasicDBObject obj = new BasicDBObject("query", query);
                obj.put("update", (Object)update);
                return obj;
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                ReplSetPanel.this.refreshTagList();
            }
        }.addJob();
    }

    static enum Item {
        refresh,
        name,
        replicas,
        reconfigure,
        reconfConfig,
        addReplica,
        rsConfig,
        rsStatus,
        rsOplogInfo,
        compareReplicas,
        crStat,
        queryOplog,
        qoStart,
        qoEnd,
        qoQuery,
        sharding,
        manageTags,
        tagList,
        addTag,
        atTag,
        removeTag;

    }
}

