/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.ServerNode;
import com.mongodb.BasicDBList;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.util.List;
import java.util.logging.Level;

public class ReplSetNode
extends BaseTreeNode {
    MongoClient mongo;
    String name;
    String shardName;

    public ReplSetNode(String name, MongoClient mongo, String shardName) {
        this.mongo = mongo;
        this.name = name != null ? name : "Replica Set";
        this.shardName = shardName;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.replSetNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.markStructured();
    }

    public ReplSetNode(String name, List<ServerAddress> addrs, MongoClientOptions opts, String shardName) {
        this.mongo = new MongoClient(addrs, opts);
        this.name = name != null ? name : "Replica Set";
        this.shardName = shardName;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.replSetNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void populateChildren() {
        try {
            this.mongo.getDatabaseNames();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, null, e);
        }
        DBCollection col = this.mongo.getDB("local").getCollection("system.replset");
        DBObject config = col.findOne();
        if (config == null) {
            this.getLogger().log(Level.WARNING, "No replica set configuration found");
            return;
        }
        BasicDBList members = (BasicDBList)config.get("members");
        for (int i = 0; i < members.size(); ++i) {
            String host = (String)((DBObject)members.get(i)).get("host");
            try {
                this.addChild(new ServerNode(host, this.mongo.getMongoClientOptions(), true, false));
                continue;
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, null, e);
            }
        }
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    public String getName() {
        return this.name;
    }

    public String getShardName() {
        return this.shardName;
    }

    @Override
    protected void updateNode() {
        this.label = "";
        if (this.shardName != null) {
            this.label = this.label + "Shard: " + this.shardName + " / ";
        }
        this.label = this.label + "ReplSet: " + this.getName();
    }

    @Override
    protected void refreshNode() {
    }

    String[] getReplicaNames() {
        List<ServerAddress> addrs = this.mongo.getServerAddressList();
        String[] names = new String[addrs.size()];
        int i = 0;
        for (ServerAddress addr : addrs) {
            names[i++] = addr.toString();
        }
        return names;
    }
}

