/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.CheckBox;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.FormDialogListener;
import com.edgytech.swingfast.IntFieldInterface;
import com.edgytech.umongo.UMongo;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

public class PreferencesDialog
extends FormDialog
implements FormDialogListener {
    String trustStorePassword;
    String keyStorePassword;

    public PreferencesDialog() {
        this.setEnumBinding(Item.values(), null);
        this.setFormDialogListener(this);
    }

    public void start() {
        this.formOkCbk();
    }

    @Override
    public void formOkCbk() {
        UMongo.instance.updateLogging();
        UMongo.instance.updatePlugins();
        this.updateSSL();
    }

    @Override
    public void formCancelCbk() {
    }

    @Override
    public void formResetCbk() {
    }

    public boolean getUseSystemLook() {
        return ((CheckBox)this.getBoundUnit(Item.useSystemLook)).getBooleanValue();
    }

    public int getGetMoreSize() {
        return ((IntFieldInterface)((Object)this.getBoundUnit(Item.getMoreSize))).getIntValue();
    }

    public int getInlineDocumentLength() {
        return ((IntFieldInterface)((Object)this.getBoundUnit(Item.inlineDocumentLength))).getIntValue();
    }

    public int getTreeUpdateRate() {
        return ((IntFieldInterface)((Object)this.getBoundUnit(Item.treeUpdateRate))).getIntValue();
    }

    public String getActivityLogFile() {
        String path;
        if (this.getBooleanFieldValue(Item.activityLogFlag) && (path = this.getStringFieldValue(Item.activityLogFile)) != null && !path.trim().isEmpty()) {
            return path;
        }
        return null;
    }

    public boolean getActivityLogFirstResult() {
        return this.getBooleanFieldValue(Item.activityLogFirstResult);
    }

    public Handler getApplicationLogHandler() {
        if (!this.getBooleanFieldValue(Item.applicationLogFlag)) {
            return null;
        }
        String path = this.getStringFieldValue(Item.applicationLogFile);
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        try {
            FileHandler handler = new FileHandler(path, this.getIntFieldValue(Item.applicationLogSize) * 1024 * 1024, this.getIntFieldValue(Item.applicationLogCount), true);
            Level lvl = Level.WARNING;
            String lvlStr = this.getStringFieldValue(Item.applicationLogLevel);
            if (lvlStr.equals("OFF")) {
                lvl = Level.OFF;
            } else if (lvlStr.equals("ALL")) {
                lvl = Level.ALL;
            } else if (lvlStr.equals("INFO")) {
                lvl = Level.INFO;
            } else if (lvlStr.equals("WARNING")) {
                lvl = Level.WARNING;
            } else if (lvlStr.equals("SEVERE")) {
                lvl = Level.SEVERE;
            }
            handler.setLevel(lvl);
            Formatter fmt = new SimpleFormatter();
            if (this.getStringFieldValue(Item.applicationLogFormat).equals("XML")) {
                fmt = new XMLFormatter();
            }
            handler.setFormatter(fmt);
            return handler;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, null, ex);
            return null;
        }
    }

    public String getPluginFolder() {
        if (this.getBooleanFieldValue(Item.allowPlugins)) {
            return this.getStringFieldValue(Item.pluginFolder);
        }
        return null;
    }

    private void updateSSL() {
        this.trustStorePassword = this.updateSSLStore(this.getStringFieldValue(Item.trustStoreFile), "javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", this.trustStorePassword);
        this.keyStorePassword = this.updateSSLStore(this.getStringFieldValue(Item.keyStoreFile), "javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", this.keyStorePassword);
    }

    private String updateSSLStore(String resource, String prop, String propPwd, String oldPwd) {
        if (resource != null && !resource.isEmpty()) {
            resource = resource.trim();
            System.setProperty(prop, resource);
            if (oldPwd == null) {
                String pwd = UMongo.instance.getGlobalStore().promptPassword(resource);
                if (pwd != null) {
                    System.setProperty(propPwd, pwd);
                }
                return pwd;
            }
        } else {
            System.clearProperty(prop);
            System.clearProperty(propPwd);
            return null;
        }
        return oldPwd;
    }

    static enum Item {
        getMoreSize,
        inlineDocumentLength,
        useSystemLook,
        treeUpdateRate,
        activityLog,
        activityLogFlag,
        activityLogFile,
        activityLogFirstResult,
        applicationLog,
        applicationLogFlag,
        applicationLogFile,
        applicationLogSize,
        applicationLogCount,
        applicationLogFormat,
        applicationLogLevel,
        pluginFolder,
        allowPlugins,
        trustStoreFile,
        keyStoreFile;

    }
}

