/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class PluginClassLoader
extends ClassLoader {
    File directory;

    public PluginClassLoader(File dir) {
        this.directory = dir;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    public Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> c = this.findLoadedClass(classname);
            if (c == null) {
                try {
                    c = this.findSystemClass(classname);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (c == null) {
                String filename = classname.replace('.', File.separatorChar) + ".class";
                File f = new File(this.directory, filename);
                int length = (int)f.length();
                byte[] classbytes = new byte[length];
                DataInputStream in = new DataInputStream(new FileInputStream(f));
                in.readFully(classbytes);
                in.close();
                c = this.defineClass(classname, classbytes, 0, length);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(ex.toString());
        }
    }

    public List<Class> loadClasses(JarFile jar) throws ClassNotFoundException, IOException {
        ArrayList<Class> classes = new ArrayList<Class>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            ZipEntry zip = jar.getEntry(entry.getName());
            int len = (int)zip.getSize();
            byte[] bytes = new byte[len];
            DataInputStream is = new DataInputStream(jar.getInputStream(zip));
            is.readFully(bytes);
            Class<?> c = this.defineClass(name.substring(0, name.indexOf(".")), bytes, 0, len);
            boolean resolve = true;
            if (resolve) {
                this.resolveClass(c);
            }
            classes.add(c);
        }
        return classes;
    }
}

