/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.TreeNodeDocumentField;
import com.edgytech.umongo.UMongo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.LazyDBObject;
import com.mongodb.MongoClient;
import com.mongodb.util.JSONSerializers;
import com.mongodb.util.ObjectSerializer;
import java.util.Date;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.bson.LazyDBList;
import org.bson.types.BSONTimestamp;
import org.bson.types.ObjectId;

public class MongoUtils {
    private static JsonParser jsonParser;
    private static Gson gson;

    public static String queryOptionsToString(int options) {
        String opt = "";
        if ((options & 2) != 0) {
            opt = opt + "TAILABLE ";
        }
        if ((options & 4) != 0) {
            opt = opt + "SLAVEOK ";
        }
        if ((options & 8) != 0) {
            opt = opt + "OPLOGREPLAY ";
        }
        if ((options & 0x10) != 0) {
            opt = opt + "NOTIMEOUT ";
        }
        if ((options & 0x20) != 0) {
            opt = opt + "AWAITDATA ";
        }
        if ((options & 0x40) != 0) {
            opt = opt + "EXHAUST ";
        }
        return opt;
    }

    public static void addChildrenToTreeNode(DefaultMutableTreeNode node, DBObject obj) {
        for (String key : obj.keySet()) {
            Object val = obj.get(key);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(new TreeNodeDocumentField(key, val));
            if (val instanceof DBObject) {
                MongoUtils.addChildrenToTreeNode(child, (DBObject)val);
            } else if (val instanceof ObjectId) {
                ObjectId id = (ObjectId)val;
                child.add(new DefaultMutableTreeNode("Time: " + id.getTime() + " = " + new Date(id.getTime()).toString()));
                child.add(new DefaultMutableTreeNode("Machine: " + ((long)id.getMachine() & 0xFFFFFFFFL)));
                child.add(new DefaultMutableTreeNode("Inc: " + ((long)id.getInc() & 0xFFFFFFFFL)));
            }
            node.add(child);
        }
    }

    public static String getObjectString(Object obj) {
        return MongoUtils.getObjectString(obj, 0);
    }

    public static String getObjectString(Object obj, int limit) {
        String str = obj == null ? "null" : (obj instanceof DBObject || obj instanceof byte[] ? MongoUtils.getJSON(obj) : (obj instanceof Double ? String.format("%f", obj) : (obj instanceof String ? "\"" + obj + "\"" : obj.toString())));
        return MongoUtils.limitString(str, limit);
    }

    public static String limitString(String str, int limit) {
        if (limit <= 0) {
            limit = UMongo.instance.getPreferences().getInlineDocumentLength();
        }
        if (str.length() > limit && limit > 0) {
            int max = Math.max(0, limit - 3);
            str = str.substring(0, max) + " ..";
        }
        return str;
    }

    static ObjectSerializer getSerializer() {
        return JSONSerializers.getStrict();
    }

    static String getJSONPreview(Object value) {
        return MongoUtils.limitString(MongoUtils.getSerializer().serialize(value), 80);
    }

    static String getJSON(Object value) {
        return MongoUtils.getSerializer().serialize(value);
    }

    public static DBObject getReplicaSetInfo(MongoClient mongo) {
        String oplogName;
        DB db = mongo.getDB("local");
        BasicDBObject result = new BasicDBObject();
        DBCollection namespaces = db.getCollection("system.namespaces");
        if (namespaces.findOne(new BasicDBObject("name", "local.oplog.rs")) != null) {
            oplogName = "oplog.rs";
        } else if (namespaces.findOne(new BasicDBObject("name", "local.oplog.$main")) != null) {
            oplogName = "oplog.$main";
        } else {
            return null;
        }
        DBObject olEntry = namespaces.findOne(new BasicDBObject("name", "local." + oplogName));
        if (olEntry == null || !olEntry.containsField("options")) {
            return null;
        }
        BasicDBObject options = (BasicDBObject)olEntry.get("options");
        long size = options.getLong("size");
        result.put("logSizeMB", (Object)Float.valueOf(String.format("%.2f", Float.valueOf((float)size / 1048576.0f))));
        DBCollection oplog = db.getCollection(oplogName);
        int size2 = oplog.getStats().getInt("size");
        result.put("usedMB", (Object)Float.valueOf(String.format("%.2f", Float.valueOf((float)size2 / 1048576.0f))));
        DBCursor firstc = oplog.find().sort(new BasicDBObject("$natural", (Object)1)).limit(1);
        DBCursor lastc = oplog.find().sort(new BasicDBObject("$natural", (Object)-1)).limit(1);
        if (!firstc.hasNext() || !lastc.hasNext()) {
            return null;
        }
        BasicDBObject first = (BasicDBObject)firstc.next();
        BasicDBObject last = (BasicDBObject)lastc.next();
        BSONTimestamp tsfirst = (BSONTimestamp)first.get("ts");
        BSONTimestamp tslast = (BSONTimestamp)last.get("ts");
        if (tsfirst == null || tslast == null) {
            return null;
        }
        int ftime = tsfirst.getTime();
        int ltime = tslast.getTime();
        int timeDiffSec = ltime - ftime;
        result.put("timeDiff", (Object)timeDiffSec);
        result.put("timeDiffHours", (Object)Float.valueOf(String.format("%.2f", Float.valueOf((float)timeDiffSec / 3600.0f))));
        result.put("tFirst", (Object)new Date((long)ftime * 1000L));
        result.put("tLast", (Object)new Date((long)ltime * 1000L));
        result.put("now", (Object)new Date());
        return result;
    }

    public static boolean isBalancerOn(MongoClient mongo) {
        DB config = mongo.getDB("config");
        DBCollection settings = config.getCollection("settings");
        BasicDBObject res = (BasicDBObject)settings.findOne(new BasicDBObject("_id", "balancer"));
        if (res == null || !res.containsField("stopped")) {
            return true;
        }
        return !res.getBoolean("stopped");
    }

    static String makeInfoString(Object ... args) {
        String info = "";
        for (int i = 0; i < args.length; i += 2) {
            if (i > 0) {
                info = info + ", ";
            }
            info = info + args[i] + "=[" + args[i + 1] + "]";
        }
        return info;
    }

    public static DBObject checkObject(DBObject o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new IllegalArgumentException("can't be null");
        }
        if (o.isPartialObject() && !query) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        if (!query) {
            MongoUtils.checkKeys(o);
        }
        return o;
    }

    public static void checkKeys(DBObject o) {
        if (o instanceof LazyDBObject || o instanceof LazyDBList) {
            return;
        }
        for (String s : o.keySet()) {
            MongoUtils.validateKey(s);
            Object inner = o.get(s);
            if (inner instanceof DBObject) {
                MongoUtils.checkKeys((DBObject)inner);
                continue;
            }
            if (!(inner instanceof Map)) continue;
            MongoUtils.checkKeys((Map)inner);
        }
    }

    public static void checkKeys(Map<String, Object> o) {
        for (String s : o.keySet()) {
            MongoUtils.validateKey(s);
            Object inner = o.get(s);
            if (inner instanceof DBObject) {
                MongoUtils.checkKeys((DBObject)inner);
                continue;
            }
            if (!(inner instanceof Map)) continue;
            MongoUtils.checkKeys((Map)inner);
        }
    }

    public static void validateKey(String s) {
        if (s.contains(".")) {
            throw new IllegalArgumentException("fields stored in the db can't have . in them. (Bad Key: '" + s + "')");
        }
        if (s.startsWith("$")) {
            throw new IllegalArgumentException("fields stored in the db can't start with '$' (Bad Key: '" + s + "')");
        }
    }

    public static JsonParser getJsonParser() {
        if (jsonParser == null) {
            jsonParser = new JsonParser();
        }
        return jsonParser;
    }

    public static Gson getGson() {
        if (gson == null) {
            gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        }
        return gson;
    }
}

