/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.CollectionPanel;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbJobCmd;
import com.edgytech.umongo.DocBuilderField;
import com.edgytech.umongo.DocField;
import com.edgytech.umongo.MongoNode;
import com.edgytech.umongo.MongoUtils;
import com.edgytech.umongo.OptionDialog;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class MongoPanel
extends BasePanel
implements EnumListener<Item> {
    public MongoPanel() {
        this.setEnumBinding(Item.values(), this);
    }

    public MongoNode getMongoNode() {
        return (MongoNode)this.node;
    }

    private String getServerAddressString(ServerAddress addr) {
        String ip = "unknown";
        try {
            ip = addr.getSocketAddress().getAddress().toString();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(MongoPanel.class.getName()).log(Level.WARNING, null, ex);
        }
        return addr.getHost() + ":" + addr.getPort() + " (" + ip + ")";
    }

    @Override
    protected void updateComponentCustom(JPanel old) {
        try {
            MongoClient mongo = this.getMongoNode().getMongoClient();
            this.setStringFieldValue(Item.version, mongo.getVersion());
            ServerAddress master = mongo.getAddress();
            if (master != null) {
                this.setStringFieldValue(Item.masterServer, this.getServerAddressString(master));
            }
            List<ServerAddress> addrs = mongo.getAllAddress();
            String html = "<html>";
            for (ServerAddress addr : addrs) {
                html = html + this.getServerAddressString(addr) + "<br/>";
            }
            html = html + "</html>";
            this.setStringFieldValue(Item.seedServers, html);
            addrs = mongo.getServerAddressList();
            html = "<html>";
            for (ServerAddress addr : addrs) {
                String txt = this.getServerAddressString(addr);
                html = html + txt + "<br/>";
            }
            this.setStringFieldValue(Item.activeServers, html);
            this.setStringFieldValue(Item.queryOptions, MongoUtils.queryOptionsToString(mongo.getOptions()));
            ((DocField)this.getBoundUnit(Item.writeConcern)).setDoc(mongo.getWriteConcern().getCommand());
            ((DocField)this.getBoundUnit(Item.readPreference)).setDoc(mongo.getReadPreference().toDBObject());
            this.setStringFieldValue(Item.maxObjectSize, String.valueOf(mongo.getMaxBsonObjectSize()));
        }
        catch (Exception e) {
            UMongo.instance.showError(this.getClass().getSimpleName() + " update", e);
        }
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void close(ButtonBase button) {
        UMongo.instance.disconnect(this.getMongoNode());
    }

    public void readWriteOptions(ButtonBase button) {
        MongoClient mongo = this.getMongoNode().getMongoClient();
        OptionDialog od = UMongo.instance.getGlobalStore().getOptionDialog();
        od.update(mongo.getOptions(), mongo.getWriteConcern(), mongo.getReadPreference());
        if (!od.show()) {
            return;
        }
        mongo.setOptions(od.getQueryOptions());
        mongo.setWriteConcern(od.getWriteConcern());
        mongo.setReadPreference(od.getReadPreference());
        this.refresh();
    }

    public void createDB(ButtonBase button) {
        String name = this.getStringFieldValue(Item.createDbName);
        MongoClient mongo = this.getMongoNode().getMongoClient();
        final DB db = mongo.getDB(name);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                db.getStats();
                return null;
            }

            @Override
            public String getNS() {
                return db.getName();
            }

            @Override
            public String getShortName() {
                return "Create DB";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                MongoPanel.this.getMongoNode().structureComponent();
            }
        }.addJob();
    }

    public void authenticate(final ButtonBase button) {
        final MongoClient mongo = this.getMongoNode().getMongoClient();
        final String user = this.getStringFieldValue(Item.authUser);
        final String passwd = this.getStringFieldValue(Item.authPassword);
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                mongo.getDB("admin").authenticateCommand(user, passwd.toCharArray());
                return null;
            }

            @Override
            public String getNS() {
                return "Mongo";
            }

            @Override
            public String getShortName() {
                return "Auth";
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                if (res == null) {
                    MongoPanel.this.refresh();
                }
            }

            @Override
            public ButtonBase getButton() {
                return button;
            }
        }.addJob();
    }

    public void serverStatus(ButtonBase button) {
        new DbJobCmd(this.getMongoNode().getMongoClient().getDB("admin"), "serverStatus").addJob();
    }

    public void showLog(ButtonBase button) {
        new DbJobCmd(this.getMongoNode().getMongoClient().getDB("admin"), new BasicDBObject("getLog", "global")).addJob();
    }

    public void cloneDB(ButtonBase button) {
        MongoClient mongo = this.getMongoNode().getMongoClient();
        String host = this.getStringFieldValue(Item.cloneDBHost);
        String from = this.getStringFieldValue(Item.cloneDBFrom);
        String to = this.getStringFieldValue(Item.cloneDBTo);
        boolean slaveOk = this.getBooleanFieldValue(Item.cloneDBSlaveOk);
        BasicDBObject cmd = new BasicDBObject("copydb", (Object)1);
        cmd.put("fromhost", (Object)host);
        cmd.put("fromdb", (Object)from);
        if (!to.isEmpty()) {
            cmd.put("todb", (Object)to);
        }
        if (slaveOk) {
            cmd.put("slaveOk", (Object)slaveOk);
        }
        new DbJobCmd(mongo.getDB("admin"), cmd, this, null).addJob();
    }

    public void currentOps(ButtonBase button) {
        MongoClient mongo = this.getMongoNode().getMongoClient();
        DBObject query = ((DocBuilderField)this.getBoundUnit(Item.currentOpsQuery)).getDBObject();
        CollectionPanel.doFind(mongo.getDB("admin").getCollection("$cmd.sys.inprog"), query);
    }

    public void killOp(ButtonBase button) {
        MongoClient mongo = this.getMongoNode().getMongoClient();
        int opid = this.getIntFieldValue(Item.killOpId);
        BasicDBObject query = new BasicDBObject("op", (Object)opid);
        CollectionPanel.doFind(mongo.getDB("admin").getCollection("$cmd.sys.killop"), query);
    }

    public void isMaster(ButtonBase button) {
        new DbJobCmd(this.getMongoNode().getMongoClient().getDB("admin"), "isMaster").addJob();
    }

    public void summarizeData(ButtonBase button) {
        final MongoNode mnode = this.getMongoNode();
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                return mnode.summarizeData();
            }

            @Override
            public String getNS() {
                return "Mongo";
            }

            @Override
            public String getShortName() {
                return "Summarize Data";
            }
        }.addJob();
    }

    static enum Item {
        icon,
        version,
        connectPoint,
        masterServer,
        seedServers,
        activeServers,
        queryOptions,
        writeConcern,
        readPreference,
        serverStatus,
        readWriteOptions,
        refresh,
        close,
        createDB,
        createDbName,
        authenticate,
        authUser,
        authPassword,
        maxObjectSize,
        cloneDB,
        cloneDBHost,
        cloneDBFrom,
        cloneDBTo,
        cloneDBSlaveOk,
        currentOps,
        currentOpsQuery,
        killOp,
        killOpId,
        isMaster,
        summarizeData;

    }
}

