/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.DbNode;
import com.edgytech.umongo.ReplSetNode;
import com.edgytech.umongo.Resource;
import com.edgytech.umongo.RouterNode;
import com.edgytech.umongo.ServerNode;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class MongoNode
extends BaseTreeNode {
    MongoClient mongo;
    boolean specifiedDb;
    List<String> dbs;

    public MongoNode(MongoClient mongo, List<String> dbs) {
        this.mongo = mongo;
        this.dbs = dbs;
        this.specifiedDb = dbs != null;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.mongoNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.markStructured();
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    @Override
    protected void populateChildren() {
        List<Object> dbnames = new ArrayList();
        try {
            dbnames = this.mongo.getDatabaseNames();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        List<ServerAddress> addrs = this.mongo.getServerAddressList();
        if (addrs.size() <= 1) {
            CommandResult res;
            boolean added = false;
            ServerAddress serverAddress = addrs.get(0);
            ServerNode node = new ServerNode(this.mongo, false, false);
            try {
                res = node.getServerDB().command("isdbgrid");
                if (res.ok()) {
                    this.addChild(new RouterNode(serverAddress, this.mongo));
                    added = true;
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.INFO, e.getMessage(), e);
            }
            if (this.mongo.getReplicaSetStatus() != null) {
                try {
                    res = node.getServerDB().command((DBObject)new BasicDBObject("isMaster", (Object)1), this.mongo.getOptions());
                    if (res.containsField("setName")) {
                        this.addChild(new ReplSetNode(this.mongo.getReplicaSetStatus().getName(), this.mongo, null));
                        added = true;
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.INFO, e.getMessage(), e);
                }
            }
            if (!added) {
                this.addChild(node);
            }
        } else {
            this.addChild(new ReplSetNode(this.mongo.getReplicaSetStatus().getName(), this.mongo, null));
        }
        if (this.specifiedDb) {
            dbnames = this.dbs;
        } else {
            this.dbs = dbnames;
            if (dbnames.isEmpty()) {
                dbnames.add("test");
            }
        }
        if (dbnames != null) {
            for (String string : dbnames) {
                this.addChild(new DbNode(this.mongo.getDB(string)));
            }
        }
    }

    @Override
    protected void updateNode() {
        this.label = "Mongo: ?";
        this.label = "Mongo: " + this.mongo.getConnectPoint();
    }

    @Override
    protected void refreshNode() {
        this.mongo.getDatabaseNames();
    }

    BasicDBList getShards() {
        Object child = this.getChild(0);
        if (child instanceof RouterNode) {
            return ((RouterNode)child).getShards();
        }
        return null;
    }

    String[] getShardNames() {
        Object child = this.getChild(0);
        if (child instanceof RouterNode) {
            return ((RouterNode)child).getShardNames();
        }
        return null;
    }

    List<DBObject> summarizeData() {
        ArrayList<DBObject> global = new ArrayList<DBObject>();
        for (DbNode node : this.getChildrenOfClass(DbNode.class)) {
            List<DBObject> res = node.summarizeData();
            global.addAll(res);
        }
        return global;
    }
}

