/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.ListArea;
import com.edgytech.swingfast.MenuBar;
import com.edgytech.swingfast.ProgressDialog;
import com.edgytech.swingfast.ProgressDialogWorker;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.ConnectDialog;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DocumentDeserializer;
import com.edgytech.umongo.ImportDialog;
import com.edgytech.umongo.PreferencesDialog;
import com.edgytech.umongo.UMongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class MainMenu
extends MenuBar
implements EnumListener<Item> {
    public MainMenu() {
        this.setEnumBinding(Item.values(), this);
    }

    PreferencesDialog getPreferences() {
        return (PreferencesDialog)this.getBoundUnit(Item.prefDialog);
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void start() {
    }

    public void importFile(ButtonBase button) throws IOException {
        ImportDialog dia = UMongo.instance.getGlobalStore().getImportDialog();
        if (!dia.show()) {
            return;
        }
        boolean continueOnError = dia.getBooleanFieldValue(ImportDialog.Item.continueOnError);
        final DocumentDeserializer dd = dia.getDocumentDeserializer();
        new DbJob(){

            @Override
            public Object doRun() throws Exception {
                return dd.iterator();
            }

            @Override
            public String getNS() {
                return dd.getFile().getName();
            }

            @Override
            public String getShortName() {
                return "Import";
            }
        }.addJob();
    }

    void refreshConnectPointsList(String select) {
        ListArea list = (ListArea)this.getBoundUnit(Item.connectPointsList);
        list.items = list.xmlGetLocalCopiesIds();
        if (list.items == null || list.items.length == 0) {
            list.items = new String[1];
            list.items[0] = "Default";
        }
        if (select != null) {
            this.setStringFieldValue(Item.connectPointsList, select);
        }
        list.structureComponent();
    }

    public void connect(ButtonBase button) {
        this.refreshConnectPointsList(null);
        FormDialog dia = (FormDialog)button.getDialog();
        if (dia.show()) {
            ListArea list = (ListArea)this.getBoundUnit(Item.connectPointsList);
            ConnectDialog dialog = (ConnectDialog)this.getBoundUnit(Item.connectDialog);
            String id = this.getComponentStringFieldValue(Item.connectPointsList);
            dialog.setId(id);
            list.xmlLoadLocalCopy(dialog, null, null);
            dialog.setId(Item.connectDialog.name());
            dialog.setName(id);
            this.connect();
        }
    }

    public void editConnectPoint(ButtonBase button) {
        ListArea list = (ListArea)this.getBoundUnit(Item.connectPointsList);
        ConnectDialog dialog = (ConnectDialog)this.getBoundUnit(Item.connectDialog);
        String id = this.getComponentStringFieldValue(Item.connectPointsList);
        dialog.setId(id);
        list.xmlLoadLocalCopy(dialog, null, null);
        dialog.setId(Item.connectDialog.name());
        dialog.setName(id);
        if (dialog.show()) {
            String newId = dialog.getName();
            dialog.setId(newId);
            list.xmlSaveLocalCopy(dialog, null, null);
            dialog.setId(Item.connectDialog.name());
            this.refreshConnectPointsList(newId);
        }
    }

    public void removeConnectPoint(ButtonBase button) {
        ListArea list = (ListArea)this.getBoundUnit(Item.connectPointsList);
        String id = this.getComponentStringFieldValue(Item.connectPointsList);
        if (id != null) {
            list.xmlRemoveLocalCopy(id);
            this.refreshConnectPointsList(null);
        }
    }

    public void connect() {
        try {
            ConnectDialog dialog = (ConnectDialog)this.getBoundUnit(Item.connectDialog);
            ProgressDialog progress = (ProgressDialog)this.getBoundUnit(Item.connectProgressDialog);
            MongoClient mongo = null;
            ArrayList<String> dbs = new ArrayList<String>();
            String uri = dialog.getStringFieldValue(ConnectDialog.Item.uri);
            if (!uri.trim().isEmpty()) {
                if (!uri.startsWith("mongodb://")) {
                    uri = "mongodb://" + uri;
                }
                MongoClientURI muri = new MongoClientURI(uri);
                mongo = new MongoClient(muri);
                String db = muri.getDatabase();
                if (db != null && !db.trim().isEmpty()) {
                    dbs.add(db.trim());
                }
            } else {
                String servers = dialog.getStringFieldValue(ConnectDialog.Item.servers);
                if (servers.trim().isEmpty()) {
                    return;
                }
                String[] serverList = servers.split(",");
                ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
                for (String server : serverList) {
                    String[] tmp = server.split(":");
                    if (tmp.length > 1) {
                        addrs.add(new ServerAddress(tmp[0], (int)Integer.valueOf(tmp[1])));
                        continue;
                    }
                    addrs.add(new ServerAddress(tmp[0]));
                }
                mongo = "Direct".equals(dialog.getStringFieldValue(ConnectDialog.Item.connectionMode)) ? new MongoClient((ServerAddress)addrs.get(0), dialog.getMongoClientOptions()) : new MongoClient(addrs, dialog.getMongoClientOptions());
                String sdbs = dialog.getStringFieldValue(ConnectDialog.Item.databases);
                if (!sdbs.trim().isEmpty()) {
                    for (String db : sdbs.split(",")) {
                        dbs.add(db.trim());
                    }
                }
            }
            if (dbs.size() == 0) {
                dbs = null;
            }
            String user = dialog.getStringFieldValue(ConnectDialog.Item.user).trim();
            String password = dialog.getStringFieldValue(ConnectDialog.Item.password);
            if (!user.isEmpty()) {
                if (dbs != null) {
                    for (String db : dbs) {
                        mongo.getDB(db).authenticate(user, password.toCharArray());
                    }
                } else {
                    mongo.getDB("admin").authenticate(user, password.toCharArray());
                }
            }
            final MongoClient fmongo = mongo;
            final ArrayList<String> fdbs = dbs;
            progress.show(new ProgressDialogWorker(progress){

                @Override
                protected void finished() {
                }

                @Override
                protected Object doInBackground() throws Exception {
                    UMongo.instance.addMongoClient(fmongo, fdbs);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            UMongo.instance.showError(this.id, ex);
        }
    }

    public void exit(ButtonBase button) {
        UMongo.instance.windowClosing(null);
    }

    public void closeAllTabs(ButtonBase button) {
        UMongo.instance.removeAllTabs();
    }

    public void about(ButtonBase button) throws IOException {
        FormDialog dia = (FormDialog)button.getDialog();
        StringBuilder text = new StringBuilder();
        text.append("<html>");
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        while (urls.hasMoreElements()) {
            String str;
            String jar;
            int end;
            URL url = urls.nextElement();
            if (!url.getPath().contains("umongo") || (end = (jar = url.getPath()).indexOf(".jar")) < 0) continue;
            jar = jar.substring(0, end + 4);
            int start = jar.lastIndexOf("/");
            jar = jar.substring(start + 1);
            text.append("<b>").append(jar).append("</b>").append(":<br/>");
            BufferedReader d = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((str = d.readLine()) != null) {
                text.append(str).append("<br/>");
            }
            text.append("<br/>");
        }
        text.append("</html>");
        this.setStringFieldValue(Item.aboutTextArea, text.toString());
        dia.show();
    }

    public static enum Item {
        connect,
        connectPointsList,
        connectDialog,
        editConnectPoint,
        removeConnectPoint,
        connectProgressDialog,
        exit,
        preferences,
        prefDialog,
        importFile,
        about,
        aboutTextArea,
        closeAllTabs;

    }
}

