/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.ButtonBase;
import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.FormDialog;
import com.edgytech.swingfast.MenuItem;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.BasePanel;
import com.edgytech.umongo.DbJob;
import com.edgytech.umongo.DbJobCmd;
import com.edgytech.umongo.DocField;
import com.edgytech.umongo.IndexNode;
import com.edgytech.umongo.UMongo;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import javax.swing.JPanel;

public class IndexPanel
extends BasePanel
implements EnumListener<Item> {
    public IndexPanel() {
        this.setEnumBinding(Item.values(), this);
    }

    public IndexNode getIndexNode() {
        return (IndexNode)this.getNode();
    }

    public DBObject getIndexInfo() {
        BasicDBObject match = new BasicDBObject();
        match.put("ns", (Object)this.getIndexNode().getIndexedCollection().getFullName());
        match.put("key", (Object)this.getIndexNode().getKey());
        return this.getIndexNode().getCollectionNode().getCollection().getDB().getCollection("system.indexes").findOne(match);
    }

    @Override
    protected void updateComponentCustom(JPanel comp) {
        try {
            DBObject index = this.getIndexInfo();
            this.setStringFieldValue(Item.name, (String)index.get("name"));
            this.setStringFieldValue(Item.ns, (String)index.get("ns"));
            ((DocField)this.getBoundUnit(Item.key)).setDoc((DBObject)index.get("key"));
            ((DocField)this.getBoundUnit(Item.info)).setDoc(index);
        }
        catch (Exception e) {
            UMongo.instance.showError(this.getClass().getSimpleName() + " update", e);
        }
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
    }

    public void drop(ButtonBase button) {
        final IndexNode indexNode = this.getIndexNode();
        new DbJob(){

            @Override
            public Object doRun() throws IOException {
                indexNode.getCollectionNode().getCollection().dropIndex(indexNode.getName());
                return null;
            }

            @Override
            public String getNS() {
                return IndexPanel.this.getIndexNode().getIndexedCollection().getFullName();
            }

            @Override
            public String getShortName() {
                return "Drop Index";
            }

            @Override
            public DBObject getRoot(Object result) {
                return indexNode.getIndex();
            }

            @Override
            public void wrapUp(Object res) {
                super.wrapUp(res);
                indexNode.removeNode();
            }
        }.addJob();
    }

    public void getStats(ButtonBase button) {
        new DbJobCmd(this.getIndexNode().getStatsCollection(), "collstats").addJob();
    }

    public void settings(ButtonBase button) {
        FormDialog dialog = (FormDialog)((MenuItem)this.getBoundUnit(Item.settings)).getDialog();
        BasicDBObject index = (BasicDBObject)this.getIndexInfo();
        boolean isTTL = false;
        long ttl = 0L;
        if (index.containsField("expireAfterSeconds")) {
            isTTL = true;
            ttl = index.getLong("expireAfterSeconds");
        }
        this.setLongFieldValue(Item.expireAfterSeconds, ttl);
        if (!dialog.show()) {
            return;
        }
        long newTTL = this.getLongFieldValue(Item.expireAfterSeconds);
        if (newTTL != ttl) {
            BasicDBObject cmd = new BasicDBObject("collMod", this.getIndexNode().getCollectionNode().getCollection().getName());
            BasicDBObject param = new BasicDBObject();
            param.put("keyPattern", (Object)((DBObject)index.get("key")));
            param.put("expireAfterSeconds", (Object)newTTL);
            cmd.put("index", (Object)param);
            new DbJobCmd(this.getIndexNode().getCollectionNode().getCollection().getDB(), cmd).addJob();
        }
    }

    static enum Item {
        icon,
        name,
        ns,
        key,
        info,
        getStats,
        refresh,
        drop,
        settings,
        expireAfterSeconds;

    }
}

