/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.umongo.BaseTreeNode;
import com.edgytech.umongo.CollectionNode;
import com.edgytech.umongo.Resource;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.logging.Level;

public class IndexNode
extends BaseTreeNode {
    DBCollection indexedCol;
    DBObject index;
    BasicDBObject stats;

    public IndexNode(DBCollection indexedCol, DBObject index) {
        this.indexedCol = indexedCol;
        this.index = index;
        try {
            this.xmlLoad(Resource.getXmlDir(), Resource.File.indexNode, null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.markStructured();
    }

    public DBObject getIndex() {
        return this.index;
    }

    public DBCollection getIndexedCollection() {
        return this.indexedCol;
    }

    public DBCollection getStatsCollection() {
        return this.indexedCol.getDB().getCollection(this.indexedCol.getName() + ".$" + this.getName());
    }

    public String getName() {
        return (String)this.index.get("name");
    }

    public DBObject getKey() {
        return (DBObject)this.index.get("key");
    }

    public CollectionNode getCollectionNode() {
        return (CollectionNode)this.getParentNode();
    }

    @Override
    protected void populateChildren() {
    }

    @Override
    protected void updateNode() {
        this.label = this.getName();
        if (this.stats != null) {
            this.label = this.label + " (" + this.stats.getInt("count") + "/" + this.stats.getInt("size") + ")";
        }
    }

    @Override
    protected void refreshNode() {
        CommandResult res = this.getStatsCollection().getStats();
        res.throwOnError();
        this.stats = res;
    }
}

