/*
 * Decompiled with CFR 0.152.
 */
package com.edgytech.umongo;

import com.edgytech.swingfast.EnumListener;
import com.edgytech.swingfast.XmlComponentUnit;
import com.edgytech.umongo.EditFieldDialog;
import com.mongodb.DBRef;
import com.mongodb.DBRefBase;
import javax.swing.JDialog;
import org.bson.types.ObjectId;

public class EditObjectIdDialog
extends EditFieldDialog
implements EnumListener<Item> {
    public EditObjectIdDialog() {
        this.setEnumBinding(Item.values(), this);
    }

    @Override
    public Object getValue() {
        String str = this.getStringFieldValue(Item.string);
        ObjectId id = null;
        if (!str.isEmpty()) {
            id = new ObjectId(str);
        } else {
            int time = this.getIntFieldValue(Item.time);
            int machine = this.getIntFieldValue(Item.machine);
            int inc = this.getIntFieldValue(Item.inc);
            id = new ObjectId(time, machine, inc);
        }
        String ns = this.getStringFieldValue(Item.namespace);
        if (ns.trim().isEmpty()) {
            return id;
        }
        return new DBRef(null, ns, id);
    }

    @Override
    public void setValue(Object value) {
        ObjectId id = null;
        if (value instanceof DBRefBase) {
            DBRefBase ref = (DBRefBase)value;
            this.setStringFieldValue(Item.namespace, ref.getRef());
            id = (ObjectId)ref.getId();
        } else {
            id = (ObjectId)value;
        }
        this.setStringFieldValue(Item.string, id.toString());
        this.setIntFieldValue(Item.time, id._time());
        this.setIntFieldValue(Item.machine, id.getMachine());
        this.setIntFieldValue(Item.inc, id.getInc());
    }

    @Override
    protected void updateComponentCustom(JDialog old) {
        super.updateComponentCustom(old);
        this.setStringFieldValue(Item.currentTime, String.valueOf(System.currentTimeMillis() / 1000L));
        this.setStringFieldValue(Item.currentMachine, String.valueOf(ObjectId.getGenMachineId()));
        this.setStringFieldValue(Item.currentInc, String.valueOf(ObjectId.getCurrentInc()));
    }

    @Override
    public void actionPerformed(Item enm, XmlComponentUnit unit, Object src) {
        switch (enm) {
            case string: {
                String str = this.getComponentStringFieldValue(Item.string);
                if (str.isEmpty()) break;
                ObjectId oid = new ObjectId(str);
                this.setComponentIntFieldValue(Item.time, oid.getTimeSecond());
                this.setComponentIntFieldValue(Item.machine, oid.getMachine());
                this.setComponentIntFieldValue(Item.inc, oid.getInc());
                break;
            }
            case time: 
            case machine: 
            case inc: {
                int time = this.getComponentIntFieldValue(Item.time);
                int machine = this.getComponentIntFieldValue(Item.machine);
                int inc = this.getComponentIntFieldValue(Item.inc);
                ObjectId oid = new ObjectId(time, machine, inc);
                this.setComponentStringFieldValue(Item.string, oid.toString());
            }
        }
    }

    static enum Item {
        string,
        time,
        machine,
        inc,
        currentTime,
        currentMachine,
        currentInc,
        namespace;

    }
}

